/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba.packets;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Map;
import me.modmuss50.ftba.ConfigManager;
import me.modmuss50.ftba.client.ClientDataManager;
import me.modmuss50.ftba.files.runs.AchievementData;
import me.modmuss50.ftba.files.runs.RunData;
import me.modmuss50.ftba.files.runs.RunManager;
import me.modmuss50.ftba.files.worldData.WorldFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import reborncore.common.network.ExtendedPacketBuffer;
import reborncore.common.network.INetworkPacket;

public class PacketSaveData
implements INetworkPacket<PacketSaveData> {
    String data;
    long time;
    String players;
    String worldHash;

    public PacketSaveData() {
    }

    public PacketSaveData(String data, long time, String players, String worldHash) {
        this.data = data;
        this.time = time;
        this.players = players;
        this.worldHash = worldHash;
    }

    public void writeData(ExtendedPacketBuffer extendedPacketBuffer) throws IOException {
        extendedPacketBuffer.writeInt(this.data.length());
        extendedPacketBuffer.func_180714_a(this.data);
        extendedPacketBuffer.writeLong(this.time);
        extendedPacketBuffer.writeInt(this.players.length());
        extendedPacketBuffer.func_180714_a(this.players);
        extendedPacketBuffer.writeInt(this.worldHash.length());
        extendedPacketBuffer.func_180714_a(this.worldHash);
    }

    public void readData(ExtendedPacketBuffer extendedPacketBuffer) throws IOException {
        this.data = extendedPacketBuffer.func_150789_c(extendedPacketBuffer.readInt());
        this.time = extendedPacketBuffer.readLong();
        this.players = extendedPacketBuffer.func_150789_c(extendedPacketBuffer.readInt());
        this.worldHash = extendedPacketBuffer.func_150789_c(extendedPacketBuffer.readInt());
    }

    public void processData(PacketSaveData packetSendData, MessageContext messageContext) {
        WorldFormat configFormat = (WorldFormat)ConfigManager.TINY_GSON.fromJson(packetSendData.data, WorldFormat.class);
        RunData data = new RunData();
        data.runHash = packetSendData.worldHash;
        data.runDate = LocalDateTime.now().toString();
        data.userName = Minecraft.func_71410_x().field_71439_g.func_70005_c_();
        data.uuid = Minecraft.func_71410_x().field_71439_g.func_110124_au().toString();
        data.totalTime = packetSendData.time;
        if (ClientDataManager.getConfigFormat() != null && ClientDataManager.getConfigFormat().leaderboard != null && ClientDataManager.getConfigFormat().leaderboard.packName != null && !ClientDataManager.getConfigFormat().leaderboard.packName.isEmpty()) {
            data.packName = ClientDataManager.getConfigFormat().leaderboard.packName;
        }
        data.achievementData = new ArrayList<AchievementData>();
        data.players = new ArrayList<RunData.PlayerData>();
        String[] players = packetSendData.players.split(",");
        for (String player : players) {
            String[] nameSplit = player.split("#");
            if (nameSplit[0].equals(data.userName)) continue;
            data.players.add(new RunData.PlayerData(nameSplit[0], nameSplit[1]));
        }
        try {
            data.configHash = ConfigManager.getConfigHash();
        }
        catch (IOException e) {
            e.printStackTrace();
            data.configHash = "UNKNOWN";
        }
        for (Map.Entry entry : configFormat.achivementTimes.entrySet()) {
            String name = (String)entry.getKey();
            Long time = (Long)entry.getValue();
            data.achievementData.add(new AchievementData(name, time));
        }
        RunManager.saveRun(data);
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Run data has been saved, use the GUI in the main menu to upload to the global leaderboard."));
    }
}

