/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba.files.runs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import me.modmuss50.ftba.files.runs.RunData;
import org.apache.commons.io.FileUtils;
import reborncore.common.util.serialization.SerializationUtil;

public class RunManager {
    public static File mcDir;
    public static File saveDir;
    public static final String FILE_EXT = ".json";
    public static final String FILE_EXT_NEW = ".dat";

    public static void load() {
        saveDir = new File(mcDir, "runs");
        if (!saveDir.exists()) {
            saveDir.mkdir();
        }
    }

    public static List<RunData> getRuns() {
        RunManager.load();
        ArrayList<RunData> list = new ArrayList<RunData>();
        for (File file : saveDir.listFiles()) {
            if (file.isDirectory()) continue;
            if (file.getName().endsWith(FILE_EXT)) {
                try {
                    RunData data = (RunData)SerializationUtil.GSON.fromJson(FileUtils.readFileToString((File)file), RunData.class);
                    list.add(data);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!file.getName().endsWith(FILE_EXT_NEW)) continue;
            try {
                FileInputStream fi = new FileInputStream(file);
                ObjectInputStream oi = new ObjectInputStream(fi);
                RunData data = (RunData)oi.readObject();
                oi.close();
                fi.close();
                if (data == null) continue;
                list.add(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static void saveRun(RunData data) {
        RunManager.load();
        File file = new File(saveDir, data.runDate.replace(":", ".") + FILE_EXT_NEW);
        try {
            FileOutputStream f = new FileOutputStream(file);
            ObjectOutputStream o = new ObjectOutputStream(f);
            o.writeObject(data);
            o.close();
            f.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

