/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba.client.gui;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import me.modmuss50.ftba.client.gui.GuiUpload;
import me.modmuss50.ftba.files.runs.RunData;
import me.modmuss50.ftba.files.runs.RunManager;
import me.modmuss50.ftba.util.TimerServerHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiRunList
extends GuiScreen {
    private static final Logger logger = LogManager.getLogger();
    private static final int CANCEL_BUTTON_ID = 1;
    private static final int UPLOAD_BUTTON_ID = 0;
    public GuiScreen parent;
    private List<RunData> runList;
    private RunList list;
    private int selectedSlot;
    private GuiButton upload;

    public GuiRunList(GuiScreen parent) {
        this.parent = parent;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.initSaveList();
        this.list = new RunList();
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 5, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.upload = new GuiButton(0, this.field_146294_l / 2 - 155, this.field_146295_m - 28, 150, 20, "Upload");
        this.field_146292_n.add(this.upload);
    }

    private void initSaveList() {
        this.runList = RunManager.getRuns();
        Collections.sort(this.runList, (r1, r2) -> (int)(r1.totalTime - r2.totalTime));
        this.selectedSlot = -1;
    }

    public void func_146284_a(GuiButton guiButton) throws IOException {
        super.func_146284_a(guiButton);
        if (guiButton.field_146127_k == 1) {
            Minecraft.func_71410_x().func_147108_a(this.parent);
        }
        if (guiButton.field_146127_k == 0) {
            this.uploadMap();
        }
        this.list.func_148147_a(guiButton);
    }

    protected void func_73869_a(char keyChar, int keyCode) throws IOException {
        if (keyCode == 28 || keyCode == 156) {
            this.func_146284_a((GuiButton)this.field_146292_n.get(0));
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.list.func_178039_p();
    }

    public void func_73863_a(int x, int y, float f) {
        this.list.func_148128_a(x, y, f);
        this.func_73732_a(this.field_146289_q, TextFormatting.BLUE + "F" + TextFormatting.GREEN + "T" + TextFormatting.RED + "B" + TextFormatting.WHITE + " Achievements", this.field_146294_l / 2, 20, -1);
        this.func_73732_a(this.field_146289_q, "This is a list of all the runs that you have completed", this.field_146294_l / 2, 40, -1);
        this.func_73732_a(this.field_146289_q, "You can upload your best run to the global leaderboard.", this.field_146294_l / 2, 50, -1);
        super.func_73863_a(x, y, f);
    }

    private RunData getRun() {
        return this.runList.get(this.selectedSlot);
    }

    private void uploadMap() {
        if (this.selectedSlot == -1) {
            return;
        }
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiUpload(this.parent, this.getRun()));
    }

    private class RunList
    extends GuiSlot {
        public RunList() {
            super(GuiRunList.this.field_146297_k, GuiRunList.this.field_146294_l, GuiRunList.this.field_146295_m, 78, GuiRunList.this.field_146295_m - 32, 36);
        }

        protected int func_148127_b() {
            return GuiRunList.this.runList.size();
        }

        protected void func_148144_a(int slot, boolean doubleClicked, int mouseX, int mouseY) {
            GuiRunList.this.selectedSlot = slot;
            if (doubleClicked) {
                GuiRunList.this.uploadMap();
            }
        }

        protected boolean func_148131_a(int slot) {
            return slot == GuiRunList.this.selectedSlot;
        }

        protected void func_148123_a() {
            GuiRunList.this.func_146276_q_();
        }

        public int func_148139_c() {
            return GuiRunList.this.field_146294_l - 40;
        }

        protected int func_148137_d() {
            return this.field_148155_a / 2 + this.func_148139_c() / 2 - 6;
        }

        protected void func_192637_a(int slot, int x, int y, int slotHeight, int mouseX, int mouseY, float ticks) {
            RunData runData = (RunData)GuiRunList.this.runList.get(slot);
            String displayName = TimerServerHandler.getNiceTimeFromLong(runData.totalTime);
            String by = runData.userName;
            String topLine = displayName + ", " + by;
            String date = runData.runDate;
            String middleLine = "(" + date.replace("T", " ") + ") ";
            String bottomLine = "Completed " + runData.achievementData.size() + " achievements";
            if (runData.players != null && runData.players.size() > 1) {
                int extraPlayers = runData.players.size() - 1;
                bottomLine = bottomLine + " with " + extraPlayers + " other player" + (extraPlayers > 1 ? "s" : "");
            }
            GuiRunList.this.func_73731_b(GuiRunList.this.field_146289_q, topLine, x + 34, y + 1, 0xFFFFFF);
            GuiRunList.this.func_73731_b(GuiRunList.this.field_146289_q, middleLine, x + 34, y + 12, 0x808080);
            GuiRunList.this.func_73731_b(GuiRunList.this.field_146289_q, bottomLine, x + 34, y + 12 + 10, 0x808080);
        }
    }
}

