/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringJoiner;
import me.modmuss50.ftba.ConfigManager;
import me.modmuss50.ftba.FTBAchievements;
import me.modmuss50.ftba.client.gui.achivementGui.AchievementButton;
import me.modmuss50.ftba.files.config.FTBAchievement;
import me.modmuss50.ftba.files.worldData.WorldFormat;
import me.modmuss50.ftba.packets.PacketSaveData;
import me.modmuss50.ftba.util.AchievementUser;
import me.modmuss50.ftba.util.TimerServerHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import reborncore.common.network.INetworkPacket;
import reborncore.common.network.NetworkManager;
import reborncore.common.util.InventoryHelper;

public class AchievementManager {
    public static void processAchievement(FTBAchievement achievement, AchievementUser user) {
        if (achievement == null || user == null || user.world == null || user.world.field_72995_K) {
            return;
        }
        WorldFormat format = FTBAchievements.dataManager.getFormatServer();
        if (achievement.rewards != null && !achievement.rewards.isEmpty()) {
            BlockPos pos = new BlockPos(format.chestX, format.chestY, format.chestZ);
            WorldServer world = user.world.func_73046_m().func_71218_a(format.chestDimID);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (!(tileEntity instanceof IInventory)) {
                world.func_73046_m().func_184103_al().func_148539_a((ITextComponent)new TextComponentString("Could not find reward chest @" + pos));
                return;
            }
        }
        if (achievement.fireOnce && format != null) {
            if (format.triggedAchivements == null) {
                format.triggedAchivements = new ArrayList<String>();
            }
            if (format.achivementTimes == null) {
                format.achivementTimes = new HashMap();
            }
            if (format.triggedAchivements.contains(achievement.name)) {
                return;
            }
            format.triggedAchivements.add(achievement.name);
            format.achivementTimes.put(achievement.name, TimerServerHandler.getTimeDifference());
            try {
                FTBAchievements.dataManager.save(user.world);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (achievement.rewards != null && user.world != null) {
            for (ItemStack stack : achievement.rewards) {
                BlockPos pos = new BlockPos(format.chestX, format.chestY, format.chestZ);
                TileEntity tileEntity = user.world.func_175625_s(pos);
                int count = 1;
                if (achievement.giveToAll) {
                    for (EntityPlayer entityPlayer : user.world.func_73046_m().func_184103_al().func_181057_v()) {
                        if (entityPlayer.func_175149_v()) continue;
                        ++count;
                    }
                }
                if (count > 1) {
                    --count;
                }
                for (int i = 0; i < count; ++i) {
                    if (!(tileEntity instanceof IInventory)) continue;
                    if (InventoryHelper.testInventoryInsertion((IInventory)((IInventory)tileEntity), (ItemStack)stack.func_77946_l(), (EnumFacing)EnumFacing.DOWN) != 0) {
                        InventoryHelper.insertItemIntoInventory((IInventory)((IInventory)tileEntity), (ItemStack)stack.func_77946_l());
                        continue;
                    }
                    EntityItem entityItem = new EntityItem(tileEntity.func_145831_w(), (double)tileEntity.func_174877_v().func_177958_n() + 0.5, (double)tileEntity.func_174877_v().func_177956_o() + 1.5, (double)tileEntity.func_174877_v().func_177952_p() + 0.5, stack.func_77946_l());
                    entityItem.func_174873_u();
                    tileEntity.func_145831_w().func_72838_d((Entity)entityItem);
                }
            }
        }
        user.world.func_73046_m().func_184103_al().func_148539_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + user.name + TextFormatting.WHITE + " has unlocked " + TextFormatting.GREEN + AchievementManager.getBookTitle(achievement.bookStack, achievement) + TextFormatting.WHITE + " in " + TextFormatting.BLUE + "[" + TimerServerHandler.getNiceTimeFromLong(TimerServerHandler.getTimeDifference()) + "]"));
        boolean hasIncompleteAchievement = false;
        for (FTBAchievement ftbAchievement : ConfigManager.getConfig().achievements) {
            if (format.triggedAchivements.contains(ftbAchievement.name)) continue;
            hasIncompleteAchievement = true;
        }
        if (!hasIncompleteAchievement) {
            TimerServerHandler.stop();
            TimerServerHandler.syncWithAll();
            for (EntityPlayer player : user.world.func_73046_m().func_184103_al().func_181057_v()) {
                player.func_145747_a((ITextComponent)new TextComponentString("Well done! All achievements have been completed in " + TextFormatting.GREEN + TimerServerHandler.getNiceTimeFromLong(TimerServerHandler.getStoppedTime())));
                ArrayList<String> fireWorkData = new ArrayList<String>();
                fireWorkData.add("{Fireworks:{Explosions:[{Type:1,Flicker:1,Trail:1,Colors:[I;4312372,15435844,14188952],FadeColors:[I;18073150,11250603]}]}}");
                fireWorkData.add("{Fireworks:{Explosions:[{Type:1,Flicker:1,Trail:1,Colors:[I;11743532,15435844,14188952],FadeColors:[I;4408131,11250603]}]}}");
                fireWorkData.add("{Fireworks:{Explosions:[{Type:1,Flicker:1,Trail:1,Colors:[I;8073150,15435844,14188952],FadeColors:[I;14408131,11743532]}]}}");
                int sapwnRaduis = 8;
                for (String data : fireWorkData) {
                    ItemStack stack = new ItemStack(Items.field_151152_bP);
                    try {
                        stack.func_77982_d(JsonToNBT.func_180713_a((String)data));
                        EntityFireworkRocket entityfireworkrocket = new EntityFireworkRocket(player.field_70170_p, player.field_70165_t + (double)player.field_70170_p.field_73012_v.nextInt(sapwnRaduis) - (double)(sapwnRaduis / 2), player.field_70163_u, player.field_70161_v + (double)player.field_70170_p.field_73012_v.nextInt(sapwnRaduis) - (double)(sapwnRaduis / 2), stack);
                        player.field_70170_p.func_72838_d((Entity)entityfireworkrocket);
                    }
                    catch (NBTException e) {
                        e.printStackTrace();
                    }
                }
                String playerData = format.players;
                if (playerData == null || playerData.isEmpty()) {
                    StringJoiner joiner = new StringJoiner(",");
                    for (EntityPlayer entityPlayer : user.world.func_73046_m().func_184103_al().func_181057_v()) {
                        if (entityPlayer.func_175149_v()) continue;
                        joiner.add(entityPlayer.getDisplayNameString() + "#" + entityPlayer.func_146103_bH().getId().toString());
                    }
                    playerData = joiner.toString();
                }
                NetworkManager.sendToPlayer((INetworkPacket)new PacketSaveData(ConfigManager.TINY_GSON.toJson((Object)FTBAchievements.dataManager.getFormatServer()), TimerServerHandler.getStoppedTime(), playerData, FTBAchievements.dataManager.getWorldHash()), (EntityPlayerMP)((EntityPlayerMP)player));
            }
        }
        FTBAchievements.proxy.syncWithClients();
    }

    public static String getBookTitle(ItemStack stack, FTBAchievement ftbAchievement) {
        NBTTagCompound nbttagcompound;
        String s;
        if (AchievementButton.isValidBook(stack) && !StringUtils.func_151246_b((String)(s = (nbttagcompound = stack.func_77978_p()).func_74779_i("title")))) {
            return s;
        }
        return ftbAchievement.name;
    }
}

