/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.numbers.ConstantProvider;
import cofh.cofhworld.util.numbers.INumberProvider;
import cofh.cofhworld.world.generator.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenGeode
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final List<WeightedRandomBlock> outline;
    private final WeightedRandomBlock[] genBlock;
    private List<WeightedRandomBlock> fillBlock;
    private boolean hollow;
    private INumberProvider width;
    private INumberProvider height;

    public WorldGenGeode(List<WeightedRandomBlock> resource, List<WeightedRandomBlock> material, List<WeightedRandomBlock> cover) {
        this.cluster = resource;
        this.genBlock = material.toArray(new WeightedRandomBlock[material.size()]);
        this.outline = cover;
        this.fillBlock = null;
        this.hollow = false;
        this.setWidth(16);
        this.setHeight(8);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int y;
        int x;
        int xStart = pos.func_177958_n();
        int yStart = pos.func_177956_o();
        int zStart = pos.func_177952_p();
        int height = this.height.intValue(world, rand, pos);
        int width = this.width.intValue(world, rand, pos);
        int heightOff = height / 2;
        int widthOff = width / 2;
        xStart -= widthOff;
        zStart -= widthOff;
        if (yStart <= heightOff) {
            return false;
        }
        yStart -= heightOff;
        boolean[] spawnBlock = new boolean[width * width * height];
        boolean[] hollowBlock = new boolean[width * width * height];
        int W = width - 1;
        int H = height - 1;
        int e = rand.nextInt(4) + 4;
        for (int i = 0; i < e; ++i) {
            double xSize = rand.nextDouble() * 6.0 + 3.0;
            double ySize = rand.nextDouble() * 4.0 + 2.0;
            double zSize = rand.nextDouble() * 6.0 + 3.0;
            double xCenter = rand.nextDouble() * ((double)width - xSize - 2.0) + 1.0 + xSize / 2.0;
            double yCenter = rand.nextDouble() * ((double)height - ySize - 4.0) + 2.0 + ySize / 2.0;
            double zCenter = rand.nextDouble() * ((double)width - zSize - 2.0) + 1.0 + zSize / 2.0;
            double minDist = this.hollow ? rand.nextGaussian() * 0.15 + 0.4 : 0.0;
            for (int x2 = 1; x2 < W; ++x2) {
                for (int z = 1; z < W; ++z) {
                    for (int y2 = 1; y2 < H; ++y2) {
                        double xDist = ((double)x2 - xCenter) / (xSize / 2.0);
                        double yDist = ((double)y2 - yCenter) / (ySize / 2.0);
                        double zDist = ((double)z - zCenter) / (zSize / 2.0);
                        double dist = xDist * xDist + yDist * yDist + zDist * zDist;
                        if (dist < 1.0) {
                            spawnBlock[(x2 * width + z) * height + y2] = true;
                        }
                        if (!this.hollow || !(dist <= minDist)) continue;
                        hollowBlock[(x2 * width + z) * height + y2] = true;
                    }
                }
            }
        }
        for (x = 0; x < width; ++x) {
            for (int z = 0; z < width; ++z) {
                for (y = 0; y < height; ++y) {
                    boolean flag;
                    boolean bl = flag = this.fillBlock != null && hollowBlock[(x * width + z) * height + y] || spawnBlock[(x * width + z) * height + y] || x < W && spawnBlock[((x + 1) * width + z) * height + y] || x > 0 && spawnBlock[((x - 1) * width + z) * height + y] || z < W && spawnBlock[(x * width + (z + 1)) * height + y] || z > 0 && spawnBlock[(x * width + (z - 1)) * height + y] || y < H && spawnBlock[(x * width + z) * height + (y + 1)] || y > 0 && spawnBlock[(x * width + z) * height + (y - 1)];
                    if (!flag || WorldGenMinableCluster.canGenerateInBlock(world, xStart + x, yStart + y, zStart + z, this.genBlock)) continue;
                    return false;
                }
            }
        }
        boolean r = false;
        for (x = 0; x < width; ++x) {
            for (int z = 0; z < width; ++z) {
                for (y = 0; y < height; ++y) {
                    if (!spawnBlock[(x * width + z) * height + y]) continue;
                    boolean t = WorldGenMinableCluster.generateBlock(world, rand, xStart + x, yStart + y, zStart + z, this.cluster);
                    r |= t;
                    if (t) continue;
                    spawnBlock[(x * width + z) * height + y] = false;
                }
            }
        }
        for (x = 0; x < width; ++x) {
            for (int z = 0; z < width; ++z) {
                for (y = 0; y < height; ++y) {
                    boolean flag;
                    if (this.fillBlock != null && hollowBlock[(x * width + z) * height + y]) {
                        r |= WorldGenMinableCluster.generateBlock(world, rand, xStart + x, yStart + y, zStart + z, this.fillBlock);
                        continue;
                    }
                    boolean bl = flag = !spawnBlock[(x * width + z) * height + y] && (x < W && spawnBlock[((x + 1) * width + z) * height + y] || x > 0 && spawnBlock[((x - 1) * width + z) * height + y] || z < W && spawnBlock[(x * width + (z + 1)) * height + y] || z > 0 && spawnBlock[(x * width + (z - 1)) * height + y] || y < H && spawnBlock[(x * width + z) * height + (y + 1)] || y > 0 && spawnBlock[(x * width + z) * height + (y - 1)]);
                    if (!flag) continue;
                    r |= WorldGenMinableCluster.generateBlock(world, rand, xStart + x, yStart + y, zStart + z, this.outline);
                }
            }
        }
        return r;
    }

    public WorldGenGeode setWidth(int width) {
        this.width = new ConstantProvider(width);
        return this;
    }

    public WorldGenGeode setWidth(INumberProvider width) {
        this.width = width;
        return this;
    }

    public WorldGenGeode setHeight(int height) {
        this.height = new ConstantProvider(height);
        return this;
    }

    public WorldGenGeode setHeight(INumberProvider height) {
        this.height = height;
        return this;
    }

    public WorldGenGeode setHollow(boolean hollow) {
        this.hollow = hollow;
        return this;
    }

    public WorldGenGeode setFillBlock(List<WeightedRandomBlock> blocks) {
        this.fillBlock = blocks;
        return this;
    }
}

