/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.feature.parser;

import cofh.cofhworld.feature.IConfigurableFeatureGenerator;
import cofh.cofhworld.feature.IFeatureGenerator;
import cofh.cofhworld.feature.IFeatureParser;
import cofh.cofhworld.feature.generator.FeatureBase;
import cofh.cofhworld.feature.generator.FeatureGenSequential;
import cofh.cofhworld.init.FeatureParser;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigList;
import cofh.shade.com.typesafe.config.ConfigValue;
import cofh.shade.com.typesafe.config.ConfigValueType;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.util.math.MathHelper;
import org.apache.logging.log4j.Logger;

public class SequentialParser
implements IFeatureParser {
    @Override
    public IFeatureGenerator parseFeature(String featureName, Config genObject, Logger log) {
        FeatureBase feature;
        boolean retrogen = false;
        if (genObject.hasPath("retrogen")) {
            retrogen = genObject.getBoolean("retrogen");
        }
        IConfigurableFeatureGenerator.GenRestriction biomeRes = IConfigurableFeatureGenerator.GenRestriction.NONE;
        if (genObject.hasPath("biome")) {
            ConfigValue data = genObject.getValue("biome");
            if (data.valueType() == ConfigValueType.STRING) {
                biomeRes = IConfigurableFeatureGenerator.GenRestriction.get(genObject.getString("biome"));
                if (biomeRes != IConfigurableFeatureGenerator.GenRestriction.NONE) {
                    log.error("Invalid biome restriction %2$s on '%1$s'. Must be an object to meaningfully function", (Object)featureName, (Object)biomeRes.name().toLowerCase(Locale.US));
                    return null;
                }
            } else if (data.valueType() == ConfigValueType.OBJECT) {
                biomeRes = IConfigurableFeatureGenerator.GenRestriction.get(genObject.getString("biome.restriction"));
            }
        }
        IConfigurableFeatureGenerator.GenRestriction dimRes = IConfigurableFeatureGenerator.GenRestriction.NONE;
        if (genObject.hasPath("dimension")) {
            ConfigValue data = genObject.getValue("dimension");
            switch (data.valueType()) {
                case STRING: {
                    dimRes = IConfigurableFeatureGenerator.GenRestriction.get(genObject.getString("dimension"));
                    if (dimRes == IConfigurableFeatureGenerator.GenRestriction.NONE) break;
                    log.error("Invalid dimension restriction %2$s on '%1$s'. Must be an object to meaningfully function", (Object)featureName, (Object)dimRes.name().toLowerCase(Locale.US));
                    return null;
                }
                case OBJECT: {
                    dimRes = IConfigurableFeatureGenerator.GenRestriction.get(genObject.getString("dimension.restriction"));
                    break;
                }
                case LIST: 
                case NUMBER: {
                    dimRes = IConfigurableFeatureGenerator.GenRestriction.WHITELIST;
                }
            }
        }
        if ((feature = this.getFeature(featureName, genObject, biomeRes, retrogen, dimRes, log)) != null) {
            if (genObject.hasPath("chunk-chance")) {
                int rarity = MathHelper.func_76125_a((int)genObject.getInt("chunk-chance"), (int)1, (int)1000000000);
                feature.setRarity(rarity);
            }
            SequentialParser.addFeatureRestrictions(feature, genObject);
            if (genObject.hasPath("in-village")) {
                feature.setWithVillage(genObject.getBoolean("in-village"));
            }
        }
        return feature;
    }

    @Override
    public FeatureBase getFeature(String featureName, Config genObject, IConfigurableFeatureGenerator.GenRestriction biomeRes, boolean retrogen, IConfigurableFeatureGenerator.GenRestriction dimRes, Logger log) {
        ArrayList<IConfigurableFeatureGenerator> features = new ArrayList<IConfigurableFeatureGenerator>();
        int i = 0;
        for (Config config : genObject.getConfigList("features")) {
            String template = FeatureParser.parseTemplate(config);
            IFeatureParser parser = FeatureParser.getTemplate(template);
            if (parser != null) {
                IConfigurableFeatureGenerator feature = parser.getFeature(featureName + '$' + ++i, config, biomeRes, retrogen, dimRes, log);
                if (feature == null) {
                    log.error("Template '{}' has failed to parse its entry!", (Object)template);
                    return null;
                }
                features.add(feature);
                continue;
            }
            log.error("Unknown template '{}'", (Object)template);
            return null;
        }
        return new FeatureGenSequential(featureName, features, biomeRes, retrogen, dimRes);
    }

    public static void addFeatureRestrictions(IConfigurableFeatureGenerator feature, Config genObject) {
        if (feature.getBiomeRestriction() != IConfigurableFeatureGenerator.GenRestriction.NONE) {
            feature.addBiomes(FeatureParser.parseBiomeRestrictions(genObject.getConfig("biome")));
        }
        if (feature.getDimensionRestriction() != IConfigurableFeatureGenerator.GenRestriction.NONE) {
            String field = "dimension";
            ConfigValue data = genObject.getValue(field);
            ConfigList restrictionList = null;
            switch (data.valueType()) {
                case OBJECT: {
                    field = field + ".value";
                }
                case LIST: {
                    restrictionList = genObject.getList(field);
                    break;
                }
                case NUMBER: {
                    feature.addDimension(genObject.getNumber(field).intValue());
                    break;
                }
            }
            if (restrictionList != null) {
                for (int i = 0; i < restrictionList.size(); ++i) {
                    ConfigValue val = (ConfigValue)restrictionList.get(i);
                    if (val.valueType() != ConfigValueType.NUMBER) continue;
                    feature.addDimension(((Number)val.unwrapped()).intValue());
                }
            }
        }
    }
}

