/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.decoration.parser;

import cofh.cofhworld.decoration.IGeneratorParser;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.world.generator.WorldGenStalactite;
import cofh.cofhworld.world.generator.WorldGenStalagmite;
import cofh.shade.com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class StalagmiteParser
implements IGeneratorParser {
    private final boolean stalactite;

    public StalagmiteParser(boolean stalactite) {
        this.stalactite = stalactite;
    }

    @Override
    public WorldGenerator parseGenerator(String generatorName, Config genObject, Logger log, List<WeightedRandomBlock> resList, List<WeightedRandomBlock> matList) {
        WorldGenStalagmite r;
        ArrayList<WeightedRandomBlock> list = new ArrayList<WeightedRandomBlock>();
        if (!genObject.hasPath("gen-body")) {
            log.info("Entry does not specify gen body for 'stalagmite' generator. Using air.");
            list.add(new WeightedRandomBlock(Blocks.field_150350_a));
        } else if (!FeatureParser.parseResList(genObject.root().get("gen-body"), list, false)) {
            log.warn("Entry specifies invalid gen body for 'stalagmite' generator! Using air!");
            list.clear();
            list.add(new WeightedRandomBlock(Blocks.field_150350_a));
        }
        WorldGenStalagmite worldGenStalagmite = r = this.stalactite ? new WorldGenStalactite(resList, matList, list) : new WorldGenStalagmite(resList, matList, list);
        if (genObject.hasPath("min-height")) {
            r.minHeight = genObject.getInt("min-height");
        }
        if (genObject.hasPath("height-variance")) {
            r.heightVariance = genObject.getInt("height-variance");
        }
        if (genObject.hasPath("size-variance")) {
            r.sizeVariance = genObject.getInt("size-variance");
        }
        if (genObject.hasPath("height-mod")) {
            r.heightMod = genObject.getInt("height-mod");
        }
        if (genObject.hasPath("gen-size")) {
            r.genSize = genObject.getInt("gen-size");
        }
        if (genObject.hasPath("smooth")) {
            r.smooth = genObject.getBoolean("smooth");
        }
        if (genObject.hasPath("fat")) {
            r.fat = genObject.getBoolean("fat");
        }
        if (genObject.hasPath("alt-sinc")) {
            r.altSinc = genObject.getBoolean("alt-sinc");
        }
        return r;
    }
}

