/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool;

import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.elementium.ItemElementiumPick;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;

public final class ToolCommons {
    public static final List<Material> materialsPick = Arrays.asList(Material.field_151576_e, Material.field_151573_f, Material.field_151588_w, Material.field_151592_s, Material.field_76233_E, Material.field_151574_g);
    public static final List<Material> materialsShovel = Arrays.asList(Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B);
    public static final List<Material> materialsAxe = Arrays.asList(Material.field_151589_v, Material.field_151584_j, Material.field_151585_k, Material.field_151575_d, Material.field_151572_C);

    public static void damageItem(ItemStack stack, int dmg, EntityLivingBase entity, int manaPerDamage) {
        boolean manaRequested;
        int manaToRequest = dmg * manaPerDamage;
        boolean bl = manaRequested = entity instanceof EntityPlayer ? ManaItemHandler.requestManaExactForTool(stack, (EntityPlayer)entity, manaToRequest, true) : false;
        if (!manaRequested) {
            stack.func_77972_a(dmg, entity);
        }
    }

    public static void removeBlocksInIteration(EntityPlayer player, ItemStack stack, World world, BlockPos centerPos, Vec3i startDelta, Vec3i endDelta, Block filterBlock, List<Material> materialsListing, boolean silk, int fortune, boolean dispose) {
        for (BlockPos iterPos : BlockPos.func_177980_a((BlockPos)centerPos.func_177971_a(startDelta), (BlockPos)centerPos.func_177971_a(endDelta))) {
            if (iterPos.equals((Object)centerPos)) continue;
            ToolCommons.removeBlockWithDrops(player, stack, world, iterPos, centerPos, filterBlock, materialsListing, silk, fortune, dispose);
        }
    }

    public static void removeBlockWithDrops(EntityPlayer player, ItemStack stack, World world, BlockPos pos, BlockPos bPos, Block filterBlock, List<Material> materialsListing, boolean silk, int fortune, boolean dispose) {
        ToolCommons.removeBlockWithDrops(player, stack, world, pos, bPos, filterBlock, materialsListing, silk, fortune, dispose, true);
    }

    public static void removeBlockWithDrops(EntityPlayer player, ItemStack stack, World world, BlockPos pos, BlockPos bPos, Block filterBlock, List<Material> materialsListing, boolean silk, int fortune, boolean dispose, boolean particles) {
        if (!world.func_175667_e(pos)) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (filterBlock != null && block != filterBlock) {
            return;
        }
        Material mat = world.func_180495_p(pos).func_185904_a();
        if (!world.field_72995_K && !block.isAir(state, (IBlockAccess)world, pos) && state.func_185903_a(player, world, pos) > 0.0f) {
            if (!block.canHarvestBlock((IBlockAccess)player.field_70170_p, pos, player) || !materialsListing.contains(mat)) {
                return;
            }
            int exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
            if (exp == -1) {
                return;
            }
            boolean spawnedDrops = false;
            if (!player.field_71075_bZ.field_75098_d) {
                TileEntity tile = world.func_175625_s(pos);
                IBlockState localState = world.func_180495_p(pos);
                if (block.removedByPlayer(state, world, pos, player, true)) {
                    block.func_176206_d(world, pos, state);
                    if (!dispose || !ItemElementiumPick.isDisposable(block)) {
                        block.func_180657_a(world, player, pos, state, tile, stack);
                        spawnedDrops = true;
                    }
                }
                ToolCommons.damageItem(stack, 1, (EntityLivingBase)player, 80);
            } else {
                world.func_175698_g(pos);
            }
            if (particles && ConfigHandler.blockBreakParticles && ConfigHandler.blockBreakParticlesTool) {
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            }
            if (spawnedDrops) {
                block.func_180637_b(world, pos, exp);
            }
        }
    }

    public static int getToolPriority(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof ItemTool)) {
            return 0;
        }
        ItemTool tool = (ItemTool)item;
        Item.ToolMaterial material = tool.field_77862_b;
        int materialLevel = 0;
        if (material == BotaniaAPI.manasteelToolMaterial) {
            materialLevel = 10;
        }
        if (material == BotaniaAPI.elementiumToolMaterial) {
            materialLevel = 11;
        }
        if (material == BotaniaAPI.terrasteelToolMaterial) {
            materialLevel = 20;
        }
        int modifier = 0;
        if (item == ModItems.terraPick) {
            modifier = ItemTerraPick.getLevel(stack);
        }
        int efficiency = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack);
        return materialLevel * 100 + modifier * 10 + efficiency;
    }

    public static RayTraceResult raytraceFromEntity(World worldIn, Entity playerIn, boolean useLiquids, double range) {
        float f = playerIn.field_70125_A;
        float f1 = playerIn.field_70177_z;
        double d0 = playerIn.field_70165_t;
        double d1 = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = range;
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return worldIn.func_147447_a(vec3d, vec3d1, useLiquids, !useLiquids, false);
    }
}

