/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AltGrassVariant;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.IFloatingFlowerVariant;
import vazkii.botania.common.item.ItemMod;

public class ItemGrassSeeds
extends ItemMod
implements IFloatingFlowerVariant {
    private static final TIntObjectHashMap<Set<BlockSwapper>> blockSwappers = new TIntObjectHashMap();
    private static final IFloatingFlower.IslandType[] ISLAND_TYPES = new IFloatingFlower.IslandType[]{IFloatingFlower.IslandType.GRASS, IFloatingFlower.IslandType.PODZOL, IFloatingFlower.IslandType.MYCEL, IFloatingFlower.IslandType.DRY, IFloatingFlower.IslandType.GOLDEN, IFloatingFlower.IslandType.VIVID, IFloatingFlower.IslandType.SCORCHED, IFloatingFlower.IslandType.INFUSED, IFloatingFlower.IslandType.MUTATED};
    private static final int SUBTYPES = 9;

    public ItemGrassSeeds() {
        super("grassSeeds");
        this.func_77627_a(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < 9; ++i) {
                list.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + stack.func_77952_i();
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float par8, float par9, float par10) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (state.func_177230_c() == Blocks.field_150346_d && state.func_177229_b((IProperty)BlockDirt.field_176386_a) == BlockDirt.DirtType.DIRT || state.func_177230_c() == Blocks.field_150349_c && stack.func_77952_i() != 0) {
            int meta = stack.func_77952_i();
            if (!world.field_72995_K) {
                BlockSwapper swapper = ItemGrassSeeds.addBlockSwapper(world, pos, meta);
                world.func_180501_a(pos, swapper.stateToSet, 3);
                stack.func_190918_g(1);
            } else {
                for (int i = 0; i < 50; ++i) {
                    double x = (Math.random() - 0.5) * 3.0;
                    double y = Math.random() - 0.5 + 1.0;
                    double z = (Math.random() - 0.5) * 3.0;
                    float r = 0.0f;
                    float g = 0.4f;
                    float b = 0.0f;
                    switch (meta) {
                        case 1: {
                            r = 0.5f;
                            g = 0.37f;
                            b = 0.0f;
                            break;
                        }
                        case 2: {
                            r = 0.27f;
                            g = 0.0f;
                            b = 0.33f;
                            break;
                        }
                        case 3: {
                            r = 0.4f;
                            g = 0.5f;
                            b = 0.05f;
                            break;
                        }
                        case 4: {
                            r = 0.75f;
                            g = 0.7f;
                            b = 0.0f;
                            break;
                        }
                        case 5: {
                            r = 0.0f;
                            g = 0.5f;
                            b = 0.1f;
                            break;
                        }
                        case 6: {
                            r = 0.75f;
                            g = 0.0f;
                            b = 0.0f;
                            break;
                        }
                        case 7: {
                            r = 0.0f;
                            g = 0.55f;
                            b = 0.55f;
                            break;
                        }
                        case 8: {
                            r = 0.4f;
                            g = 0.1f;
                            b = 0.4f;
                        }
                    }
                    float velMul = 0.025f;
                    Botania.proxy.wispFX((double)pos.func_177958_n() + 0.5 + x, (double)pos.func_177956_o() + 0.5 + y, (double)pos.func_177952_p() + 0.5 + z, r, g, b, (float)Math.random() * 0.15f + 0.15f, (float)(-x) * velMul, (float)(-y) * velMul, (float)(-z) * velMul);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelHandler.registerItemAppendMeta(this, 9, "grassSeeds");
    }

    @SubscribeEvent
    public void onTickEnd(TickEvent.WorldTickEvent event) {
        int dim;
        if (event.world.field_72995_K) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && blockSwappers.containsKey(dim = event.world.field_73011_w.getDimension())) {
            Set swappers = (Set)blockSwappers.get(dim);
            Iterator iter = swappers.iterator();
            while (iter.hasNext()) {
                BlockSwapper next = (BlockSwapper)iter.next();
                if (next != null && next.tick()) continue;
                iter.remove();
            }
        }
    }

    private static BlockSwapper addBlockSwapper(World world, BlockPos pos, int meta) {
        BlockSwapper swapper = ItemGrassSeeds.swapperFromMeta(world, pos, meta);
        int dim = world.field_73011_w.getDimension();
        if (!blockSwappers.containsKey(dim)) {
            blockSwappers.put(dim, new HashSet());
        }
        ((Set)blockSwappers.get(dim)).add(swapper);
        return swapper;
    }

    private static BlockSwapper swapperFromMeta(World world, BlockPos pos, int meta) {
        switch (meta) {
            case 1: {
                return new BlockSwapper(world, pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL));
            }
            case 2: {
                return new BlockSwapper(world, pos, Blocks.field_150391_bh.func_176223_P());
            }
            case 3: {
                return new BlockSwapper(world, pos, ModBlocks.altGrass.func_176223_P().func_177226_a(BotaniaStateProps.ALTGRASS_VARIANT, (Comparable)((Object)AltGrassVariant.DRY)));
            }
            case 4: {
                return new BlockSwapper(world, pos, ModBlocks.altGrass.func_176223_P().func_177226_a(BotaniaStateProps.ALTGRASS_VARIANT, (Comparable)((Object)AltGrassVariant.GOLDEN)));
            }
            case 5: {
                return new BlockSwapper(world, pos, ModBlocks.altGrass.func_176223_P().func_177226_a(BotaniaStateProps.ALTGRASS_VARIANT, (Comparable)((Object)AltGrassVariant.VIVID)));
            }
            case 6: {
                return new BlockSwapper(world, pos, ModBlocks.altGrass.func_176223_P().func_177226_a(BotaniaStateProps.ALTGRASS_VARIANT, (Comparable)((Object)AltGrassVariant.SCORCHED)));
            }
            case 7: {
                return new BlockSwapper(world, pos, ModBlocks.altGrass.func_176223_P().func_177226_a(BotaniaStateProps.ALTGRASS_VARIANT, (Comparable)((Object)AltGrassVariant.INFUSED)));
            }
            case 8: {
                return new BlockSwapper(world, pos, ModBlocks.altGrass.func_176223_P().func_177226_a(BotaniaStateProps.ALTGRASS_VARIANT, (Comparable)((Object)AltGrassVariant.MUTATED)));
            }
        }
        return new BlockSwapper(world, pos, Blocks.field_150349_c.func_176223_P());
    }

    @Override
    public IFloatingFlower.IslandType getIslandType(ItemStack stack) {
        return ISLAND_TYPES[Math.min(stack.func_77952_i(), ISLAND_TYPES.length - 1)];
    }

    private static class BlockSwapper {
        public static final int RANGE = 3;
        public static final int TICK_RANGE = 1;
        private final World world;
        private final Random rand;
        private final IBlockState stateToSet;
        private final BlockPos startCoords;
        private int ticksExisted = 0;

        public BlockSwapper(World world, BlockPos coords, IBlockState state) {
            this.world = world;
            this.stateToSet = state;
            this.rand = new Random(coords.hashCode());
            this.startCoords = coords;
        }

        public boolean tick() {
            if (++this.ticksExisted % 20 == 0) {
                for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.startCoords.func_177982_a(-3, 0, -3), (BlockPos)this.startCoords.func_177982_a(3, 0, 3))) {
                    if (this.world.func_180495_p(pos) != this.stateToSet) continue;
                    this.tickBlock(pos);
                }
            }
            return this.ticksExisted < 80;
        }

        public void tickBlock(BlockPos pos) {
            ArrayList<BlockPos> validCoords = new ArrayList<BlockPos>();
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    if (xOffset == 0 && zOffset == 0 || !this.isValidSwapPosition(pos.func_177982_a(xOffset, 0, zOffset))) continue;
                    validCoords.add(pos.func_177982_a(xOffset, 0, zOffset));
                }
            }
            if (!validCoords.isEmpty()) {
                BlockPos toSwap = (BlockPos)validCoords.get(this.rand.nextInt(validCoords.size()));
                this.world.func_175656_a(toSwap, this.stateToSet);
            }
        }

        public boolean isValidSwapPosition(BlockPos pos) {
            IBlockState state = this.world.func_180495_p(pos);
            Block block = state.func_177230_c();
            return !(block != Blocks.field_150346_d && block != Blocks.field_150349_c || block == Blocks.field_150346_d && state.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.DIRT || this.world.func_180495_p(pos.func_177984_a()).getLightOpacity((IBlockAccess)this.world, pos.func_177984_a()) > 1);
        }
    }
}

