/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.recipe.RecipePureDaisy;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTilePureDaisy
extends SubTileEntity {
    private static final String TAG_POSITION = "position";
    private static final String TAG_TICKS_REMAINING = "ticksRemaining";
    private static final int UPDATE_ACTIVE_EVENT = 0;
    private static final int RECIPE_COMPLETE_EVENT = 1;
    private static final BlockPos[] POSITIONS = new BlockPos[]{new BlockPos(-1, 0, -1), new BlockPos(-1, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(1, 0, 1), new BlockPos(1, 0, 0), new BlockPos(1, 0, -1), new BlockPos(0, 0, -1)};
    private int positionAt = 0;
    private final int[] ticksRemaining = new int[POSITIONS.length];
    private int activePositions = 0;

    public SubTilePureDaisy() {
        Arrays.fill(this.ticksRemaining, -1);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.getWorld().field_72995_K) {
            for (int i = 0; i < POSITIONS.length; ++i) {
                if ((this.activePositions >>> i & 1) <= 0) continue;
                BlockPos coords = this.getPos().func_177971_a((Vec3i)POSITIONS[i]);
                Botania.proxy.sparkleFX((double)coords.func_177958_n() + Math.random(), (double)coords.func_177956_o() + Math.random(), (double)coords.func_177952_p() + Math.random(), 1.0f, 1.0f, 1.0f, (float)Math.random(), 5);
            }
            return;
        }
        ++this.positionAt;
        if (this.positionAt == POSITIONS.length) {
            this.positionAt = 0;
        }
        BlockPos acoords = POSITIONS[this.positionAt];
        BlockPos coords = this.supertile.func_174877_v().func_177971_a((Vec3i)acoords);
        World world = this.supertile.func_145831_w();
        if (!world.func_175623_d(coords)) {
            RecipePureDaisy recipe = this.findRecipe(coords);
            if (recipe != null) {
                if (this.ticksRemaining[this.positionAt] == -1) {
                    this.ticksRemaining[this.positionAt] = recipe.getTime();
                }
                int n = this.positionAt;
                this.ticksRemaining[n] = this.ticksRemaining[n] - 1;
                if (this.ticksRemaining[this.positionAt] <= 0) {
                    this.ticksRemaining[this.positionAt] = -1;
                    if (recipe.set(world, coords, this)) {
                        world.func_175641_c(this.getPos(), this.supertile.func_145838_q(), 1, this.positionAt);
                        if (ConfigHandler.blockBreakParticles) {
                            this.supertile.func_145831_w().func_175718_b(2001, coords, Block.func_176210_f((IBlockState)recipe.getOutputState()));
                        }
                    }
                }
            } else {
                this.ticksRemaining[this.positionAt] = -1;
            }
        } else {
            this.ticksRemaining[this.positionAt] = -1;
        }
        this.updateActivePositions();
    }

    private void updateActivePositions() {
        int newActivePositions = 0;
        for (int i = 0; i < this.ticksRemaining.length; ++i) {
            if (this.ticksRemaining[i] <= -1) continue;
            newActivePositions |= 1 << i;
        }
        if (newActivePositions != this.activePositions) {
            this.getWorld().func_175641_c(this.getPos(), this.supertile.func_145838_q(), 0, newActivePositions);
        }
    }

    private RecipePureDaisy findRecipe(BlockPos coords) {
        IBlockState state = this.getWorld().func_180495_p(coords);
        for (RecipePureDaisy recipe : BotaniaAPI.pureDaisyRecipes) {
            if (!recipe.matches(this.getWorld(), coords, this, state)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public boolean receiveClientEvent(int type, int param) {
        switch (type) {
            case 0: {
                this.activePositions = param;
                return true;
            }
            case 1: {
                if (this.getWorld().field_72995_K) {
                    BlockPos coords = this.getPos().func_177971_a((Vec3i)POSITIONS[param]);
                    for (int i = 0; i < 25; ++i) {
                        double x = (double)coords.func_177958_n() + Math.random();
                        double y = (double)coords.func_177956_o() + Math.random() + 0.5;
                        double z = (double)coords.func_177952_p() + Math.random();
                        Botania.proxy.wispFX(x, y, z, 1.0f, 1.0f, 1.0f, (float)Math.random() / 2.0f);
                    }
                }
                return true;
            }
        }
        return super.receiveClientEvent(type, param);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), 1);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        this.positionAt = cmp.func_74762_e(TAG_POSITION);
        if (this.supertile.func_145831_w() != null && !this.supertile.func_145831_w().field_72995_K) {
            for (int i = 0; i < this.ticksRemaining.length; ++i) {
                this.ticksRemaining[i] = cmp.func_74762_e(TAG_TICKS_REMAINING + i);
            }
        }
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_POSITION, this.positionAt);
        for (int i = 0; i < this.ticksRemaining.length; ++i) {
            cmp.func_74768_a(TAG_TICKS_REMAINING + i, this.ticksRemaining[i]);
        }
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.pureDaisy;
    }
}

