/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IInventoryItem;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.util.GlobalTileEntityCacheManager;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PneumaticCraftUtils {
    private static Random rand = new Random();
    private static final List<Item> inventoryItemBlacklist = new ArrayList<Item>();
    public static double[] sin = new double[500];
    public static double[] cos = new double[500];
    public static double[] tan = new double[500];
    public static final int circlePoints = 500;

    public static EnumFacing getDirectionFacing(EntityLivingBase entity, boolean includeUpAndDown) {
        double yaw;
        for (yaw = (double)entity.field_70177_z; yaw < 0.0; yaw += 360.0) {
        }
        yaw %= 360.0;
        if (includeUpAndDown) {
            if (entity.field_70125_A > 45.0f) {
                return EnumFacing.DOWN;
            }
            if (entity.field_70125_A < -45.0f) {
                return EnumFacing.UP;
            }
        }
        if (yaw < 45.0) {
            return EnumFacing.SOUTH;
        }
        if (yaw < 135.0) {
            return EnumFacing.WEST;
        }
        if (yaw < 225.0) {
            return EnumFacing.NORTH;
        }
        if (yaw < 315.0) {
            return EnumFacing.EAST;
        }
        return EnumFacing.SOUTH;
    }

    public static int getYawFromFacing(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 180;
            }
            case SOUTH: {
                return 0;
            }
            case WEST: {
                return 90;
            }
            case EAST: {
                return -90;
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static double rotateMatrixByMetadata(int metadata) {
        float metaRotation;
        EnumFacing facing = EnumFacing.func_82600_a((int)(metadata & 7));
        switch (facing) {
            case UP: {
                metaRotation = 0.0f;
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)-1.0f);
                break;
            }
            case DOWN: {
                metaRotation = 0.0f;
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)1.0f);
                break;
            }
            case NORTH: {
                metaRotation = 0.0f;
                break;
            }
            case EAST: {
                metaRotation = 90.0f;
                break;
            }
            case SOUTH: {
                metaRotation = 180.0f;
                break;
            }
            default: {
                metaRotation = 270.0f;
            }
        }
        GlStateManager.func_179114_b((float)metaRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        return metaRotation;
    }

    public static List<String> convertStringIntoList(String text) {
        return PneumaticCraftUtils.convertStringIntoList(text, 26);
    }

    public static List<String> convertStringIntoList(String text, int maxCharPerLine) {
        StringTokenizer tok = new StringTokenizer(text, " ");
        StringBuilder output = new StringBuilder(text.length());
        ArrayList<String> textList = new ArrayList<String>();
        String color = "";
        int lineLen = 0;
        while (tok.hasMoreTokens()) {
            String word = tok.nextToken();
            if (word.contains("\u00a7")) {
                for (int i = 0; i < word.length() - 1; ++i) {
                    if (!word.substring(i, i + 2).contains("\u00a7")) continue;
                    color = word.substring(i, i + 2);
                }
                lineLen -= 2;
            }
            if (lineLen + word.length() > maxCharPerLine || word.contains("\\n")) {
                word = word.replace("\\n", "");
                textList.add(output.toString());
                output.delete(0, output.length());
                output.append(color);
                lineLen = 0;
            } else if (lineLen > 0) {
                output.append(" ");
                ++lineLen;
            }
            output.append(word);
            lineLen += word.length();
        }
        textList.add(output.toString());
        return textList;
    }

    public static String convertTicksToMinutesAndSeconds(int ticks, boolean fraction) {
        String part = ticks % 20 * 5 + "";
        if (part.length() < 2) {
            part = "0" + part;
        }
        if ((ticks /= 20) < 60) {
            return ticks + (fraction ? "." + part : "") + "s";
        }
        return ticks / 60 + "m " + ticks % 60 + "s";
    }

    public static String convertAmountToString(int amount) {
        if (amount < 1000) {
            return amount + "";
        }
        return amount / 1000 + "k";
    }

    public static String roundNumberTo(double value, int decimals) {
        double ret = PneumaticCraftUtils.roundNumberToDouble(value, decimals);
        if (decimals == 0) {
            return "" + (int)ret;
        }
        return "" + ret;
    }

    public static double roundNumberToDouble(double value, int decimals) {
        return (double)Math.round(value * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals);
    }

    public static String roundNumberTo(float value, int decimals) {
        return "" + (double)Math.round((double)value * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals);
    }

    public static boolean areFloatsEqual(float f1, float f2) {
        return PneumaticCraftUtils.areFloatsEqual(f1, f2, 0.001f);
    }

    public static boolean areFloatsEqual(float f1, float f2, float maxDifference) {
        return Math.abs(f1 - f2) < maxDifference;
    }

    public static String getPartOfString(String string, int progress, int maxProgress) {
        if (progress > maxProgress) {
            return string;
        }
        return string.substring(0, string.length() * progress / maxProgress);
    }

    private static int getMaxItemNameLength(ItemStack[] inventoryStacks) {
        int maxLength = 0;
        for (ItemStack iStack : inventoryStacks) {
            if (iStack.func_190926_b()) continue;
            maxLength = Math.max(maxLength, iStack.func_82833_r().length());
        }
        return maxLength;
    }

    private static void bubbleSortOnCharIndex(ItemStack[] stackArray, int charIndex) {
        for (int i = 0; i < stackArray.length - 1; ++i) {
            for (int j = 1; j < stackArray.length - i; ++j) {
                boolean lowerStackTooShort;
                boolean higherStackTooShort = stackArray[j - 1].func_190926_b() || stackArray[j - 1].func_82833_r().length() <= charIndex;
                boolean bl = lowerStackTooShort = stackArray[j].func_190926_b() || stackArray[j].func_82833_r().length() <= charIndex;
                if (!stackArray[j - 1].func_190926_b() && (stackArray[j].func_190926_b() || !lowerStackTooShort && !higherStackTooShort && stackArray[j - 1].func_82833_r().charAt(charIndex) <= stackArray[j].func_82833_r().charAt(charIndex))) continue;
                ItemStack temp = stackArray[j - 1];
                stackArray[j - 1] = stackArray[j];
                stackArray[j] = temp;
            }
        }
    }

    public static void sortCombineItemStacksAndToString(List<String> textList, ItemStack[] originalStacks) {
        Object[] stacks = new ItemStack[originalStacks.length];
        Arrays.fill(stacks, ItemStack.field_190927_a);
        for (int i = 0; i < originalStacks.length; ++i) {
            if (originalStacks[i].func_190926_b()) continue;
            stacks[i] = originalStacks[i].func_77946_l();
        }
        int maxItemNameLength = PneumaticCraftUtils.getMaxItemNameLength((ItemStack[])stacks);
        for (int i = maxItemNameLength - 1; i >= 0; --i) {
            PneumaticCraftUtils.bubbleSortOnCharIndex((ItemStack[])stacks, i);
        }
        int itemCount = 0;
        Object oldItemStack = ItemStack.field_190927_a;
        List<ItemStack> oldInventoryItems = null;
        for (Object stack : stacks) {
            if (stack.func_190926_b()) continue;
            if (oldItemStack.func_190926_b() || !stack.func_77969_a(oldItemStack) || oldInventoryItems != null && oldInventoryItems.size() > 0) {
                if (!oldItemStack.func_190926_b()) {
                    textList.add("\u2022 " + PneumaticCraftUtils.convertAmountToString(itemCount) + " x " + oldItemStack.func_82833_r());
                }
                if (oldInventoryItems != null) {
                    int oldSize = textList.size();
                    PneumaticCraftUtils.sortCombineItemStacksAndToString(textList, oldInventoryItems.toArray(new ItemStack[oldInventoryItems.size()]));
                    for (int i = oldSize; i < textList.size(); ++i) {
                        textList.set(i, ">> " + textList.get(i));
                    }
                }
                oldItemStack = stack;
                itemCount = stack.func_190916_E();
            } else {
                itemCount += stack.func_190916_E();
            }
            oldInventoryItems = PneumaticCraftUtils.getStacksInItem((ItemStack)stack);
        }
        if (itemCount > 0 && !oldItemStack.func_190926_b()) {
            textList.add("\u2022 " + PneumaticCraftUtils.convertAmountToString(itemCount) + " x " + oldItemStack.func_82833_r());
            if (oldInventoryItems != null) {
                int oldSize = textList.size();
                PneumaticCraftUtils.sortCombineItemStacksAndToString(textList, oldInventoryItems.toArray(new ItemStack[oldInventoryItems.size()]));
                for (int i = oldSize; i < textList.size(); ++i) {
                    textList.set(i, ">> " + textList.get(i));
                }
            }
        }
    }

    public static List<ItemStack> getStacksInItem(@Nonnull ItemStack item) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (item.func_77973_b() instanceof IInventoryItem && !inventoryItemBlacklist.contains(item.func_77973_b())) {
            try {
                ((IInventoryItem)item.func_77973_b()).getStacksInItem(item, items);
            }
            catch (Throwable e) {
                Log.error("An InventoryItem crashed:");
                e.printStackTrace();
                inventoryItemBlacklist.add(item.func_77973_b());
            }
        } else {
            Iterator<IInventoryItem> iterator = ItemRegistry.getInstance().inventoryItems.iterator();
            while (iterator.hasNext()) {
                try {
                    iterator.next().getStacksInItem(item, items);
                }
                catch (Throwable e) {
                    Log.error("An InventoryItem crashed:");
                    e.printStackTrace();
                    iterator.remove();
                }
            }
        }
        return items;
    }

    public static int getRedstoneLevel(World world, BlockPos pos) {
        return world != null ? world.func_175687_A(pos) : 0;
    }

    public static int getRedstoneLevel(World world, BlockPos pos, EnumFacing face) {
        return world.func_175651_c(pos, face);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPage(String urlString) throws IOException {
        StringBuilder all = new StringBuilder();
        try (BufferedReader in = null;){
            String line;
            URL myUrl = new URL(urlString);
            in = new BufferedReader(new InputStreamReader(myUrl.openStream()));
            while ((line = in.readLine()) != null) {
                all.append(line).append(System.getProperty("line.separator"));
            }
        }
        return all.toString();
    }

    public static ItemStack getBuildcraftItemStack(EnumBuildcraftModule module, String itemName) {
        try {
            Class<?> buildcraftItems = Class.forName(PneumaticCraftUtils.getItemClassForModule(module));
            Object ret = buildcraftItems.getField(itemName).get(null);
            if (ret instanceof Item) {
                return new ItemStack((Item)ret);
            }
            if (ret instanceof Block) {
                return new ItemStack((Block)ret);
            }
            return null;
        }
        catch (Exception e) {
            Log.warning("Tried to retrieve a Buildcraft item which failed. Tried to retrieve: " + itemName + ", from module " + PneumaticCraftUtils.getItemClassForModule(module));
            return null;
        }
    }

    private static String getItemClassForModule(EnumBuildcraftModule module) {
        switch (module) {
            case BUILDERS: {
                return "buildcraft.BuildCraftBuilders";
            }
            case CORE: {
                return "buildcraft.BuildCraftCore";
            }
            case ENERGY: {
                return "buildcraft.BuildCraftEnergy";
            }
            case FACTORY: {
                return "buildcraft.BuildCraftFactory";
            }
            case SILICON: {
                return "buildcraft.BuildCraftSilicon";
            }
            case TRANSPORT: {
                return "buildcraft.BuildCraftTransport";
            }
        }
        return "";
    }

    public static boolean isRenderIDCamo(EnumBlockRenderType type) {
        return false;
    }

    public static int getProtectingSecurityStations(World world, BlockPos pos, EntityPlayer player, boolean showRangeLines, boolean placementRange) {
        int blockingStations = 0;
        Iterator iterator = PneumaticCraftUtils.getSecurityStations(world, pos, placementRange).iterator();
        while (iterator.hasNext()) {
            TileEntitySecurityStation station = (TileEntitySecurityStation)iterator.next();
            if (station.doesAllowPlayer(player)) continue;
            ++blockingStations;
            if (!showRangeLines) continue;
            station.showRangeLines();
        }
        return blockingStations;
    }

    public static Stream<TileEntitySecurityStation> getSecurityStations(World world, BlockPos pos, boolean placementRange) {
        return GlobalTileEntityCacheManager.getInstance().securityStations.stream().filter(station -> PneumaticCraftUtils.isValidAndInRange(pos, placementRange, station));
    }

    private static boolean isValidAndInRange(BlockPos pos, boolean placementRange, TileEntitySecurityStation station) {
        if (station.hasValidNetwork()) {
            AxisAlignedBB aabb = station.getAffectingAABB();
            if (placementRange) {
                aabb = aabb.func_186662_g(16.0);
            }
            return aabb.func_72318_a(new Vec3d((Vec3i)pos));
        }
        return false;
    }

    public static RayTraceResult getEntityLookedObject(EntityLivingBase entity) {
        return PneumaticCraftUtils.getEntityLookedObject(entity, 4.5f);
    }

    public static RayTraceResult getEntityLookedObject(EntityLivingBase entity, float maxDistance) {
        Pair<Vec3d, Vec3d> vecs = PneumaticCraftUtils.getStartAndEndLookVec(entity, maxDistance);
        return entity.field_70170_p.func_72933_a((Vec3d)vecs.getLeft(), (Vec3d)vecs.getRight());
    }

    public static Pair<Vec3d, Vec3d> getStartAndEndLookVec(EntityLivingBase entity) {
        return PneumaticCraftUtils.getStartAndEndLookVec(entity, 4.5f);
    }

    public static Pair<Vec3d, Vec3d> getStartAndEndLookVec(EntityLivingBase entity, float maxDistance) {
        Vec3d entityVec = entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer ? new Vec3d(entity.field_70165_t, entity.field_70163_u + 1.62, entity.field_70161_v) : new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() - (entity.func_70093_af() ? 0.08 : 0.0), entity.field_70161_v);
        Vec3d entityLookVec = entity.func_70676_i(1.0f);
        Vec3d maxDistVec = entityVec.func_72441_c(entityLookVec.field_72450_a * (double)maxDistance, entityLookVec.field_72448_b * (double)maxDistance, entityLookVec.field_72449_c * (double)maxDistance);
        return new ImmutablePair((Object)entityVec, (Object)maxDistVec);
    }

    public static BlockPos getEntityLookedBlock(EntityLivingBase entity, float maxDistance) {
        RayTraceResult hit = PneumaticCraftUtils.getEntityLookedObject(entity, maxDistance);
        if (hit == null || hit.field_72313_a != RayTraceResult.Type.BLOCK) {
            return null;
        }
        return hit.func_178782_a();
    }

    public static boolean isEntityValidForFilter(String filter, Entity entity) {
        try {
            return PneumaticCraftUtils.isEntityValidForFilterUnsafe(filter, entity);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isEntityValidForFilterUnsafe(String filter, Entity entity) throws IllegalArgumentException {
        int i;
        if (filter == null) {
            return true;
        }
        if (StringUtils.countMatches((CharSequence)filter, (CharSequence)"(") != StringUtils.countMatches((CharSequence)filter, (CharSequence)")")) {
            throw new IllegalArgumentException("Not an equal amount of opening and closing braces");
        }
        String[] splits = filter.split("[(),]");
        for (i = 0; i < splits.length; ++i) {
            splits[i] = splits[i].trim();
        }
        if (!PneumaticCraftUtils.isEntityValidForName(splits[0], entity)) {
            return false;
        }
        for (i = 1; i < splits.length; ++i) {
            String[] modifier = splits[i].split("=");
            if (modifier.length == 2) {
                if (PneumaticCraftUtils.isEntityValidForModifier(modifier[0].trim(), modifier[1].trim(), entity)) continue;
                return false;
            }
            throw new IllegalArgumentException("No '=' sign in the modifier.");
        }
        return true;
    }

    private static boolean isEntityValidForModifier(String modifier, String value, Entity entity) throws IllegalArgumentException {
        if (modifier.equalsIgnoreCase("age")) {
            if (entity instanceof EntityAgeable) {
                if (value.equalsIgnoreCase("adult")) {
                    return ((EntityAgeable)entity).func_70874_b() >= 0;
                }
                if (value.equalsIgnoreCase("baby")) {
                    return ((EntityAgeable)entity).func_70874_b() < 0;
                }
                throw new IllegalArgumentException(value + " doesn't match 'adult'/'baby'.");
            }
            throw new IllegalArgumentException("This modifier can't be applied to this entity.");
        }
        if (modifier.equalsIgnoreCase("breedable")) {
            if (entity instanceof EntityAgeable) {
                if (value.equalsIgnoreCase("yes")) {
                    return ((EntityAgeable)entity).func_70874_b() == 0;
                }
                if (value.equalsIgnoreCase("no")) {
                    return ((EntityAgeable)entity).func_70874_b() != 0;
                }
                throw new IllegalArgumentException(value + " doesn't match 'yes'/'no'.");
            }
            throw new IllegalArgumentException("This modifier can't be applied to this entity.");
        }
        throw new IllegalArgumentException(modifier + " is not a valid modifier");
    }

    private static boolean isEntityValidForName(String filter, Entity entity) throws IllegalArgumentException {
        if (filter.equals("")) {
            return true;
        }
        if (filter.startsWith("@")) {
            filter = filter.substring(1);
            Class typeClass = null;
            if (filter.equals("mob")) {
                typeClass = EntityMob.class;
            } else if (filter.equals("animal")) {
                typeClass = EntityAnimal.class;
            } else if (filter.equals("living")) {
                typeClass = EntityLivingBase.class;
            } else if (filter.equals("player")) {
                typeClass = EntityPlayer.class;
            } else if (filter.equals("item")) {
                typeClass = EntityItem.class;
            } else if (filter.equals("minecart")) {
                typeClass = EntityMinecart.class;
            } else if (filter.equals("drone")) {
                typeClass = EntityDrone.class;
            }
            if (typeClass != null) {
                return typeClass.isAssignableFrom(entity.getClass());
            }
            throw new IllegalArgumentException(filter + " is not a valid entity type.");
        }
        try {
            String regex = filter.toLowerCase().replaceAll(".", "[$0]").replace("[*]", ".*");
            return entity.func_70005_c_().toLowerCase().matches(regex);
        }
        catch (PatternSyntaxException e) {
            return entity.func_70005_c_().toLowerCase().equals(filter.toLowerCase());
        }
    }

    public static Method getDeclaredMethodIncludingSupertype(Class clazz, String methodName, Class ... methodParms) {
        while (!clazz.equals(Object.class)) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, methodParms);
                return method;
            }
            catch (Exception exception) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    @Nonnull
    public static ItemStack exportStackToInventory(ICapabilityProvider provider, ItemStack stack, EnumFacing side) {
        if (provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler handler = (IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
        }
        return stack;
    }

    public static double distBetween(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(PneumaticCraftUtils.distBetweenSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distBetweenSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0);
    }

    public static double distBetweenSq(Vec3i pos, double x, double y, double z) {
        return PneumaticCraftUtils.distBetweenSq((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, x, y, z);
    }

    public static double distBetweenSq(BlockPos pos1, BlockPos pos2) {
        return PneumaticCraftUtils.distBetweenSq(pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p(), pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
    }

    public static double distBetween(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    public static double distBetweenSq(double x1, double y1, double x2, double y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }

    public static double distBetween(Vec3i pos, double x, double y, double z) {
        return PneumaticCraftUtils.distBetween((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, x, y, z);
    }

    public static double distBetween(Vec3i pos1, Vec3i pos2) {
        return PneumaticCraftUtils.distBetween(pos1, (double)pos2.func_177958_n() + 0.5, (double)pos2.func_177956_o() + 0.5, (double)pos2.func_177952_p() + 0.5);
    }

    public static double distBetween(Vec3d vec, double x, double y, double z) {
        return PneumaticCraftUtils.distBetween(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, x, y, z);
    }

    public static double distBetween(Vec3d vec1, Vec3d vec2) {
        return PneumaticCraftUtils.distBetween(vec1, vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c);
    }

    public static boolean areStacksEqual(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2, boolean checkMeta, boolean checkNBT, boolean checkOreDict, boolean checkModSimilarity) {
        boolean metaOK;
        if (stack1.func_190926_b() && stack2.func_190926_b()) {
            return true;
        }
        if (stack1.func_190926_b() && !stack2.func_190926_b() || !stack1.func_190926_b() && stack2.func_190926_b()) {
            return false;
        }
        if (checkModSimilarity) {
            String mod1 = stack1.func_77973_b().getRegistryName().func_110624_b();
            String mod2 = stack2.func_77973_b().getRegistryName().func_110624_b();
            return mod1.equals(mod2);
        }
        if (checkOreDict) {
            return PneumaticCraftUtils.isSameOreDictStack(stack1, stack2);
        }
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        boolean bl = metaOK = !checkMeta || stack1.func_77952_i() == stack2.func_77952_i();
        boolean nbtOK = !checkNBT || (stack1.func_77942_o() ? stack1.func_77978_p().equals((Object)stack2.func_77978_p()) : !stack2.func_77942_o());
        return metaOK && nbtOK;
    }

    public static boolean isSameOreDictStack(ItemStack stack1, ItemStack stack2) {
        int[] oredictIds;
        for (int oredictId : oredictIds = OreDictionary.getOreIDs((ItemStack)stack1)) {
            NonNullList oreDictStacks = OreDictionary.getOres((String)OreDictionary.getOreName((int)oredictId));
            for (ItemStack oreDictStack : oreDictStacks) {
                if (!OreDictionary.itemMatches((ItemStack)oreDictStack, (ItemStack)stack2, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBlockLiquid(Block block) {
        return block instanceof BlockLiquid || block instanceof IFluidBlock;
    }

    public static String getOrientationName(EnumFacing dir) {
        switch (dir) {
            case UP: {
                return "Top";
            }
            case DOWN: {
                return "Bottom";
            }
            case NORTH: {
                return "North";
            }
            case SOUTH: {
                return "South";
            }
            case EAST: {
                return "East";
            }
            case WEST: {
                return "West";
            }
        }
        return "Unknown";
    }

    public static void dropInventory(IItemHandler inventory, World world, double x, double y, double z) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemStack = inventory.getStackInSlot(i);
            if (itemStack.func_190916_E() <= 0) continue;
            PneumaticCraftUtils.dropItemOnGround(itemStack, world, x, y, z);
        }
    }

    public static void dropItemOnGround(ItemStack stack, World world, BlockPos pos) {
        PneumaticCraftUtils.dropItemOnGround(stack, world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static void dropItemOnGround(ItemStack stack, World world, double x, double y, double z) {
        float dX = rand.nextFloat() * 0.8f + 0.1f;
        float dY = rand.nextFloat() * 0.8f + 0.1f;
        float dZ = rand.nextFloat() * 0.8f + 0.1f;
        EntityItem entityItem = new EntityItem(world, x + (double)dX, y + (double)dY, z + (double)dZ, new ItemStack(stack.func_77973_b(), stack.func_190916_E(), stack.func_77952_i()));
        if (stack.func_77942_o()) {
            entityItem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
        }
        float factor = 0.05f;
        entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
        entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
        entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
        world.func_72838_d((Entity)entityItem);
        stack.func_190920_e(0);
    }

    public static void dropItemOnGroundPrecisely(ItemStack stack, World world, double x, double y, double z) {
        EntityItem entityItem = new EntityItem(world, x, y, z, new ItemStack(stack.func_77973_b(), stack.func_190916_E(), stack.func_77952_i()));
        if (stack.func_77942_o()) {
            entityItem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
        }
        world.func_72838_d((Entity)entityItem);
        stack.func_190920_e(0);
    }

    public static TileEntity getTileEntity(BlockPos pos, int dimension) {
        WorldServer world = DimensionManager.getWorld((int)dimension);
        if (world != null && world.func_175667_e(pos)) {
            return world.func_175625_s(pos);
        }
        return null;
    }

    public static EntityPlayer getPlayerFromId(String uuid) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(UUID.fromString(uuid));
    }

    public static EntityPlayer getPlayerFromName(String name) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(name);
    }

    public static boolean isPlayerOp(EntityPlayer player) {
        return player.func_70003_b(2, "PneumaticCraftIsPlayerOp");
    }

    private static RayTraceResult raytraceEntityBlocks(EntityLivingBase entity, double range) {
        Pair<Vec3d, Vec3d> startAndEnd = PneumaticCraftUtils.getStartAndEndLookVec(entity, (float)range);
        return entity.field_70170_p.func_147447_a((Vec3d)startAndEnd.getLeft(), (Vec3d)startAndEnd.getRight(), false, false, true);
    }

    public static RayTraceResult getMouseOverServer(EntityLivingBase lookingEntity, double range) {
        RayTraceResult mop = PneumaticCraftUtils.raytraceEntityBlocks(lookingEntity, range);
        double d1 = range;
        Pair<Vec3d, Vec3d> startAndEnd = PneumaticCraftUtils.getStartAndEndLookVec(lookingEntity, (float)range);
        Vec3d vec3 = (Vec3d)startAndEnd.getLeft();
        if (mop != null) {
            d1 = mop.field_72307_f.func_72438_d(vec3);
        }
        Vec3d vec31 = lookingEntity.func_70040_Z();
        Vec3d vec32 = (Vec3d)startAndEnd.getRight();
        Entity pointedEntity = null;
        Vec3d vec33 = null;
        float f1 = 1.0f;
        List list = lookingEntity.field_70170_p.func_72839_b((Entity)lookingEntity, lookingEntity.func_174813_aQ().func_72314_b(vec31.field_72450_a * range, vec31.field_72448_b * range, vec31.field_72449_c * range).func_72314_b((double)f1, (double)f1, (double)f1));
        double d2 = d1;
        for (Entity entity : list) {
            double d3;
            if (!entity.func_70067_L()) continue;
            float f2 = entity.func_70111_Y();
            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72314_b((double)f2, (double)f2, (double)f2);
            RayTraceResult movingobjectposition = axisalignedbb.func_72327_a(vec3, vec32);
            if (axisalignedbb.func_72318_a(vec3)) {
                if (!(0.0 < d2) && d2 != 0.0) continue;
                pointedEntity = entity;
                vec33 = movingobjectposition == null ? vec3 : movingobjectposition.field_72307_f;
                d2 = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = vec3.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
            if (entity == entity.func_184187_bx() && !entity.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity;
                vec33 = movingobjectposition.field_72307_f;
                continue;
            }
            pointedEntity = entity;
            vec33 = movingobjectposition.field_72307_f;
            d2 = d3;
        }
        if (pointedEntity != null && (d2 < d1 || mop == null)) {
            mop = new RayTraceResult(pointedEntity, vec33);
        }
        return mop;
    }

    public static PathFinder getPathFinder() {
        WalkNodeProcessor processor = new WalkNodeProcessor();
        processor.func_186317_a(true);
        return new PathFinder((NodeProcessor)processor);
    }

    public static EntityLiving createDummyEntity(EntityPlayer player) {
        EntityCreeper creeper = new EntityCreeper(player.field_70170_p);
        creeper.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        return creeper;
    }

    public static boolean consumeInventoryItem(InventoryPlayer inv, Item item) {
        for (int i = 0; i < inv.field_70462_a.size(); ++i) {
            if (((ItemStack)inv.field_70462_a.get(i)).func_77973_b() != item) continue;
            ((ItemStack)inv.field_70462_a.get(i)).func_190918_g(1);
            if (((ItemStack)inv.field_70462_a.get(i)).func_190916_E() <= 0) {
                inv.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            }
            return true;
        }
        return false;
    }

    public static boolean consumeInventoryItem(InventoryPlayer inv, ItemStack item) {
        for (int i = 0; i < inv.field_70462_a.size(); ++i) {
            if (!ItemStack.func_179545_c((ItemStack)((ItemStack)inv.field_70462_a.get(i)), (ItemStack)item)) continue;
            ((ItemStack)inv.field_70462_a.get(i)).func_190918_g(1);
            if (((ItemStack)inv.field_70462_a.get(i)).func_190916_E() <= 0) {
                inv.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            }
            return true;
        }
        return false;
    }

    public static TileEntity getTileEntitySafely(IBlockAccess world, BlockPos pos) {
        return world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
    }

    public static ResourceLocation RL(String path) {
        return new ResourceLocation("pneumaticcraft", path);
    }

    public static ItemStack singleItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = stack.func_77946_l();
        ret.func_190920_e(1);
        return ret;
    }

    static {
        for (int i = 0; i < 500; ++i) {
            double angle = Math.PI * 2 * (double)i / 500.0;
            PneumaticCraftUtils.sin[i] = Math.sin(angle);
            PneumaticCraftUtils.cos[i] = Math.cos(angle);
            PneumaticCraftUtils.tan[i] = Math.tan(angle);
        }
    }

    public static enum EnumBuildcraftModule {
        BUILDERS,
        CORE,
        ENERGY,
        FACTORY,
        SILICON,
        TRANSPORT;

    }
}

