/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;

public class DroneProgramBuilder {
    private List<DroneInstruction> instructions = new ArrayList<DroneInstruction>();

    public void add(IProgWidget mainInstruction, IProgWidget ... whitelist) {
        this.instructions.add(new DroneInstruction(mainInstruction, Arrays.asList(whitelist)));
    }

    public List<IProgWidget> build() {
        ArrayList<IProgWidget> allWidgets = new ArrayList<IProgWidget>();
        int curY = 0;
        for (DroneInstruction instruction : this.instructions) {
            instruction.mainInstruction.setX(0);
            instruction.mainInstruction.setY(curY);
            if (!instruction.whitelist.isEmpty()) {
                for (int parameterIndex = 0; parameterIndex < instruction.mainInstruction.getParameters().length; ++parameterIndex) {
                    Class<? extends IProgWidget> parameterClass = instruction.mainInstruction.getParameters()[parameterIndex];
                    List whitelist = instruction.whitelist.stream().filter(x -> parameterClass.isAssignableFrom(x.getClass())).collect(Collectors.toList());
                    int curX = instruction.mainInstruction.getWidth() / 2;
                    for (IProgWidget whitelistItem : whitelist) {
                        whitelistItem.setX(curX);
                        whitelistItem.setY(curY + parameterIndex * 11);
                        curX += whitelistItem.getWidth() / 2;
                    }
                }
            }
            curY += instruction.mainInstruction.getHeight() / 2;
            instruction.addToWidgets(allWidgets);
        }
        TileEntityProgrammer.updatePuzzleConnections(allWidgets);
        return allWidgets;
    }

    private class DroneInstruction {
        public final IProgWidget mainInstruction;
        public final List<IProgWidget> whitelist;

        public DroneInstruction(IProgWidget mainInstruction, List<IProgWidget> whitelist) {
            this.mainInstruction = mainInstruction;
            this.whitelist = whitelist;
        }

        public void addToWidgets(List<IProgWidget> widgets) {
            widgets.add(this.mainInstruction);
            widgets.addAll(this.whitelist);
        }
    }
}

