/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import java.util.List;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class TileEntityUVLightBox
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IRedstoneControl,
ILightProvider {
    public static final int INVENTORY_SIZE = 1;
    public static final int PCB_SLOT = 0;
    private Object light = null;
    @DescSynced
    public boolean leftConnected;
    @DescSynced
    public boolean rightConnected;
    @DescSynced
    public boolean areLightsOn;
    @GuiSynced
    public int redstoneMode;
    @DescSynced
    public ItemStackHandler inventory = new ItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    public int ticksExisted;
    private boolean oldRedstoneStatus;

    public TileEntityUVLightBox() {
        super(5.0f, 7.0f, 2000, 4);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.redstoneMode = nbt.func_74762_e("redstoneMode");
        this.inventory.deserializeNBT(nbt.func_74775_l("Items"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("redstoneMode", this.redstoneMode);
        nbt.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        return nbt;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            ++this.ticksExisted;
            ItemStack stack = this.getLoadedPCB();
            if (this.getPressure() >= 1.0f && stack.func_77973_b() == Itemss.EMPTY_PCB && stack.func_77952_i() > 0) {
                this.addAir((int)(-2.0f * this.getSpeedUsageMultiplierFromUpgrades()));
                if (this.ticksExisted % Math.max(1, (int)(600.0f / (5.0f * this.getSpeedMultiplierFromUpgrades()))) == 0) {
                    if (!this.areLightsOn) {
                        this.setLightsOn(true);
                        this.updateNeighbours();
                    }
                    stack.func_77964_b(Math.max(0, stack.func_77952_i() - 1));
                }
            } else if (this.areLightsOn) {
                this.setLightsOn(false);
                this.updateNeighbours();
            }
            if (this.oldRedstoneStatus != this.shouldEmitRedstone()) {
                this.oldRedstoneStatus = !this.oldRedstoneStatus;
                this.updateNeighbours();
            }
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public void onNeighborTileUpdate() {
        super.onNeighborTileUpdate();
        this.updateConnections();
    }

    private void setLightsOn(boolean lightsOn) {
        boolean check = this.areLightsOn != lightsOn;
        this.areLightsOn = lightsOn;
        if (check) {
            this.func_145831_w().func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
            this.sendDescriptionPacket();
        }
    }

    @Override
    public void onDescUpdate() {
        this.func_145831_w().func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
        this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public int getLightLevel() {
        return this.areLightsOn ? Math.max(15, this.getUpgrades(IItemRegistry.EnumUpgrade.SPEED)) + 11 : 0;
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        return side == this.getRotation().func_176735_f();
    }

    private void updateConnections() {
        this.leftConnected = false;
        this.rightConnected = false;
        List<Pair<EnumFacing, IAirHandler>> connections = this.getAirHandler(null).getConnectedPneumatics();
        for (Pair<EnumFacing, IAirHandler> entry : connections) {
            if (entry.getKey() == this.getRotation().func_176746_e()) {
                this.leftConnected = true;
                continue;
            }
            if (entry.getKey() != this.getRotation().func_176735_f()) continue;
            this.rightConnected = true;
        }
    }

    @Override
    public String getName() {
        return Blockss.UV_LIGHT_BOX.func_149739_a();
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 4) {
                this.redstoneMode = 0;
            }
            this.updateNeighbours();
        }
    }

    public boolean shouldEmitRedstone() {
        ItemStack stack = this.getLoadedPCB();
        if (this.redstoneMode == 0 || stack.func_77973_b() != Itemss.EMPTY_PCB) {
            return false;
        }
        switch (this.redstoneMode) {
            case 1: {
                return stack.func_77952_i() < 30;
            }
            case 2: {
                return stack.func_77952_i() < 20;
            }
            case 3: {
                return stack.func_77952_i() < 10;
            }
            case 4: {
                return stack.func_77952_i() == 0;
            }
        }
        return false;
    }

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public String getRedstoneButtonText(int mode) {
        if (mode == 0) {
            return "gui.tab.redstoneBehaviour.button.never";
        }
        return "gui.tab.redstoneBehaviour.uvLightBox.button.chance." + (10 * mode + 60);
    }

    @Override
    public float getMinWorkingPressure() {
        return 1.0f;
    }

    public ItemStack getLoadedPCB() {
        return this.inventory.getStackInSlot(0);
    }

    @Override
    @Optional.Method(modid="albedo")
    public Light provideLight() {
        if (this.light == null && this.areLightsOn) {
            int radius = Math.max(8, 4 + this.getUpgrades(IItemRegistry.EnumUpgrade.SPEED));
            this.light = new Light(this.pos().func_177958_n(), this.field_174879_c.func_177956_o(), this.pos().func_177952_p(), 0.2f, 0.0f, 1.0f, 1.0f, radius);
        } else if (!this.areLightsOn) {
            this.light = null;
        }
        return (Light)this.light;
    }
}

