/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.client.AreaShowManager;
import me.desht.pneumaticcraft.common.NBTUtil;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.item.ItemProgrammingPuzzle;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.progwidgets.WidgetRegistrator;
import me.desht.pneumaticcraft.common.tileentity.FilteredItemStackHandler;
import me.desht.pneumaticcraft.common.tileentity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Sounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityProgrammer
extends TileEntityTickableBase
implements IGUITextFieldSensitive {
    private static final int INVENTORY_SIZE = 1;
    public final List<IProgWidget> progWidgets = new ArrayList<IProgWidget>();
    @GuiSynced
    public int redstoneMode;
    private ProgrammerItemHandler inventory = new ProgrammerItemHandler();
    public static final int PROGRAM_SLOT = 0;
    public int translatedX;
    public int translatedY;
    public int zoomState;
    public boolean showInfo = true;
    public boolean showFlow = true;
    @GuiSynced
    public boolean canUndo;
    @GuiSynced
    public boolean canRedo;
    private NBTTagList history = new NBTTagList();
    private int historyIndex;

    public TileEntityProgrammer() {
        this.saveToHistory();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.history = tag.func_150295_c("history", 10);
        if (this.history.func_74745_c() == 0) {
            this.saveToHistory();
        }
    }

    @Override
    public void readFromPacket(NBTTagCompound tag) {
        super.readFromPacket(tag);
        this.readProgWidgetsFromNBT(tag);
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        tag.func_74782_a("history", (NBTBase)this.history);
        return tag;
    }

    @Override
    public void writeToPacket(NBTTagCompound tag) {
        super.writeToPacket(tag);
        this.writeProgWidgetsToNBT(tag);
    }

    public void readProgWidgetsFromNBT(NBTTagCompound tag) {
        this.progWidgets.clear();
        TileEntityProgrammer.getWidgetsFromNBT(tag, this.progWidgets);
    }

    public void writeProgWidgetsToNBT(NBTTagCompound tag) {
        TileEntityProgrammer.setWidgetsToNBT(this.progWidgets, tag);
    }

    @Nonnull
    public ItemStack getIteminProgrammingSlot() {
        return this.inventory.getStackInSlot(0);
    }

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.inventory;
    }

    public static List<IProgWidget> getWidgetsFromNBT(NBTTagCompound tag) {
        ArrayList<IProgWidget> progWidgets = new ArrayList<IProgWidget>();
        TileEntityProgrammer.getWidgetsFromNBT(tag, progWidgets);
        return progWidgets;
    }

    private static void getWidgetsFromNBT(NBTTagCompound tag, List<IProgWidget> progWidgets) {
        NBTTagList widgetTags = tag.func_150295_c("widgets", 10);
        block0: for (int i = 0; i < widgetTags.func_74745_c(); ++i) {
            NBTTagCompound widgetTag = widgetTags.func_150305_b(i);
            String widgetName = widgetTag.func_74779_i("name");
            for (IProgWidget widget : WidgetRegistrator.registeredWidgets) {
                if (!widgetName.equals(widget.getWidgetString())) continue;
                IProgWidget addedWidget = widget.copy();
                addedWidget.readFromNBT(widgetTag);
                progWidgets.add(addedWidget);
                continue block0;
            }
        }
        TileEntityProgrammer.updatePuzzleConnections(progWidgets);
    }

    public static void setWidgetsToNBT(List<IProgWidget> widgets, NBTTagCompound tag) {
        NBTTagList widgetTags = new NBTTagList();
        for (IProgWidget widget : widgets) {
            NBTTagCompound widgetTag = new NBTTagCompound();
            widget.writeToNBT(widgetTag);
            widgetTags.func_74742_a((NBTBase)widgetTag);
        }
        tag.func_74782_a("widgets", (NBTBase)widgetTags);
    }

    public static void updatePuzzleConnections(List<IProgWidget> progWidgets) {
        Class<? extends IProgWidget>[] parameters;
        for (IProgWidget widget : progWidgets) {
            widget.setParent(null);
            parameters = widget.getParameters();
            if (parameters != null) {
                for (int i = 0; i < parameters.length * 2; ++i) {
                    widget.setParameter(i, null);
                }
            }
            if (!widget.hasStepOutput()) continue;
            widget.setOutputWidget(null);
        }
        for (IProgWidget checkedWidget : progWidgets) {
            parameters = checkedWidget.getParameters();
            if (parameters != null) {
                for (IProgWidget widget : progWidgets) {
                    if (widget == checkedWidget || checkedWidget.getX() + checkedWidget.getWidth() / 2 != widget.getX()) continue;
                    for (int i = 0; i < parameters.length; ++i) {
                        if (!checkedWidget.canSetParameter(i) || parameters[i] != widget.returnType() || checkedWidget.getY() + i * 11 != widget.getY()) continue;
                        checkedWidget.setParameter(i, widget);
                        widget.setParent(checkedWidget);
                    }
                }
            }
            if (!checkedWidget.hasStepOutput()) continue;
            for (IProgWidget widget : progWidgets) {
                if (!widget.hasStepInput() || widget.getX() != checkedWidget.getX() || widget.getY() != checkedWidget.getY() + checkedWidget.getHeight() / 2) continue;
                checkedWidget.setOutputWidget(widget);
            }
        }
        for (IProgWidget checkedWidget : progWidgets) {
            if (checkedWidget.returnType() != null || (parameters = checkedWidget.getParameters()) == null) continue;
            for (int i = 0; i < parameters.length; ++i) {
                if (!checkedWidget.canSetParameter(i)) continue;
                for (IProgWidget widget : progWidgets) {
                    if (parameters[i] != widget.returnType() || widget == checkedWidget || widget.getX() + widget.getWidth() / 2 != checkedWidget.getX() || widget.getY() != checkedWidget.getY() + i * 11) continue;
                    IProgWidget root = widget;
                    while (root.getParent() != null) {
                        root = root.getParent();
                    }
                    checkedWidget.setParameter(i + parameters.length, root);
                }
            }
        }
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        switch (buttonID) {
            case 0: {
                if (++this.redstoneMode <= 1) break;
                this.redstoneMode = 0;
                break;
            }
            case 1: {
                NBTTagCompound tag;
                ItemStack stack = this.inventory.getStackInSlot(0);
                NBTTagCompound nBTTagCompound = tag = stack.func_190926_b() ? null : stack.func_77978_p();
                if (tag != null) {
                    this.readProgWidgetsFromNBT(tag);
                    break;
                }
                this.progWidgets.clear();
                break;
            }
            case 2: {
                this.tryProgramDrone(player);
                break;
            }
            case 9: {
                this.undo();
                break;
            }
            case 10: {
                this.redo();
            }
        }
        this.sendDescriptionPacket();
    }

    @Override
    public void setText(int textFieldID, String text) {
        ItemStack stack = this.inventory.getStackInSlot(0).func_77946_l();
        if (textFieldID == 0 && !stack.func_190926_b()) {
            stack.func_151001_c(text);
            this.inventory.setStackInSlot(0, stack);
        }
    }

    @Override
    public String getText(int textFieldID) {
        return this.inventory.getStackInSlot(0).func_82833_r();
    }

    private void tryProgramDrone(EntityPlayer player) {
        if (!this.inventory.getStackInSlot(0).func_190926_b()) {
            ItemStack stack;
            if (player == null || !player.field_71075_bZ.field_75098_d) {
                List<ItemStack> requiredStacks = this.getRequiredPuzzleStacks();
                for (ItemStack stack2 : requiredStacks) {
                    if (this.hasEnoughPuzzleStacks(player, stack2)) continue;
                    return;
                }
                for (ItemStack stack2 : requiredStacks) {
                    int left = stack2.func_190916_E();
                    if (player != null) {
                        for (int i = 0; !(i >= player.field_71071_by.func_70302_i_() || PneumaticCraftUtils.areStacksEqual(stack2, player.field_71071_by.func_70301_a(i), true, true, false, false) && (left -= player.field_71071_by.func_70298_a(i, left).func_190916_E()) <= 0); ++i) {
                        }
                    }
                    if (left <= 0) continue;
                    for (EnumFacing d : EnumFacing.field_82609_l) {
                        ItemStack neighborStack;
                        IItemHandler neighbor = IOHelper.getInventoryForTE(this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(d)), d.func_176734_d());
                        if (neighbor == null) continue;
                        for (int slot = 0; !(slot >= neighbor.getSlots() || PneumaticCraftUtils.areStacksEqual(neighborStack = neighbor.extractItem(slot, left, true), stack2, true, true, false, false) && (left -= (neighborStack = neighbor.extractItem(slot, left, false)).func_190916_E()) <= 0); ++slot) {
                        }
                    }
                }
                List<ItemStack> returnedStacks = this.getReturnedPuzzleStacks();
                for (ItemStack stack3 : returnedStacks) {
                    for (EnumFacing d : EnumFacing.field_82609_l) {
                        TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(d));
                        if (te != null && (stack3 = IOHelper.insert(te, stack3, d.func_176734_d(), false)).func_190926_b()) break;
                    }
                    if (player != null && !stack3.func_190926_b() && !player.field_71071_by.func_70441_a(stack3)) {
                        player.func_71019_a(stack3.func_77946_l(), false);
                        stack3 = ItemStack.field_190927_a;
                    }
                    if (stack3.func_190926_b()) continue;
                    this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.5, (double)this.func_174877_v().func_177952_p() + 0.5, stack3));
                }
            }
            if (!(stack = this.inventory.getStackInSlot(0)).func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
                this.inventory.setStackInSlot(0, stack);
            }
            this.writeProgWidgetsToNBT(stack.func_77978_p());
            NetworkHandler.sendTo(new PacketPlaySound(Sounds.HUD_INIT_COMPLETE, SoundCategory.NEUTRAL, this.func_174877_v(), 1.0f, 1.0f, false), (EntityPlayerMP)player);
        }
    }

    public List<ItemStack> getRequiredPuzzleStacks() {
        ItemStack stackInSlot = this.inventory.getStackInSlot(0);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (!stackInSlot.func_190926_b() && ((IProgrammable)stackInSlot.func_77973_b()).usesPieces(stackInSlot)) {
            Map<Integer, Integer> tePieces = TileEntityProgrammer.getPuzzleSummary(this.progWidgets);
            Map<Integer, Integer> dronePieces = TileEntityProgrammer.getPuzzleSummary(TileEntityProgrammer.getProgWidgets(stackInSlot));
            for (Integer includedWidget : tePieces.keySet()) {
                Integer existingWidgets = dronePieces.get(includedWidget);
                if (existingWidgets != null) {
                    Integer neededWidgets = tePieces.get(includedWidget);
                    if (neededWidgets <= existingWidgets) continue;
                    ItemStack stack = ItemProgrammingPuzzle.getStackForColor(includedWidget);
                    stack.func_190920_e((neededWidgets - existingWidgets) * stackInSlot.func_190916_E());
                    stacks.add(stack);
                    continue;
                }
                ItemStack stack = ItemProgrammingPuzzle.getStackForColor(includedWidget);
                stack.func_190920_e(tePieces.get(includedWidget) * stackInSlot.func_190916_E());
                stacks.add(stack);
            }
        }
        return stacks;
    }

    public List<ItemStack> getReturnedPuzzleStacks() {
        ItemStack stackInSlot = this.inventory.getStackInSlot(0);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (!stackInSlot.func_190926_b() && ((IProgrammable)stackInSlot.func_77973_b()).usesPieces(stackInSlot)) {
            Map<Integer, Integer> tePieces = TileEntityProgrammer.getPuzzleSummary(this.progWidgets);
            Map<Integer, Integer> dronePieces = TileEntityProgrammer.getPuzzleSummary(TileEntityProgrammer.getProgWidgets(stackInSlot));
            for (Integer availableWidget : dronePieces.keySet()) {
                Integer requiredWidget = tePieces.get(availableWidget);
                if (requiredWidget != null) {
                    Integer availableWidgets = dronePieces.get(availableWidget);
                    if (availableWidgets <= requiredWidget) continue;
                    ItemStack stack = ItemProgrammingPuzzle.getStackForColor(availableWidget);
                    stack.func_190920_e((availableWidgets - requiredWidget) * stackInSlot.func_190916_E());
                    while (stack.func_190916_E() > stack.func_77976_d()) {
                        stacks.add(stack.func_77979_a(stack.func_77976_d()));
                    }
                    stacks.add(stack);
                    continue;
                }
                ItemStack stack = ItemProgrammingPuzzle.getStackForColor(availableWidget);
                stack.func_190920_e(dronePieces.get(availableWidget) * stackInSlot.func_190916_E());
                while (stack.func_190916_E() > stack.func_77976_d()) {
                    stacks.add(stack.func_77979_a(stack.func_77976_d()));
                }
                stacks.add(stack);
            }
        }
        return stacks;
    }

    public static List<IProgWidget> getProgWidgets(ItemStack iStack) {
        if (NBTUtil.hasTag(iStack, "widgets")) {
            return TileEntityProgrammer.getWidgetsFromNBT(iStack.func_77978_p());
        }
        return new ArrayList<IProgWidget>();
    }

    public boolean hasEnoughPuzzleStacks(EntityPlayer player, ItemStack stack) {
        int amountLeft = stack.func_190916_E();
        if (player != null) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack playerStack = player.field_71071_by.func_70301_a(i);
                if (!PneumaticCraftUtils.areStacksEqual(playerStack, stack, true, true, false, false) || (amountLeft -= playerStack.func_190916_E()) > 0) continue;
                return true;
            }
        }
        for (EnumFacing d : EnumFacing.field_82609_l) {
            TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(d));
            if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, d.func_176734_d())) continue;
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, d.func_176734_d());
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack neighborStack = handler.getStackInSlot(slot);
                if (!PneumaticCraftUtils.areStacksEqual(neighborStack, stack, true, true, false, false) || (amountLeft -= neighborStack.func_190916_E()) > 0) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<Integer, Integer> getPuzzleSummary(List<IProgWidget> widgets) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (IProgWidget widget : widgets) {
            if (widget.getCraftingColorIndex() == -1) continue;
            if (!map.containsKey(widget.getCraftingColorIndex())) {
                map.put(widget.getCraftingColorIndex(), 1);
                continue;
            }
            map.put(widget.getCraftingColorIndex(), (Integer)map.get(widget.getCraftingColorIndex()) + 1);
        }
        return map;
    }

    public Set<String> getAllVariables() {
        HashSet<String> variables = new HashSet<String>();
        for (IProgWidget widget : this.progWidgets) {
            if (!(widget instanceof IVariableWidget)) continue;
            ((IVariableWidget)((Object)widget)).addVariables(variables);
        }
        variables.remove("");
        return variables;
    }

    @Override
    public String getName() {
        return Blockss.PROGRAMMER.func_149739_a();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
    }

    @Override
    protected void onFirstServerUpdate() {
        super.onFirstServerUpdate();
    }

    public boolean previewArea(int widgetX, int widgetY) {
        for (IProgWidget w : this.progWidgets) {
            if (w.getX() != widgetX || w.getY() != widgetY || !(w instanceof IAreaProvider)) continue;
            HashSet<BlockPos> area = new HashSet<BlockPos>();
            ((IAreaProvider)((Object)w)).getArea(area);
            AreaShowManager.getInstance().showArea(area, -1878982912, (TileEntity)this);
        }
        return true;
    }

    public void saveToHistory() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeProgWidgetsToNBT(tag);
        if (this.history.func_74745_c() == 0 || !this.history.func_150305_b(this.historyIndex).equals((Object)tag)) {
            while (this.history.func_74745_c() > this.historyIndex + 1) {
                this.history.func_74744_a(this.historyIndex + 1);
            }
            this.history.func_74742_a((NBTBase)tag);
            if (this.history.func_74745_c() > 20) {
                this.history.func_74744_a(0);
            }
            this.historyIndex = this.history.func_74745_c() - 1;
            this.updateUndoRedoState();
        }
    }

    public void undo() {
        if (this.canUndo) {
            --this.historyIndex;
            this.readProgWidgetsFromNBT(this.history.func_150305_b(this.historyIndex));
            this.updateUndoRedoState();
        }
    }

    public void redo() {
        if (this.canRedo) {
            ++this.historyIndex;
            this.readProgWidgetsFromNBT(this.history.func_150305_b(this.historyIndex));
            this.updateUndoRedoState();
        }
    }

    private void updateUndoRedoState() {
        this.canUndo = this.historyIndex > 0;
        this.canRedo = this.historyIndex < this.history.func_74745_c() - 1;
    }

    private class ProgrammerItemHandler
    extends FilteredItemStackHandler {
        ProgrammerItemHandler() {
            super(1);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (TileEntityProgrammer.this.redstoneMode == 1 && slot == 0 && !this.getStackInSlot(slot).func_190926_b()) {
                TileEntityProgrammer.this.tryProgramDrone(null);
            }
        }

        @Override
        public boolean test(Integer slot, ItemStack itemStack) {
            return itemStack.func_77973_b() instanceof IProgrammable && ((IProgrammable)itemStack.func_77973_b()).canProgram(itemStack);
        }
    }
}

