/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.recipe.IPressureChamberRecipe;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirListener;
import me.desht.pneumaticcraft.common.DamageSourcePneumaticCraft;
import me.desht.pneumaticcraft.common.NBTUtil;
import me.desht.pneumaticcraft.common.VillagerHandler;
import me.desht.pneumaticcraft.common.block.BlockPressureChamberValve;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.block.IBlockPressureChamber;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.recipes.PneumaticRecipeRegistry;
import me.desht.pneumaticcraft.common.recipes.PressureChamberRecipe;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureChamberWall;
import me.desht.pneumaticcraft.common.util.ItemStackHandlerIterable;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityPressureChamberValve
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IAirListener {
    @DescSynced
    public int multiBlockX;
    @DescSynced
    public int multiBlockY;
    @DescSynced
    public int multiBlockZ;
    @DescSynced
    public int multiBlockSize;
    public List<TileEntityPressureChamberValve> accessoryValves;
    private final List<BlockPos> nbtValveList;
    private boolean readNBT = false;
    @GuiSynced
    public boolean isValidRecipeInChamber;
    @GuiSynced
    public boolean isSufficientPressureInChamber;
    @GuiSynced
    public float recipePressure;
    @DescSynced
    private ItemStackHandler itemsInChamber = new ItemStackHandler(27);
    private final Random rand = new Random();

    public TileEntityPressureChamberValve() {
        super(5.0f, 7.0f, 1000, 4);
        this.accessoryValves = new ArrayList<TileEntityPressureChamberValve>();
        this.nbtValveList = new ArrayList<BlockPos>();
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        switch (this.getRotation()) {
            case UP: 
            case DOWN: {
                return side == EnumFacing.UP || side == EnumFacing.DOWN;
            }
            case NORTH: 
            case SOUTH: {
                return side == EnumFacing.NORTH || side == EnumFacing.SOUTH;
            }
            case EAST: 
            case WEST: {
                return side == EnumFacing.EAST || side == EnumFacing.WEST;
            }
        }
        return false;
    }

    @Override
    public void addConnectedPneumatics(List<Pair<EnumFacing, IAirHandler>> teList) {
        if (this.accessoryValves != null) {
            for (TileEntityPressureChamberValve valve : this.accessoryValves) {
                if (valve == this) continue;
                teList.add((Pair<EnumFacing, IAirHandler>)new ImmutablePair(null, (Object)valve.getAirHandler(null)));
            }
        }
    }

    @Override
    public void onAirDispersion(IAirHandler handler, EnumFacing dir, int airAdded) {
    }

    @Override
    public int getMaxDispersion(IAirHandler handler, EnumFacing dir) {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void func_73660_a() {
        if (this.readNBT) {
            this.readNBT = false;
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            if (state.func_177230_c() == Blockss.PRESSURE_CHAMBER_VALVE) {
                this.func_145831_w().func_180501_a(this.func_174877_v(), state.func_177226_a((IProperty)BlockPressureChamberValve.FORMED, (Comparable)Boolean.valueOf(this.multiBlockSize > 0)), 2);
            }
            this.accessoryValves.clear();
            for (BlockPos valve : this.nbtValveList) {
                TileEntity te = this.func_145831_w().func_175625_s(valve);
                if (!(te instanceof TileEntityPressureChamberValve)) continue;
                this.accessoryValves.add((TileEntityPressureChamberValve)te);
            }
            if (this.accessoryValves.isEmpty()) {
                this.invalidateMultiBlock();
                TileEntityPressureChamberValve.checkIfProperlyFormed(this.func_145831_w(), this.func_174877_v());
            }
            if (this.func_145831_w().field_72995_K) {
                this.func_145831_w().func_147458_c(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            }
        }
        if (!this.func_145831_w().field_72995_K) {
            this.checkForAirLeak();
        }
        super.func_73660_a();
        if (this.multiBlockSize != 0 && !this.func_145831_w().field_72995_K) {
            this.isValidRecipeInChamber = false;
            this.isSufficientPressureInChamber = false;
            this.recipePressure = Float.MAX_VALUE;
            for (PressureChamberRecipe pressureChamberRecipe : PressureChamberRecipe.chamberRecipes) {
                boolean isSufficientPressureInChamberFlag;
                boolean isValidRecipeInChamberFlag = this.canBeCompressed(pressureChamberRecipe);
                boolean bl = isSufficientPressureInChamberFlag = pressureChamberRecipe.pressure <= this.getPressure() && pressureChamberRecipe.pressure > 0.0f || pressureChamberRecipe.pressure >= this.getPressure() && pressureChamberRecipe.pressure < 0.0f;
                if (isValidRecipeInChamberFlag) {
                    this.isValidRecipeInChamber = true;
                    if (Math.abs(pressureChamberRecipe.pressure) < Math.abs(this.recipePressure)) {
                        this.recipePressure = pressureChamberRecipe.pressure;
                    }
                }
                if (isSufficientPressureInChamberFlag) {
                    this.isSufficientPressureInChamber = true;
                }
                if (!isValidRecipeInChamberFlag || !isSufficientPressureInChamberFlag) continue;
                this.clearStacksInChamber(pressureChamberRecipe.input);
                this.giveOutput(pressureChamberRecipe.output);
            }
            for (IPressureChamberRecipe iPressureChamberRecipe : PressureChamberRecipe.specialRecipes) {
                boolean isSufficientPressureInChamberFlag;
                boolean isValidRecipeInChamberFlag = iPressureChamberRecipe.isValidRecipe(this.itemsInChamber);
                boolean bl = isSufficientPressureInChamberFlag = iPressureChamberRecipe.getCraftingPressure() <= this.getPressure() && iPressureChamberRecipe.getCraftingPressure() > 0.0f || iPressureChamberRecipe.getCraftingPressure() >= this.getPressure() && iPressureChamberRecipe.getCraftingPressure() < 0.0f;
                if (isValidRecipeInChamberFlag) {
                    this.isValidRecipeInChamber = true;
                    if (Math.abs(iPressureChamberRecipe.getCraftingPressure()) < Math.abs(this.recipePressure)) {
                        this.recipePressure = iPressureChamberRecipe.getCraftingPressure();
                    }
                }
                if (isSufficientPressureInChamberFlag) {
                    this.isSufficientPressureInChamber = true;
                }
                if (!isValidRecipeInChamberFlag || !isSufficientPressureInChamberFlag) continue;
                this.giveOutput(iPressureChamberRecipe.craftRecipe(this.itemsInChamber));
            }
            if (this.getPressure() > 1.0f) {
                AxisAlignedBB bbBox = new AxisAlignedBB((double)(this.multiBlockX + 1), (double)(this.multiBlockY + 1), (double)(this.multiBlockZ + 1), (double)(this.multiBlockX + this.multiBlockSize - 1), (double)(this.multiBlockY + this.multiBlockSize - 1), (double)(this.multiBlockZ + this.multiBlockSize - 1));
                List list = this.func_145831_w().func_72872_a(EntityLivingBase.class, bbBox);
                for (EntityLivingBase entity : list) {
                    EntityVillager villager;
                    if (entity instanceof EntityVillager && (villager = (EntityVillager)entity).getProfessionForge() != VillagerHandler.mechanicProfession) {
                        villager.func_70106_y();
                        EntityVillager mechanic = new EntityVillager(this.field_145850_b);
                        mechanic.setProfession(VillagerHandler.mechanicProfession);
                        mechanic.func_70107_b(villager.field_70165_t, villager.field_70163_u, villager.field_70161_v);
                        this.field_145850_b.func_72838_d((Entity)mechanic);
                    }
                    if (entity instanceof EntityVillager && ((EntityVillager)entity).getProfessionForge() == VillagerHandler.mechanicProfession) continue;
                    entity.func_70097_a((DamageSource)DamageSourcePneumaticCraft.PRESSURE, (float)((int)((double)this.getPressure() * 2.0)));
                }
            }
        }
        if (this.func_145831_w().field_72995_K && (double)this.getPressure() > 0.2) {
            void var2_11;
            int particles = (int)Math.pow(this.multiBlockSize - 2, 3.0);
            boolean bl = false;
            while (var2_11 < particles) {
                if (this.rand.nextInt(Math.max(1, 8 - (int)((double)this.getPressure() * 1.5))) == 0) {
                    double posX = (double)this.multiBlockX + 1.0 + this.rand.nextDouble() * ((double)this.multiBlockSize - 2.0);
                    double posY = (double)this.multiBlockY + 1.5 + this.rand.nextDouble() * ((double)this.multiBlockSize - 2.5);
                    double posZ = (double)this.multiBlockZ + 1.0 + this.rand.nextDouble() * ((double)this.multiBlockSize - 2.0);
                    this.func_145831_w().func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, posX, posY, posZ, 0.0, 0.0, 0.0, new int[0]);
                }
                ++var2_11;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkForAirLeak() {
        void var4_7;
        boolean[] connected = new boolean[]{true, true, true, true, true, true};
        switch (this.getRotation()) {
            case UP: 
            case DOWN: {
                connected[EnumFacing.DOWN.ordinal()] = false;
                connected[EnumFacing.UP.ordinal()] = false;
                break;
            }
            case NORTH: 
            case SOUTH: {
                connected[EnumFacing.SOUTH.ordinal()] = false;
                connected[EnumFacing.NORTH.ordinal()] = false;
                break;
            }
            case EAST: 
            case WEST: {
                connected[EnumFacing.WEST.ordinal()] = false;
                connected[EnumFacing.EAST.ordinal()] = false;
            }
        }
        List<Pair<EnumFacing, IAirHandler>> teList = this.getAirHandler(null).getConnectedPneumatics();
        for (Pair<EnumFacing, IAirHandler> pair : teList) {
            if (pair.getKey() == null) continue;
            connected[((EnumFacing)pair.getKey()).ordinal()] = true;
        }
        TileEntityPressureChamberValve baseValve = null;
        for (TileEntityPressureChamberValve valve : this.accessoryValves) {
            if (valve.multiBlockSize <= 0) continue;
            baseValve = valve;
            break;
        }
        if (baseValve != null) {
            switch (this.getRotation()) {
                case UP: 
                case DOWN: {
                    if (baseValve.multiBlockY == this.func_174877_v().func_177956_o()) {
                        connected[EnumFacing.UP.ordinal()] = true;
                        break;
                    }
                    connected[EnumFacing.DOWN.ordinal()] = true;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    if (baseValve.multiBlockZ == this.func_174877_v().func_177952_p()) {
                        connected[EnumFacing.SOUTH.ordinal()] = true;
                        break;
                    }
                    connected[EnumFacing.NORTH.ordinal()] = true;
                    break;
                }
                case EAST: 
                case WEST: {
                    if (baseValve.multiBlockX == this.func_174877_v().func_177958_n()) {
                        connected[EnumFacing.EAST.ordinal()] = true;
                        break;
                    }
                    connected[EnumFacing.WEST.ordinal()] = true;
                }
            }
        }
        boolean bl = false;
        while (var4_7 < 6) {
            if (!connected[var4_7]) {
                this.getAirHandler(null).airLeak(EnumFacing.func_82600_a((int)var4_7));
            }
            ++var4_7;
        }
    }

    private Stream<ItemStack> getFilteredChamberContents(Object item) {
        return new ItemStackHandlerIterable(this.itemsInChamber).stream().filter(stack -> !stack.func_190926_b() && PneumaticRecipeRegistry.isItemEqual(item, stack));
    }

    private boolean canBeCompressed(PressureChamberRecipe recipe) {
        for (Object in : recipe.input) {
            int amount;
            if (in == null || (amount = this.getFilteredChamberContents(in).mapToInt(ItemStack::func_190916_E).sum()) >= PneumaticRecipeRegistry.getItemAmount(in)) continue;
            return false;
        }
        return true;
    }

    private void clearStacksInChamber(Object ... stacks) {
        block0: for (Object stack : stacks) {
            int amountLeft = PneumaticRecipeRegistry.getItemAmount(stack);
            for (int i = 0; i < this.itemsInChamber.getSlots(); ++i) {
                ItemStack itemInChamber = this.itemsInChamber.getStackInSlot(i);
                if (PneumaticRecipeRegistry.isItemEqual(stack, itemInChamber)) {
                    amountLeft -= this.itemsInChamber.extractItem(i, amountLeft, false).func_190916_E();
                }
                if (amountLeft <= 0) continue block0;
            }
        }
    }

    private void giveOutput(NonNullList<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            stack = stack.func_77946_l();
            if ((stack = ItemHandlerHelper.insertItem((IItemHandler)this.itemsInChamber, (ItemStack)stack, (boolean)false)).func_190926_b()) continue;
            this.dropItemOnGround(stack);
        }
    }

    public ItemStackHandler getStacksInChamber() {
        return this.itemsInChamber;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        int i;
        super.func_145839_a(tag);
        this.setMultiBlockCoords(tag.func_74762_e("multiBlockSize"), tag.func_74762_e("multiBlockX"), tag.func_74762_e("multiBlockY"), tag.func_74762_e("multiBlockZ"));
        this.isSufficientPressureInChamber = tag.func_74767_n("sufPressure");
        this.isValidRecipeInChamber = tag.func_74767_n("validRecipe");
        this.recipePressure = tag.func_74760_g("recipePressure");
        this.itemsInChamber.deserializeNBT(tag.func_74775_l("itemsInChamber"));
        if (this.itemsInChamber.getSlots() > 27) {
            ItemStackHandler newHandler = new ItemStackHandler(27);
            for (i = 0; i < 27; ++i) {
                newHandler.setStackInSlot(i, this.itemsInChamber.getStackInSlot(i));
            }
            this.itemsInChamber = newHandler;
        }
        NBTTagList tagList2 = tag.func_150295_c("Valves", 10);
        this.nbtValveList.clear();
        for (i = 0; i < tagList2.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList2.func_150305_b(i);
            this.nbtValveList.add(NBTUtil.getPos(tagCompound));
        }
        this.readNBT = true;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("multiBlockX", this.multiBlockX);
        tag.func_74768_a("multiBlockY", this.multiBlockY);
        tag.func_74768_a("multiBlockZ", this.multiBlockZ);
        tag.func_74768_a("multiBlockSize", this.multiBlockSize);
        tag.func_74757_a("sufPressure", this.isSufficientPressureInChamber);
        tag.func_74757_a("validRecipe", this.isValidRecipeInChamber);
        tag.func_74776_a("recipePressure", this.recipePressure);
        tag.func_74782_a("itemsInChamber", (NBTBase)this.itemsInChamber.serializeNBT());
        NBTTagList tagList2 = new NBTTagList();
        for (TileEntityPressureChamberValve valve : this.accessoryValves) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("x", valve.func_174877_v().func_177958_n());
            tagCompound.func_74768_a("y", valve.func_174877_v().func_177956_o());
            tagCompound.func_74768_a("z", valve.func_174877_v().func_177952_p());
            tagList2.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Valves", (NBTBase)tagList2);
        return tag;
    }

    public void onMultiBlockBreak() {
        if (this.multiBlockSize > 0) {
            Iterator<ItemStack> itemsInChamberIterator = new ItemStackHandlerIterable(this.itemsInChamber).iterator();
            while (itemsInChamberIterator.hasNext()) {
                ItemStack stack = itemsInChamberIterator.next();
                this.dropItemOnGround(stack);
                itemsInChamberIterator.remove();
            }
        }
        this.invalidateMultiBlock();
    }

    private void dropItemOnGround(ItemStack stack) {
        PneumaticCraftUtils.dropItemOnGroundPrecisely(stack, this.func_145831_w(), this.multiBlockX + this.multiBlockSize / 2, this.multiBlockY + 1, this.multiBlockZ + this.multiBlockSize / 2);
    }

    private void invalidateMultiBlock() {
        for (int x = 0; x < this.multiBlockSize; ++x) {
            for (int y = 0; y < this.multiBlockSize; ++y) {
                for (int z = 0; z < this.multiBlockSize; ++z) {
                    TileEntity te = this.func_145831_w().func_175625_s(new BlockPos(x + this.multiBlockX, y + this.multiBlockY, z + this.multiBlockZ));
                    if (!(te instanceof TileEntityPressureChamberWall)) continue;
                    TileEntityPressureChamberWall teWall = (TileEntityPressureChamberWall)te;
                    teWall.setCore(null);
                }
            }
        }
        if (this.accessoryValves != null) {
            for (TileEntityPressureChamberValve valve : this.accessoryValves) {
                valve.setMultiBlockCoords(0, 0, 0, 0);
                if (valve == this) continue;
                valve.accessoryValves.clear();
                if (this.func_145831_w().field_72995_K) continue;
                valve.sendDescriptionPacket();
            }
            this.accessoryValves.clear();
        }
        if (!this.func_145831_w().field_72995_K) {
            this.sendDescriptionPacket();
        }
    }

    private void setMultiBlockCoords(int size, int baseX, int baseY, int baseZ) {
        this.multiBlockSize = size;
        this.multiBlockX = baseX;
        this.multiBlockY = baseY;
        this.multiBlockZ = baseZ;
        this.getAirHandler(null).setDefaultVolume(1000 + (this.multiBlockSize > 0 ? (int)Math.pow(this.multiBlockSize - 2, 3.0) * 16000 : 0));
    }

    public static boolean checkIfProperlyFormed(World world, BlockPos pos) {
        for (int i = 3; i < 6; ++i) {
            if (!TileEntityPressureChamberValve.checkForShiftedCubeOfSize(i, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) continue;
            return true;
        }
        return false;
    }

    private static boolean checkForShiftedCubeOfSize(int size, World world, int baseX, int baseY, int baseZ) {
        for (int wallX = 0; wallX < size; ++wallX) {
            for (int wallY = 0; wallY < size; ++wallY) {
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX, baseY - wallY, baseZ - wallX)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX, baseY + wallY, baseZ + wallX)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - wallX, baseY - wallY, baseZ)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX + wallX, baseY + wallY, baseZ)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - wallX, baseY, baseZ - wallY)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX + wallX, baseY, baseZ + wallY)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - size + 1, baseY - wallY, baseZ - wallX)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - size + 1, baseY + wallY, baseZ + wallX)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - wallX, baseY - wallY, baseZ - size + 1)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX + wallX, baseY + wallY, baseZ - size + 1)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - wallX, baseY - size + 1, baseZ - wallY)) {
                    return true;
                }
                if (!TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX + wallX, baseY - size + 1, baseZ + wallY)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkForCubeOfSize(int size, World world, int baseX, int baseY, int baseZ) {
        boolean validValveFound = false;
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                for (int z = 0; z < size; ++z) {
                    if (x != 0 && x != size - 1 && y != 0 && y != size - 1 && z != 0 && z != size - 1) continue;
                    BlockPos pos = new BlockPos(x + baseX, y + baseY, z + baseZ);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (!(block instanceof IBlockPressureChamber)) {
                        return false;
                    }
                    if (block == Blockss.PRESSURE_CHAMBER_VALVE) {
                        boolean xMid = x != 0 && x != size - 1;
                        boolean yMid = y != 0 && y != size - 1;
                        boolean zMid = z != 0 && z != size - 1;
                        EnumFacing facing = ((TileEntityBase)world.func_175625_s(pos)).getRotation();
                        if (xMid && yMid && (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) || xMid && zMid && (facing == EnumFacing.UP || facing == EnumFacing.DOWN) || yMid && zMid && (facing == EnumFacing.EAST || facing == EnumFacing.WEST)) {
                            validValveFound = true;
                            continue;
                        }
                        return false;
                    }
                    TileEntity te = world.func_175625_s(pos);
                    if (!(te instanceof TileEntityPressureChamberWall) || ((TileEntityPressureChamberWall)te).getCore() == null) continue;
                    return false;
                }
            }
        }
        if (!validValveFound) {
            return false;
        }
        TileEntityPressureChamberValve teValve = null;
        ArrayList<TileEntityPressureChamberValve> valveList = new ArrayList<TileEntityPressureChamberValve>();
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                for (int z = 0; z < size; ++z) {
                    BlockPos pos = new BlockPos(x + baseX, y + baseY, z + baseZ);
                    TileEntity te = world.func_175625_s(pos);
                    if (!(te instanceof TileEntityPressureChamberValve)) continue;
                    boolean xMid = x != 0 && x != size - 1;
                    boolean yMid = y != 0 && y != size - 1;
                    boolean zMid = z != 0 && z != size - 1;
                    EnumFacing facing = ((TileEntityBase)world.func_175625_s(pos)).getRotation();
                    if ((!xMid || !yMid || facing != EnumFacing.NORTH && facing != EnumFacing.SOUTH) && (!xMid || !zMid || facing != EnumFacing.UP && facing != EnumFacing.DOWN) && (!yMid || !zMid || facing != EnumFacing.EAST && facing != EnumFacing.WEST)) continue;
                    teValve = (TileEntityPressureChamberValve)te;
                    valveList.add(teValve);
                }
            }
        }
        if (teValve == null) {
            return false;
        }
        for (TileEntityPressureChamberValve valve : valveList) {
            valve.accessoryValves = new ArrayList<TileEntityPressureChamberValve>(valveList);
            if (world.field_72995_K) continue;
            valve.sendDescriptionPacket();
        }
        super.setMultiBlockCoords(size, baseX, baseY, baseZ);
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                for (int z = 0; z < size; ++z) {
                    TileEntity te = world.func_175625_s(new BlockPos(x + baseX, y + baseY, z + baseZ));
                    if (!(te instanceof TileEntityPressureChamberWall)) continue;
                    TileEntityPressureChamberWall teWall = (TileEntityPressureChamberWall)te;
                    teWall.setCore(teValve);
                }
            }
        }
        teValve.captureEntityItemsInChamber();
        if (!world.field_72995_K) {
            teValve.sendDescriptionPacket();
        }
        return true;
    }

    private AxisAlignedBB getChamberAABB() {
        return new AxisAlignedBB((double)this.multiBlockX, (double)this.multiBlockY, (double)this.multiBlockZ, (double)(this.multiBlockX + this.multiBlockSize), (double)(this.multiBlockY + this.multiBlockSize), (double)(this.multiBlockZ + this.multiBlockSize));
    }

    private void captureEntityItemsInChamber() {
        AxisAlignedBB bbBox = this.getChamberAABB();
        List items = this.func_145831_w().func_72872_a(EntityItem.class, bbBox);
        for (EntityItem item : items) {
            if (item.field_70128_L) continue;
            ItemStack stack = item.func_92059_d();
            ItemStack leftover = ItemHandlerHelper.insertItem((IItemHandler)this.itemsInChamber, (ItemStack)stack, (boolean)false);
            if (leftover.func_190926_b()) {
                item.func_70106_y();
                continue;
            }
            item.func_92058_a(stack);
        }
    }

    public boolean isCoordWithinChamber(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return x > this.multiBlockX && x < this.multiBlockX + this.multiBlockSize - 1 && y > this.multiBlockY && y < this.multiBlockY + this.multiBlockSize - 1 && z > this.multiBlockZ && z < this.multiBlockZ + this.multiBlockSize - 1;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getChamberAABB();
    }

    @Override
    public String getName() {
        return Blockss.PRESSURE_CHAMBER_VALVE.func_149739_a();
    }

    @Override
    public float getMinWorkingPressure() {
        return this.isValidRecipeInChamber ? this.recipePressure : -3.4028235E38f;
    }
}

