/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.tileentity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureChamberValve;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureChamberWall;
import me.desht.pneumaticcraft.common.util.ItemStackHandlerIterable;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Sounds;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityPressureChamberInterface
extends TileEntityPressureChamberWall
implements ITickable,
IGUITextFieldSensitive,
IRedstoneControlled {
    public static final int MAX_PROGRESS = 40;
    public static final int INVENTORY_SIZE = 1;
    private static final int FILTER_SIZE = 9;
    @DescSynced
    private final PressureChamberInterfaceHandler inventory = new PressureChamberInterfaceHandler();
    @DescSynced
    @LazySynced
    public int inputProgress;
    @DescSynced
    @LazySynced
    public int outputProgress;
    @GuiSynced
    public EnumInterfaceMode interfaceMode = EnumInterfaceMode.NONE;
    @GuiSynced
    private boolean enoughAir = true;
    @DescSynced
    public EnumFilterMode filterMode = EnumFilterMode.ITEM;
    @GuiSynced
    public int creativeTabID;
    @DescSynced
    public String itemNameFilter = "";
    private boolean isOpeningI;
    private boolean isOpeningO;
    @DescSynced
    private boolean shouldOpenInput;
    @DescSynced
    private boolean shouldOpenOutput;
    @GuiSynced
    public int redstoneMode;
    private int inputTimeOut;
    private int oldItemCount;
    private final PressureChamberFilterHandler filterHandler = new PressureChamberFilterHandler();

    public TileEntityPressureChamberInterface() {
        super(4);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED);
    }

    public void func_73660_a() {
        this.updateImpl();
        boolean wasOpeningI = this.isOpeningI;
        boolean wasOpeningO = this.isOpeningO;
        TileEntityPressureChamberValve core = this.getCore();
        if (!this.func_145831_w().field_72995_K) {
            int itemCount = this.inventory.getStackInSlot(0).func_190916_E();
            if (this.oldItemCount != itemCount) {
                this.oldItemCount = itemCount;
                this.inputTimeOut = 0;
            }
            this.interfaceMode = this.getInterfaceMode(core);
            this.enoughAir = true;
            if (this.interfaceMode != EnumInterfaceMode.NONE) {
                if (!this.inventory.getStackInSlot(0).func_190926_b() && ++this.inputTimeOut > 10) {
                    this.shouldOpenInput = false;
                    if (this.inputProgress == 0) {
                        this.shouldOpenOutput = true;
                        if (this.outputProgress == 40) {
                            if (this.interfaceMode == EnumInterfaceMode.IMPORT) {
                                this.outputInChamber();
                            } else {
                                this.exportToInventory();
                            }
                        }
                    }
                } else {
                    this.shouldOpenOutput = false;
                    if (this.outputProgress == 0) {
                        this.shouldOpenInput = true;
                        if (this.interfaceMode == EnumInterfaceMode.EXPORT && this.inputProgress == 40 && this.redstoneAllows()) {
                            this.importFromChamber(core);
                        }
                    }
                }
            } else {
                this.shouldOpenInput = false;
                this.shouldOpenOutput = false;
            }
        }
        int speed = (int)this.getSpeedMultiplierFromUpgrades();
        if (this.shouldOpenInput) {
            this.inputProgress = Math.min(this.inputProgress + speed, 40);
            this.isOpeningI = true;
        } else {
            this.inputProgress = Math.max(this.inputProgress - speed, 0);
            this.isOpeningI = false;
        }
        if (this.shouldOpenOutput) {
            this.outputProgress = Math.min(this.outputProgress + speed, 40);
            this.isOpeningO = true;
        } else {
            this.outputProgress = Math.max(this.outputProgress - speed, 0);
            this.isOpeningO = false;
        }
        if (this.func_145831_w().field_72995_K && (wasOpeningI != this.isOpeningI || wasOpeningO != this.isOpeningO)) {
            this.func_145831_w().func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, Sounds.INTERFACE_DOOR, SoundCategory.BLOCKS, 0.1f, 1.0f, true);
        }
    }

    private void exportToInventory() {
        EnumFacing facing = this.getRotation();
        TileEntity te = this.getCachedNeighbor(facing);
        if (te != null) {
            ItemStack stack = this.inventory.getStackInSlot(0);
            int count = stack.func_190916_E();
            ItemStack leftoverStack = PneumaticCraftUtils.exportStackToInventory((ICapabilityProvider)te, stack.func_77946_l(), facing.func_176734_d());
            stack.func_190918_g(count - leftoverStack.func_190916_E());
        }
    }

    private void importFromChamber(TileEntityPressureChamberValve core) {
        ItemStackHandler chamberStacks = core.getStacksInChamber();
        for (ItemStack chamberStack : new ItemStackHandlerIterable(chamberStacks)) {
            int maxAllowedItems;
            ItemStack inputStack;
            if (chamberStack.func_190926_b() || !(inputStack = this.inventory.getStackInSlot(0)).func_190926_b() && !inputStack.func_77969_a(chamberStack) || !this.filterHandler.doesItemMatchFilter(chamberStack) || (maxAllowedItems = Math.abs(core.getAirHandler(null).getAir()) / 1000) <= 0) continue;
            if (!inputStack.func_190926_b()) {
                maxAllowedItems = Math.min(maxAllowedItems, chamberStack.func_77976_d() - inputStack.func_190916_E());
            }
            int transferredItems = Math.min(chamberStack.func_190916_E(), maxAllowedItems);
            ItemStack toTransferStack = chamberStack.func_77946_l().func_77979_a(transferredItems);
            ItemStack excess = this.inventory.insertItem(0, toTransferStack, true);
            if (excess.func_190916_E() >= toTransferStack.func_190916_E()) continue;
            transferredItems = toTransferStack.func_190916_E() - excess.func_190916_E();
            core.addAir((core.getAirHandler(null).getAir() > 0 ? -1 : 1) * transferredItems * 1000);
            toTransferStack.func_190920_e(transferredItems);
            this.inventory.insertItem(0, toTransferStack, false);
            chamberStack.func_190918_g(transferredItems);
        }
    }

    private void outputInChamber() {
        TileEntityPressureChamberValve valve = this.getCore();
        if (valve != null) {
            ItemStack inputStack = this.inventory.getStackInSlot(0);
            boolean bl = this.enoughAir = Math.abs(valve.getAirHandler(null).getAir()) > inputStack.func_190916_E() * 1000;
            if (this.enoughAir) {
                ItemStack leftover = ItemHandlerHelper.insertItem((IItemHandler)valve.getStacksInChamber(), (ItemStack)inputStack.func_77946_l(), (boolean)false);
                int inserted = inputStack.func_190916_E() - leftover.func_190916_E();
                valve.addAir((valve.getAirHandler(null).getAir() > 0 ? -1 : 1) * inserted * 1000);
                this.inventory.setStackInSlot(0, leftover);
            }
        }
    }

    private EnumInterfaceMode getInterfaceMode(TileEntityPressureChamberValve core) {
        if (core != null) {
            boolean xMid = this.func_174877_v().func_177958_n() != core.multiBlockX && this.func_174877_v().func_177958_n() != core.multiBlockX + core.multiBlockSize - 1;
            boolean yMid = this.func_174877_v().func_177956_o() != core.multiBlockY && this.func_174877_v().func_177956_o() != core.multiBlockY + core.multiBlockSize - 1;
            boolean zMid = this.func_174877_v().func_177952_p() != core.multiBlockZ && this.func_174877_v().func_177952_p() != core.multiBlockZ + core.multiBlockSize - 1;
            EnumFacing rotation = this.getRotation();
            if (xMid && yMid && rotation == EnumFacing.NORTH || xMid && zMid && rotation == EnumFacing.DOWN || yMid && zMid && rotation == EnumFacing.WEST) {
                if (this.func_174877_v().func_177958_n() == core.multiBlockX || this.func_174877_v().func_177956_o() == core.multiBlockY || this.func_174877_v().func_177952_p() == core.multiBlockZ) {
                    return EnumInterfaceMode.EXPORT;
                }
                return EnumInterfaceMode.IMPORT;
            }
            if (xMid && yMid && rotation == EnumFacing.SOUTH || xMid && zMid && rotation == EnumFacing.UP || yMid && zMid && rotation == EnumFacing.EAST) {
                if (this.func_174877_v().func_177958_n() == core.multiBlockX || this.func_174877_v().func_177956_o() == core.multiBlockY || this.func_174877_v().func_177952_p() == core.multiBlockZ) {
                    return EnumInterfaceMode.IMPORT;
                }
                return EnumInterfaceMode.EXPORT;
            }
        }
        return EnumInterfaceMode.NONE;
    }

    public List<String> getProblemStat() {
        ArrayList<String> textList = new ArrayList<String>();
        if (this.interfaceMode == EnumInterfaceMode.NONE) {
            textList.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a77The Interface can't work:"));
            textList.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a70\u2022 The Interface is not in a properly formed Pressure Chamber, and/or"));
            textList.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a70\u2022 The Interface is not adjacent to an air block of the Pressure Chamber, and/or"));
            textList.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a70\u2022 The Interface isn't oriented properly"));
        } else if (!this.redstoneAllows()) {
            textList.add("gui.tab.problems.redstoneDisallows");
        } else if (!this.enoughAir) {
            textList.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a7Not enough pressure in the Pressure Chamber to move the items."));
            textList.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a70Apply more pressure to the Pressure Chamber. The required pressure is dependent on the amount of items being transported."));
        }
        return textList;
    }

    public boolean hasEnoughPressure() {
        return this.enoughAir;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.filterHandler.deserializeNBT(tag.func_74775_l("filter"));
        this.outputProgress = tag.func_74762_e("outputProgress");
        this.inputProgress = tag.func_74762_e("inputProgress");
        this.interfaceMode = EnumInterfaceMode.values()[tag.func_74762_e("interfaceMode")];
        this.filterMode = EnumFilterMode.values()[tag.func_74762_e("filterMode")];
        this.creativeTabID = tag.func_74762_e("creativeTabID");
        this.itemNameFilter = tag.func_74779_i("itemNameFilter");
        this.redstoneMode = tag.func_74762_e("redstoneMode");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        tag.func_74782_a("filter", (NBTBase)this.filterHandler.serializeNBT());
        tag.func_74768_a("outputProgress", this.outputProgress);
        tag.func_74768_a("inputProgress", this.inputProgress);
        tag.func_74768_a("interfaceMode", this.interfaceMode.ordinal());
        tag.func_74768_a("filterMode", this.filterMode.ordinal());
        tag.func_74768_a("creativeTabID", this.creativeTabID);
        tag.func_74778_a("itemNameFilter", this.itemNameFilter);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        return tag;
    }

    @Override
    public String getName() {
        return Blockss.PRESSURE_CHAMBER_INTERFACE.func_149739_a();
    }

    @Override
    public boolean isGuiUseableByPlayer(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
        if (guiID == 1) {
            this.filterMode = this.filterMode.ordinal() >= EnumFilterMode.values().length - 1 ? EnumFilterMode.ITEM : EnumFilterMode.values()[this.filterMode.ordinal() + 1];
            this.filterHandler.doesItemMatchFilter(new ItemStack(Items.field_151055_y));
        } else if (guiID == 2) {
            ++this.creativeTabID;
            if (this.creativeTabID == 5 || this.creativeTabID == 11) {
                ++this.creativeTabID;
            }
            if (this.creativeTabID >= CreativeTabs.field_78032_a.length) {
                this.creativeTabID = 0;
            }
        } else if (guiID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.itemNameFilter = text;
    }

    @Override
    public String getText(int textFieldID) {
        return this.itemNameFilter;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.inventory;
    }

    public IItemHandler getFilterHandler() {
        return this.filterHandler;
    }

    private class PressureChamberInterfaceHandler
    extends ItemStackHandler {
        PressureChamberInterfaceHandler() {
            super(1);
        }

        protected void onContentsChanged(int slot) {
            if (!TileEntityPressureChamberInterface.this.func_145831_w().field_72995_K && slot == 0) {
                TileEntityPressureChamberInterface.this.sendDescriptionPacket();
            }
        }
    }

    private class PressureChamberFilterHandler
    extends ItemStackHandler {
        PressureChamberFilterHandler() {
            super(9);
        }

        boolean doesItemMatchFilter(ItemStack itemStack) {
            if (itemStack.func_190926_b()) {
                return true;
            }
            switch (TileEntityPressureChamberInterface.this.filterMode) {
                case ITEM: {
                    boolean filterEmpty = true;
                    for (int i = 0; i < 9; ++i) {
                        ItemStack filterStack = this.getStackInSlot(i);
                        if (filterStack.func_190926_b()) continue;
                        filterEmpty = false;
                        if (!itemStack.func_77969_a(filterStack)) continue;
                        return true;
                    }
                    return filterEmpty;
                }
                case CREATIVE_TAB: {
                    try {
                        int itemCreativeTabIndex;
                        int n = itemCreativeTabIndex = itemStack.func_77973_b().func_77640_w() != null ? itemStack.func_77973_b().func_77640_w().func_78021_a() : -1;
                        if (itemCreativeTabIndex == TileEntityPressureChamberInterface.this.creativeTabID) {
                            return true;
                        }
                    }
                    catch (Throwable e) {
                        TileEntityPressureChamberInterface.this.filterMode = EnumFilterMode.NAME_BEGINS;
                    }
                    return false;
                }
                case NAME_BEGINS: {
                    return itemStack.func_82833_r().toLowerCase().startsWith(TileEntityPressureChamberInterface.this.itemNameFilter.toLowerCase());
                }
                case NAME_CONTAINS: {
                    return itemStack.func_82833_r().toLowerCase().contains(TileEntityPressureChamberInterface.this.itemNameFilter.toLowerCase());
                }
            }
            return false;
        }
    }

    public static enum EnumFilterMode {
        ITEM,
        CREATIVE_TAB,
        NAME_BEGINS,
        NAME_CONTAINS;

    }

    public static enum EnumInterfaceMode {
        NONE,
        IMPORT,
        EXPORT;

    }
}

