/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.fluid.Fluids;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.LuaMethod;
import me.desht.pneumaticcraft.common.tileentity.FilteredItemStackHandler;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.ISmartFluidSync;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityPlasticMixer
extends TileEntityTickableBase
implements IHeatExchanger,
IRedstoneControlled,
ISerializableTanks,
ISmartFluidSync {
    private static final int BASE_TEMPERATURE = FluidRegistry.WATER.getTemperature();
    public static final int INVENTORY_SIZE = 5;
    public static final int DYE_BUFFER_MAX = 8160;
    private static final int DYE_PER_DYE = 2550;
    private static final String[] DYES = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
    public static final int INV_INPUT = 0;
    public static final int INV_OUTPUT = 1;
    public static final int INV_DYE_RED = 2;
    public static final int INV_DYE_GREEN = 3;
    public static final int INV_DYE_BLUE = 4;
    @LazySynced
    @DescSynced
    @GuiSynced
    private final PlasticFluidTank tank = new PlasticFluidTank(16000);
    @DescSynced
    private int fluidAmountScaled;
    private final ItemStackHandler inventory = new PlasticItemStackHandler();
    private int lastTickInventoryStacksize;
    @GuiSynced
    private final IHeatExchangerLogic hullLogic = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();
    @GuiSynced
    private final IHeatExchangerLogic itemLogic = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();
    @GuiSynced
    public int selectedPlastic = -1;
    @GuiSynced
    private int redstoneMode;
    @GuiSynced
    public boolean lockSelection;
    @GuiSynced
    public int[] dyeBuffers = new int[3];

    public TileEntityPlasticMixer() {
        super(4);
        this.hullLogic.addConnectedExchanger(this.itemLogic);
        this.hullLogic.setThermalCapacity(100.0);
    }

    @SideOnly(value=Side.CLIENT)
    public IHeatExchangerLogic getLogic(int index) {
        switch (index) {
            case 0: {
                return this.hullLogic;
            }
            case 1: {
                return this.itemLogic;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + index);
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public String getName() {
        return Blockss.PLASTIC_MIXER.func_149739_a();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            ItemStack solidifiedStack;
            this.refillDyeBuffers();
            this.itemLogic.update();
            ItemStack inputStack = this.inventory.getStackInSlot(0);
            if (this.func_145831_w().func_82737_E() % 20L == 0L) {
                FluidStack moltenPlastic;
                int maxFill;
                if (inputStack.func_190916_E() > this.lastTickInventoryStacksize) {
                    int stackIncrease = inputStack.func_190916_E() - this.lastTickInventoryStacksize;
                    double ratio = (double)inputStack.func_190916_E() / (double)(inputStack.func_190916_E() + stackIncrease);
                    this.itemLogic.setTemperature((int)(ratio * this.itemLogic.getTemperature() + (1.0 - ratio) * (double)BASE_TEMPERATURE));
                } else if (inputStack.func_190926_b()) {
                    this.itemLogic.setTemperature(BASE_TEMPERATURE);
                }
                if (this.itemLogic.getTemperature() >= 423.0 && (maxFill = this.tank.fill(moltenPlastic = new FluidStack(Fluids.PLASTIC, inputStack.func_190916_E() * 1000), false) / 1000) > 0) {
                    this.inventory.extractItem(0, maxFill, false);
                    this.tank.fill(new FluidStack(moltenPlastic, maxFill * 1000), true);
                }
                this.lastTickInventoryStacksize = this.inventory.getStackInSlot(0).func_190916_E();
                this.itemLogic.setThermalCapacity(this.lastTickInventoryStacksize);
            }
            if (this.tank.getFluid() != null && this.selectedPlastic >= 0 && this.redstoneAllows() && (solidifiedStack = new ItemStack(Itemss.PLASTIC, this.tank.getFluid().amount / 1000, this.selectedPlastic)).func_190916_E() > 0) {
                solidifiedStack.func_190920_e(1);
                if (this.inventory.getStackInSlot(1).func_190926_b()) {
                    solidifiedStack.func_190920_e(this.useDye(solidifiedStack.func_190916_E()));
                    if (solidifiedStack.func_190916_E() > 0) {
                        this.inventory.setStackInSlot(1, solidifiedStack);
                        this.tank.drain(solidifiedStack.func_190916_E() * 1000, true);
                        this.sendDescriptionPacket();
                    }
                } else if (solidifiedStack.func_77969_a(this.inventory.getStackInSlot(1))) {
                    int solidifiedItems = Math.min(64 - this.inventory.getStackInSlot(1).func_190916_E(), solidifiedStack.func_190916_E());
                    solidifiedItems = this.useDye(solidifiedItems);
                    ItemStack newStack = this.inventory.getStackInSlot(1);
                    newStack.func_190917_f(solidifiedItems);
                    this.inventory.setStackInSlot(1, newStack);
                    this.tank.drain(solidifiedItems * 1000, true);
                    this.sendDescriptionPacket();
                }
            }
            if (!this.lockSelection) {
                this.selectedPlastic = -1;
            }
            if (this.redstoneMode == 3) {
                this.selectedPlastic = this.poweredRedstone;
            }
        }
    }

    private void refillDyeBuffers() {
        for (int i = 0; i < 3; ++i) {
            if (this.inventory.getStackInSlot(2 + i).func_190926_b() || this.dyeBuffers[i] > 5610) continue;
            this.inventory.extractItem(2 + i, 1, false);
            int n = i;
            this.dyeBuffers[n] = this.dyeBuffers[n] + 2550;
        }
    }

    private int useDye(int maxItems) {
        int colorComponent;
        int i;
        int desiredColor = ItemDye.field_150922_c[this.selectedPlastic];
        if (this.selectedPlastic == 15) {
            return maxItems;
        }
        for (i = 0; i < 3; ++i) {
            colorComponent = desiredColor >> 8 * i & 0xFF;
            if ((colorComponent = 255 - colorComponent) <= 0) continue;
            maxItems = Math.min(maxItems, this.dyeBuffers[i] / colorComponent);
        }
        i = 0;
        while (i < 3) {
            colorComponent = desiredColor >> 8 * i & 0xFF;
            colorComponent = 255 - colorComponent;
            int n = i++;
            this.dyeBuffers[n] = this.dyeBuffers[n] - colorComponent * maxItems;
        }
        return maxItems;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.lastTickInventoryStacksize = tag.func_74762_e("lastTickInventoryStacksize");
        this.selectedPlastic = tag.func_74762_e("selectedPlastic");
        this.lockSelection = tag.func_74767_n("lockSelection");
        this.dyeBuffers[0] = tag.func_74762_e("dyeBuffer0");
        this.dyeBuffers[1] = tag.func_74762_e("dyeBuffer1");
        this.dyeBuffers[2] = tag.func_74762_e("dyeBuffer2");
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.itemLogic.readFromNBT(tag.func_74775_l("itemLogic"));
        this.tank.setFluid(null);
        this.tank.readFromNBT(tag.func_74775_l("fluid"));
        this.fluidAmountScaled = this.tank.getScaledFluidAmount();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("lastTickInventoryStacksize", this.lastTickInventoryStacksize);
        tag.func_74768_a("selectedPlastic", this.selectedPlastic);
        tag.func_74757_a("lockSelection", this.lockSelection);
        tag.func_74768_a("dyeBuffer0", this.dyeBuffers[0]);
        tag.func_74768_a("dyeBuffer1", this.dyeBuffers[1]);
        tag.func_74768_a("dyeBuffer2", this.dyeBuffers[2]);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        NBTTagCompound heatTag = new NBTTagCompound();
        this.itemLogic.writeToNBT(heatTag);
        tag.func_74782_a("itemLogic", (NBTBase)heatTag);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tag.func_74782_a("fluid", (NBTBase)tankTag);
        return tag;
    }

    @Override
    @Nonnull
    public Map<String, FluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)((Object)this.tank));
    }

    @Override
    public void updateScaledFluidAmount(int tankIndex, int amount) {
        this.fluidAmountScaled = amount;
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(EnumFacing side) {
        return this.hullLogic;
    }

    public static int getDyeIndex(ItemStack stack) {
        int[] ids;
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            String name = OreDictionary.getOreName((int)id);
            for (int i = 0; i < DYES.length; ++i) {
                if (!DYES[i].equals(name)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
        super.handleGUIButtonPress(guiID, player);
        if (guiID == 0) {
            if (++this.redstoneMode > 3) {
                this.redstoneMode = 0;
            }
        } else if (guiID >= 1 && guiID < 17) {
            this.selectedPlastic = this.selectedPlastic != guiID ? guiID - 1 : -1;
        } else if (guiID == 17) {
            this.lockSelection = !this.lockSelection;
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public boolean redstoneAllows() {
        return this.redstoneMode == 3 || super.redstoneAllows();
    }

    @Override
    protected void addLuaMethods() {
        super.addLuaMethods();
        this.luaMethods.add(new LuaMethod("selectColor"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    int selection = ((Double)args[0]).intValue();
                    if (selection >= 0 && selection <= 16) {
                        TileEntityPlasticMixer.this.selectedPlastic = selection - 1;
                        return null;
                    }
                    throw new IllegalArgumentException("selectColor method only accepts a value ranging from 0-16. The value passed was: " + selection);
                }
                throw new IllegalArgumentException("selectColor method requires 1 argument (int color index, with 0 being no color");
            }
        });
    }

    @Override
    public String getRedstoneButtonText(int mode) {
        return mode == 3 ? "gui.tab.redstoneBehaviour.plasticMixer.button.selectOnSignal" : super.getRedstoneButtonText(mode);
    }

    private static class PlasticItemStackHandler
    extends FilteredItemStackHandler {
        PlasticItemStackHandler() {
            super(5);
        }

        @Override
        public boolean test(Integer slot, ItemStack itemStack) {
            if (itemStack.func_190926_b()) {
                return true;
            }
            switch (slot) {
                case 0: 
                case 1: {
                    return itemStack.func_77973_b() == Itemss.PLASTIC;
                }
                case 2: {
                    return TileEntityPlasticMixer.getDyeIndex(itemStack) == 1;
                }
                case 3: {
                    return TileEntityPlasticMixer.getDyeIndex(itemStack) == 2;
                }
                case 4: {
                    return TileEntityPlasticMixer.getDyeIndex(itemStack) == 4;
                }
            }
            return false;
        }
    }

    private class PlasticFluidTank
    extends ISmartFluidSync.SmartSyncTank {
        PlasticFluidTank(int capacity) {
            super(TileEntityPlasticMixer.this, capacity);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return Fluids.areFluidsEqual(fluid.getFluid(), Fluids.PLASTIC);
        }
    }
}

