/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class TileEntityElectrostaticCompressor
extends TileEntityPneumaticBase
implements IRedstoneControl {
    private boolean lastRedstoneState;
    @GuiSynced
    public int redstoneMode = 0;
    public int ironBarsBeneath = 0;
    private int struckByLightningCooldown;

    public TileEntityElectrostaticCompressor() {
        super(20.0f, 25.0f, 50000, 4);
    }

    @Override
    public void func_73660_a() {
        if (this.func_145831_w().func_82737_E() % 40L == 0L) {
            this.ironBarsBeneath = 0;
            while (this.ironBarsBeneath < 128 && this.func_145831_w().func_180495_p(this.func_174877_v().func_177967_a(EnumFacing.DOWN, this.ironBarsBeneath + 1)).func_177230_c() == Blocks.field_150411_aY) {
                ++this.ironBarsBeneath;
            }
        }
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            if (this.lastRedstoneState != this.shouldEmitRedstone()) {
                this.lastRedstoneState = !this.lastRedstoneState;
                this.updateNeighbours();
            }
            --this.struckByLightningCooldown;
        }
    }

    @Override
    public boolean isConnectedTo(EnumFacing dir) {
        return dir != EnumFacing.UP;
    }

    private boolean shouldEmitRedstone() {
        switch (this.redstoneMode) {
            case 0: {
                return false;
            }
            case 1: {
                return this.struckByLightningCooldown > 0;
            }
        }
        return false;
    }

    public void onStruckByLightning() {
        this.struckByLightningCooldown = 10;
        if (this.getPressure() > 20.0f) {
            int maxRedirection = 10000 * this.ironBarsBeneath;
            int tooMuchAir = (int)((this.getPressure() - 20.0f) * (float)this.getAirHandler(null).getVolume());
            this.addAir(-Math.min(maxRedirection, tooMuchAir));
        }
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 1) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public String getName() {
        return Blockss.ELECTROSTATIC_COMPRESSOR.func_149739_a();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.redstoneMode = nbtTagCompound.func_74762_e("redstoneMode");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("redstoneMode", this.redstoneMode);
        return nbtTagCompound;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public String getRedstoneButtonText(int mode) {
        return mode == 0 ? "gui.tab.redstoneBehaviour.button.never" : "gui.tab.redstoneBehaviour.electrostaticCompressor.button.struckByLightning";
    }
}

