/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.theoneprobe;

import java.util.ArrayList;
import java.util.function.Function;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.api.tileentity.IPneumaticMachine;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.item.ItemCamoApplicator;
import me.desht.pneumaticcraft.common.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockBasic;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.ElementPressure;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.ITOPInfoProvider;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TOPCallback
implements Function<ITheOneProbe, Void> {
    public static ITheOneProbe probe;
    public static int elementPressure;

    @Override
    public Void apply(ITheOneProbe theOneProbe) {
        probe = theOneProbe;
        PneumaticCraftRepressurized.logger.info("Enabled support for The One Probe");
        elementPressure = probe.registerElementFactory(ElementPressure::new);
        probe.registerProvider(new IProbeInfoProvider(){

            public String getID() {
                return "pneumaticcraft:default";
            }

            public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
                if (blockState.func_177230_c() instanceof ITOPInfoProvider) {
                    ITOPInfoProvider provider = (ITOPInfoProvider)blockState.func_177230_c();
                    provider.addProbeInfo(mode, probeInfo, player, world, blockState, data);
                }
                SemiBlockManager.getInstance(world).getSemiBlocks(world, data.getPos()).forEach(semiBlock -> TOPCallback.handleSemiblock(mode, probeInfo, semiBlock));
            }
        });
        probe.registerEntityProvider(new IProbeInfoEntityProvider(){

            public String getID() {
                return "pneumaticcraft:entity";
            }

            public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
                if (entity instanceof IPressurizable) {
                    String p = PneumaticCraftUtils.roundNumberTo(((IPressurizable)entity).getPressure(ItemStack.field_190927_a), 1);
                    probeInfo.text("Pressure: " + p + " bar");
                }
            }
        });
        return null;
    }

    public static void handlePneumatic(ProbeMode mode, IProbeInfo probeInfo, IPneumaticMachine pneumaticMachine) {
        IAirHandler airHandler = pneumaticMachine.getAirHandler(null);
        if (mode == ProbeMode.EXTENDED) {
            probeInfo.text("Pressure:");
            probeInfo.horizontal().element((IElement)new ElementPressure(pneumaticMachine)).vertical().text("").text("  \u2b05 " + PneumaticCraftUtils.roundNumberTo(airHandler.getPressure(), 2) + " bar");
        } else {
            probeInfo.text(TextFormatting.GRAY + "Pressure: " + TextFormatting.WHITE + PneumaticCraftUtils.roundNumberTo(airHandler.getPressure(), 2) + " bar");
        }
    }

    public static void handleHeat(ProbeMode mode, IProbeInfo probeInfo, IHeatExchanger heatExchanger) {
        HeatExchangerManager.TemperatureData tempData = new HeatExchangerManager.TemperatureData(heatExchanger);
        if (tempData.isMultisided()) {
            for (EnumFacing face : EnumFacing.field_82609_l) {
                if (!tempData.hasData(face)) continue;
                int tempInt = (int)tempData.getTemperature(face) - 273;
                probeInfo.text(I18n.func_74837_a((String)("waila.temperature." + face), (Object[])new Object[]{tempInt}));
            }
        } else if (tempData.hasData(null)) {
            int tempInt = (int)tempData.getTemperature(null) - 273;
            probeInfo.text(I18n.func_74837_a((String)"waila.temperature", (Object[])new Object[]{tempInt}));
        }
    }

    public static void handleSemiblock(ProbeMode mode, IProbeInfo probeInfo, ISemiBlock semiBlock) {
        ArrayList<String> currenttip = new ArrayList<String>();
        if (semiBlock instanceof SemiBlockBasic) {
            ((SemiBlockBasic)semiBlock).addWailaTooltip(currenttip, new NBTTagCompound());
        }
        for (String s : currenttip) {
            probeInfo.text(s);
        }
    }

    public static void handleRedstoneMode(ProbeMode mode, IProbeInfo probeInfo, TileEntityBase te) {
        if (te instanceof IRedstoneControl) {
            int redstoneMode = ((IRedstoneControl)((Object)te)).getRedstoneMode();
            probeInfo.text(TextFormatting.GRAY + I18n.func_74837_a((String)te.getRedstoneString(), (Object[])new Object[0]) + ": " + TextFormatting.RED + I18n.func_74837_a((String)te.getRedstoneButtonText(redstoneMode), (Object[])new Object[0]));
        }
    }

    public static void handlePressureTube(ProbeMode mode, IProbeInfo probeInfo, TileEntityPressureTube te, EnumFacing face) {
        TubeModule module;
        if (face != null && (module = te.modules[face.ordinal()]) != null) {
            IProbeInfo vert = probeInfo.vertical((ILayoutStyle)new LayoutStyle().borderColor(Integer.valueOf(-12566273)).spacing(3));
            ArrayList<String> currenttip = new ArrayList<String>();
            module.addInfo(currenttip);
            for (String s : currenttip) {
                vert.text(s);
            }
        }
    }

    public static void handleFluidTanks(ProbeMode mode, IProbeInfo probeInfo, IFluidHandler handler) {
        int n = 1;
        for (IFluidTankProperties properties : handler.getTankProperties()) {
            FluidStack fluidStack = properties.getContents();
            String fluidDesc = fluidStack == null ? I18n.func_74837_a((String)"gui.liquid.empty", (Object[])new Object[0]) : fluidStack.amount + "mB " + fluidStack.getLocalizedName();
            probeInfo.text(I18n.func_74837_a((String)"waila.fluid", (Object[])new Object[]{n++, fluidDesc}));
        }
    }

    public static void handleCamo(ProbeMode mode, IProbeInfo probeInfo, IBlockState camo) {
        probeInfo.text(TextFormatting.YELLOW + "[Camo: " + ItemCamoApplicator.getCamoStateDisplayName(camo) + "]");
    }
}

