/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import java.util.List;
import me.desht.pneumaticcraft.common.recipes.PressureChamberRecipe;
import me.desht.pneumaticcraft.common.thirdparty.jei.PneumaticCraftCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.PositionedStack;
import me.desht.pneumaticcraft.common.thirdparty.jei.ResourceDrawable;
import mezz.jei.api.IJeiHelpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class JEIPressureChamberRecipeCategory
extends PneumaticCraftCategory<ChamberRecipeWrapper> {
    JEIPressureChamberRecipeCategory(IJeiHelpers jeiHelpers) {
        super(jeiHelpers);
    }

    public String getUid() {
        return "pneumaticcraft.pressure_chamber";
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"gui.pressureChamber", (Object[])new Object[0]);
    }

    @Override
    public ResourceDrawable getGuiTexture() {
        return new ResourceDrawable("pneumaticcraft:textures/gui/gui_nei_pressure_chamber.png", 0, 0, 5, 11, 166, 130);
    }

    public static class ChamberRecipeWrapper
    extends PneumaticCraftCategory.MultipleInputOutputRecipeWrapper {
        float recipePressure;

        ChamberRecipeWrapper(PressureChamberRecipe recipe) {
            PositionedStack stack;
            int i;
            for (i = 0; i < recipe.input.length; ++i) {
                int posX = 19 + i % 3 * 17;
                int posY = 93 - i / 3 * 17;
                if (recipe.input[i] instanceof Pair) {
                    NonNullList oreInputs = NonNullList.func_191196_a();
                    Pair oreDictEntry = (Pair)recipe.input[i];
                    for (ItemStack s : OreDictionary.getOres((String)((String)oreDictEntry.getKey()))) {
                        s = s.func_77946_l();
                        s.func_190920_e(((Integer)oreDictEntry.getValue()).intValue());
                        oreInputs.add((Object)s);
                    }
                    stack = new PositionedStack((List<ItemStack>)oreInputs, posX, posY);
                } else {
                    stack = new PositionedStack((ItemStack)recipe.input[i], posX, posY);
                }
                this.addIngredient(stack);
            }
            for (i = 0; i < recipe.output.size(); ++i) {
                stack = new PositionedStack((ItemStack)recipe.output.get(i), 101 + i % 3 * 18, 59 + i / 3 * 18);
                this.addOutput(stack);
            }
            this.recipePressure = recipe.pressure;
        }

        @Override
        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            PneumaticCraftCategory.drawAnimatedPressureGauge(120, 27, -1.0f, this.recipePressure, 5.0f, 7.0f);
        }
    }
}

