/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.enderio;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.PneumaticCraftAPIHandler;
import me.desht.pneumaticcraft.common.fluid.Fluids;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class EnderIO
implements IThirdParty {
    @Override
    public void preInit() {
        this.registerFuel(Fluids.DIESEL);
        this.registerFuel(Fluids.KEROSENE);
        this.registerFuel(Fluids.GASOLINE);
        this.registerFuel(Fluids.LPG);
    }

    private void registerFuel(Fluid fluid) {
        this.registerFuel(fluid, 60, PneumaticCraftAPIHandler.getInstance().liquidFuels.get(fluid.getName()) / 60);
    }

    private void registerFuel(Fluid fluid, int powerPerCycle, int burnTime) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("fluidName", fluid.getName());
        tag.func_74768_a("powerPerCycle", powerPerCycle);
        tag.func_74768_a("totalBurnTime", burnTime);
        FMLInterModComms.sendMessage((String)"enderio", (String)"fluidFuel:add", (NBTTagCompound)tag);
    }

    @Override
    public void init() {
        PneumaticRegistry.getInstance().registerXPLiquid(FluidRegistry.getFluid((String)"xpjuice"), 20);
    }

    @Override
    public void postInit() {
        this.registerEnderIOFuel("hootch", 360000);
        this.registerEnderIOFuel("rocket_fuel", 0x111700);
        this.registerEnderIOFuel("fire_water", 1200000);
    }

    private void registerEnderIOFuel(String fluidName, int value) {
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid == null) {
            Log.warning("Couldn't find EnderIO fuel fluid '" + fluidName + "'.  Has it been registered as a fuel?");
        } else {
            PneumaticRegistry.getInstance().registerFuel(fluid, value);
        }
    }
}

