/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.cofhcore;

import cofh.api.util.ThermalExpansionHelper;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.common.PneumaticCraftAPIHandler;
import me.desht.pneumaticcraft.common.fluid.Fluids;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class CoFHCore
implements IThirdParty {
    @Override
    public void init() {
        ThermalExpansionHelper.addCompressionFuel((String)Fluids.DIESEL.getName(), (int)1000000);
        ThermalExpansionHelper.addCompressionFuel((String)Fluids.KEROSENE.getName(), (int)1500000);
        ThermalExpansionHelper.addCompressionFuel((String)Fluids.GASOLINE.getName(), (int)2000000);
        ThermalExpansionHelper.addCompressionFuel((String)Fluids.LPG.getName(), (int)2500000);
        PneumaticCraftRepressurized.logger.info("Added PneumaticCraft: Repressurized fuels to CoFH Compression Dynamo");
        this.registerCoFHfuel("creosote", 75000);
        this.registerCoFHfuel("coal", 300000);
        this.registerCoFHfuel("tree_oil", 750000);
        this.registerCoFHfuel("refined_oil", 937500);
        this.registerCoFHfuel("refined_fuel", 1500000);
        Fluid crudeOil = FluidRegistry.getFluid((String)"crude_oil");
        if (crudeOil != null) {
            PneumaticCraftAPIHandler.getInstance().registerRefineryInput(crudeOil);
            PneumaticCraftRepressurized.logger.info("Added CoFH Crude Oil as a Refinery input");
        }
    }

    private void registerCoFHfuel(String fuelName, int mLPerBucket) {
        Fluid f = FluidRegistry.getFluid((String)fuelName);
        if (f != null) {
            PneumaticCraftAPIHandler.getInstance().registerFuel(f, mLPerBucket);
            PneumaticCraftRepressurized.logger.info("Added CoFH fuel '" + fuelName + "'");
        } else {
            PneumaticCraftRepressurized.logger.warn("Can't find CoFH fuel: " + fuelName);
        }
    }
}

