/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.sensor.pollSensors;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class TwitchStream
extends Thread {
    private static Map<String, TwitchStream> trackedTwitchers = new HashMap<String, TwitchStream>();
    public String channel;
    public boolean keptAlive = true;
    private URL url;
    private BufferedReader reader;
    private boolean online = false;

    private TwitchStream(String name) {
        this.channel = name;
        this.start();
    }

    @Override
    public void run() {
        try {
            while (this.keptAlive) {
                this.keptAlive = false;
                this.refresh();
                Thread.sleep(5000L);
            }
            trackedTwitchers.remove(this);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void refresh() {
        try {
            this.url = new URL("https://api.twitch.tv/kraken/streams/" + this.channel);
            this.reader = new BufferedReader(new InputStreamReader(this.url.openStream()));
            JsonElement json = new JsonParser().parse((Reader)this.reader);
            JsonObject obj = json.getAsJsonObject();
            JsonElement streaming = obj.get("stream");
            this.online = !streaming.isJsonNull();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public static boolean isOnline(String name) {
        TwitchStream stream = trackedTwitchers.get(name);
        if (stream == null) {
            stream = new TwitchStream(name);
            trackedTwitchers.put(name, stream);
        }
        stream.keptAlive = true;
        return stream.online;
    }
}

