/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.sensor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.desht.pneumaticcraft.api.universalSensor.IBlockAndCoordinateEventSensor;
import me.desht.pneumaticcraft.api.universalSensor.IBlockAndCoordinatePollSensor;
import me.desht.pneumaticcraft.api.universalSensor.IEventSensorSetting;
import me.desht.pneumaticcraft.api.universalSensor.IPollSensorSetting;
import me.desht.pneumaticcraft.api.universalSensor.ISensorRegistry;
import me.desht.pneumaticcraft.api.universalSensor.ISensorSetting;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.sensor.eventSensors.BlockInteractSensor;
import me.desht.pneumaticcraft.common.sensor.eventSensors.PlayerAttackSensor;
import me.desht.pneumaticcraft.common.sensor.eventSensors.PlayerItemPickupSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.BlockComparatorSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.BlockHeatSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.BlockLightLevelSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.BlockMetadataSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.BlockPresenceSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.BlockRedstoneSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.PlayerHealthSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.TwitchStreamerSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.UserSetSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.WorldDayLightSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.WorldGlobalVariableSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.WorldPlayersInServerSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.WorldRainingSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.WorldTicktimeSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.WorldTimeSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.WorldWeatherForecaster;
import me.desht.pneumaticcraft.common.sensor.pollSensors.entity.EntityInRangeSensor;
import me.desht.pneumaticcraft.common.tileentity.TileEntityUniversalSensor;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.Rectangle;

public class SensorHandler
implements ISensorRegistry {
    private static final SensorHandler INSTANCE = new SensorHandler();
    private final Map<String, ISensorSetting> sensors = new LinkedHashMap<String, ISensorSetting>();

    public static SensorHandler getInstance() {
        return INSTANCE;
    }

    public void init() {
        this.registerSensor(new EntityInRangeSensor());
        this.registerSensor(new PlayerAttackSensor());
        this.registerSensor(new PlayerItemPickupSensor());
        this.registerSensor(new BlockInteractSensor());
        this.registerSensor(new WorldDayLightSensor());
        this.registerSensor(new WorldRainingSensor());
        this.registerSensor(new WorldTimeSensor());
        this.registerSensor(new WorldWeatherForecaster());
        this.registerSensor(new WorldPlayersInServerSensor());
        this.registerSensor(new WorldTicktimeSensor());
        this.registerSensor(new WorldGlobalVariableSensor());
        this.registerSensor(new BlockPresenceSensor());
        this.registerSensor(new BlockMetadataSensor());
        this.registerSensor(new BlockComparatorSensor());
        this.registerSensor(new BlockRedstoneSensor());
        this.registerSensor(new BlockLightLevelSensor());
        this.registerSensor(new BlockHeatSensor());
        this.registerSensor(new UserSetSensor());
        this.registerSensor(new TwitchStreamerSensor());
        this.registerSensor(new PlayerHealthSensor());
    }

    public ISensorSetting getSensorFromPath(String buttonPath) {
        return this.sensors.get(buttonPath);
    }

    public List<ISensorSetting> getSensorsFromPath(String buttonPath) {
        ArrayList<ISensorSetting> matchingSensors = new ArrayList<ISensorSetting>();
        for (Map.Entry<String, ISensorSetting> entry : this.sensors.entrySet()) {
            if (!entry.getKey().startsWith(buttonPath)) continue;
            matchingSensors.add(entry.getValue());
        }
        return matchingSensors;
    }

    public ISensorSetting getSensorByIndex(int index) {
        return this.getSensorsFromPath("").get(index);
    }

    public String[] getSensorNames() {
        String[] sensorNames = new String[this.sensors.size()];
        Iterator<String> iterator = this.sensors.keySet().iterator();
        for (int i = 0; i < sensorNames.length; ++i) {
            String sensorPath = iterator.next();
            sensorNames[i] = sensorPath.substring(sensorPath.lastIndexOf(47) + 1);
        }
        return sensorNames;
    }

    public ISensorSetting getSensorForName(String name) {
        String[] sensorNames = this.getSensorNames();
        for (int i = 0; i < sensorNames.length; ++i) {
            if (!sensorNames[i].equals(name)) continue;
            return this.getSensorByIndex(i);
        }
        return null;
    }

    public List<String> getUpgradeInfo() {
        ArrayList<String> text = new ArrayList<String>();
        text.add(TextFormatting.GRAY + "The following combinations of upgrades are used in sensors to work:");
        HashSet<Set<Item>> upgrades = new HashSet<Set<Item>>();
        for (ISensorSetting iSensorSetting : this.sensors.values()) {
            upgrades.add(iSensorSetting.getRequiredUpgrades());
        }
        for (Set set : upgrades) {
            StringBuilder upgradeTitle = new StringBuilder();
            for (Item stack : set) {
                upgradeTitle.append(I18n.func_135052_a((String)(stack.func_77658_a() + ".name"), (Object[])new Object[0])).append(" + ");
            }
            upgradeTitle = new StringBuilder(TextFormatting.BLACK + "-" + upgradeTitle.substring(0, upgradeTitle.length() - 3).replace("Machine Upgrade: ", ""));
            text.add(upgradeTitle.toString());
        }
        return text;
    }

    public Set<Item> getUniversalSensorUpgrades() {
        HashSet<Item> items = new HashSet<Item>();
        for (ISensorSetting sensor : this.sensors.values()) {
            items.addAll(sensor.getRequiredUpgrades());
        }
        return items;
    }

    public String[] getDirectoriesAtLocation(String path) {
        ArrayList<String> directories = new ArrayList<String>();
        for (String sensorPath : this.sensors.keySet()) {
            if (!sensorPath.startsWith(path) || sensorPath.equals(path)) continue;
            String[] folders = sensorPath.substring(path.length()).split("/");
            if (folders[0].equals("") && folders.length > 1) {
                if (directories.contains(folders[1])) continue;
                directories.add(folders[1]);
                continue;
            }
            if (directories.contains(folders[0])) continue;
            directories.add(folders[0]);
        }
        Object[] directoryArray = directories.toArray(new String[directories.size()]);
        Arrays.sort(directoryArray);
        return directoryArray;
    }

    private String getUpgradePrefix(ISensorSetting sensor) {
        ArrayList<Item> upgrades = new ArrayList<Item>(sensor.getRequiredUpgrades());
        upgrades.sort(Comparator.comparing(Item::func_77658_a));
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < upgrades.size(); ++i) {
            ret.append(((Item)upgrades.get(i)).func_77658_a()).append(i < upgrades.size() - 1 ? "_" : "/");
        }
        return ret.toString();
    }

    public Set<Item> getRequiredStacksFromText(String text) {
        List<ISensorSetting> sensors = this.getSensorsFromPath(text);
        return sensors.isEmpty() ? new HashSet<Item>() : sensors.get(0).getRequiredUpgrades();
    }

    @Override
    public void registerSensor(ISensorSetting sensor) {
        String path = this.getUpgradePrefix(sensor) + sensor.getSensorPath();
        this.sensors.put(path, sensor);
    }

    @Override
    public void registerSensor(IBlockAndCoordinateEventSensor sensor) {
        this.registerSensor(new BlockAndCoordinateEventSensor(sensor));
    }

    @Override
    public void registerSensor(IBlockAndCoordinatePollSensor sensor) {
        this.registerSensor(new BlockAndCoordinatePollSensor(sensor));
    }

    private class BlockAndCoordinatePollSensor
    implements IPollSensorSetting {
        private final IBlockAndCoordinatePollSensor coordinateSensor;

        public BlockAndCoordinatePollSensor(IBlockAndCoordinatePollSensor sensor) {
            this.coordinateSensor = sensor;
        }

        @Override
        public String getSensorPath() {
            return this.coordinateSensor.getSensorPath();
        }

        @Override
        public boolean needsTextBox() {
            return this.coordinateSensor.needsTextBox();
        }

        @Override
        public List<String> getDescription() {
            return this.coordinateSensor.getDescription();
        }

        @Override
        public int getPollFrequency(TileEntity te) {
            TileEntityUniversalSensor us = (TileEntityUniversalSensor)te;
            Set<BlockPos> positions = us.getGPSPositions();
            int mult = positions.isEmpty() ? 1 : positions.size();
            return this.coordinateSensor.getPollFrequency() * mult;
        }

        @Override
        public int getRedstoneValue(World world, BlockPos pos, int sensorRange, String textBoxText) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityUniversalSensor) {
                TileEntityUniversalSensor teUs = (TileEntityUniversalSensor)te;
                Set<BlockPos> positions = teUs.getGPSPositions();
                return positions.isEmpty() ? 0 : this.coordinateSensor.getRedstoneValue(world, pos, sensorRange, textBoxText, positions);
            }
            return 0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void drawAdditionalInfo(FontRenderer fontRenderer) {
            this.coordinateSensor.drawAdditionalInfo(fontRenderer);
        }

        @Override
        public Rectangle needsSlot() {
            return this.coordinateSensor.needsSlot();
        }

        @Override
        public Set<Item> getRequiredUpgrades() {
            HashSet<Item> upgrades = new HashSet<Item>(this.coordinateSensor.getRequiredUpgrades());
            upgrades.add(Itemss.GPS_TOOL);
            return upgrades;
        }
    }

    private class BlockAndCoordinateEventSensor
    implements IEventSensorSetting {
        private final IBlockAndCoordinateEventSensor coordinateSensor;

        public BlockAndCoordinateEventSensor(IBlockAndCoordinateEventSensor sensor) {
            this.coordinateSensor = sensor;
        }

        @Override
        public String getSensorPath() {
            return this.coordinateSensor.getSensorPath();
        }

        @Override
        public boolean needsTextBox() {
            return this.coordinateSensor.needsTextBox();
        }

        @Override
        public List<String> getDescription() {
            return this.coordinateSensor.getDescription();
        }

        @Override
        public int emitRedstoneOnEvent(Event event, TileEntity tile, int sensorRange, String textboxText) {
            TileEntityUniversalSensor teUs = (TileEntityUniversalSensor)tile;
            Set<BlockPos> positions = teUs.getGPSPositions();
            return positions.isEmpty() ? 0 : this.coordinateSensor.emitRedstoneOnEvent(event, teUs, sensorRange, positions);
        }

        @Override
        public int getRedstonePulseLength() {
            return this.coordinateSensor.getRedstonePulseLength();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void drawAdditionalInfo(FontRenderer fontRenderer) {
            this.coordinateSensor.drawAdditionalInfo(fontRenderer);
        }

        @Override
        public Rectangle needsSlot() {
            return this.coordinateSensor.needsSlot();
        }

        @Override
        public Set<Item> getRequiredUpgrades() {
            HashSet<Item> upgrades = new HashSet<Item>(this.coordinateSensor.getRequiredUpgrades());
            upgrades.add(Itemss.GPS_TOOL);
            return upgrades;
        }
    }
}

