/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.semiblock;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.item.ItemLogisticsFrame;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAddSemiBlock;
import me.desht.pneumaticcraft.common.semiblock.ItemSemiBlockBase;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockBasic;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public abstract class SemiBlockLogistics
extends SemiBlockBasic<TileEntity> {
    private final Map<ItemStack, Integer> incomingStacks = new HashMap<ItemStack, Integer>();
    private final Map<FluidStackWrapper, Integer> incomingFluid = new HashMap<FluidStackWrapper, Integer>();
    private final ItemStackHandler filters = new ItemStackHandler(27);
    @GuiSynced
    private final FluidTank[] fluidFilters = new FluidTank[9];
    @DescSynced
    @GuiSynced
    private boolean invisible;
    private int alpha = 255;

    public SemiBlockLogistics() {
        super(TileEntity.class);
        for (int i = 0; i < this.fluidFilters.length; ++i) {
            this.fluidFilters[i] = new FluidTank(this.canFilterStack() ? 64000 : 1000);
        }
    }

    @Override
    public boolean canPlace(EnumFacing facing) {
        return this.getTileEntity() != null && (this.getTileEntity().hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) || this.getTileEntity().hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null));
    }

    public abstract int getColor();

    public abstract int getPriority();

    public boolean shouldProvideTo(int level) {
        return true;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public void update() {
        super.update();
        if (!this.world.field_72995_K) {
            Iterator<Map.Entry<ItemStack, Integer>> iterator = this.incomingStacks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ItemStack, Integer> entry = iterator.next();
                int counter = entry.getValue();
                if (counter > 10) {
                    iterator.remove();
                    continue;
                }
                entry.setValue(counter + 1);
            }
            Iterator<Map.Entry<FluidStackWrapper, Integer>> it = this.incomingFluid.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<FluidStackWrapper, Integer> entry = it.next();
                int counter = entry.getValue();
                if (counter > 10) {
                    it.remove();
                    continue;
                }
                entry.setValue(counter + 1);
            }
        } else {
            this.alpha = this.invisible && !this.playerIsHoldingLogisticItems() ? Math.max(0, this.alpha - 9) : Math.min(255, this.alpha + 9);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean playerIsHoldingLogisticItems() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_184614_ca();
        return stack.func_77973_b() == Itemss.LOGISTICS_CONFIGURATOR || stack.func_77973_b() == Itemss.LOGISTICS_DRONE || stack.func_77973_b() instanceof ItemSemiBlockBase;
    }

    public void informIncomingStack(ItemStack stack) {
        this.incomingStacks.put(stack, 0);
    }

    public void clearIncomingStack(ItemStack stack) {
        this.incomingStacks.remove(stack);
    }

    public void informIncomingStack(FluidStackWrapper stack) {
        this.incomingFluid.put(stack, 0);
    }

    public void clearIncomingStack(FluidStackWrapper stack) {
        this.incomingFluid.remove(stack);
    }

    public int getIncomingFluid(Fluid fluid) {
        int count = 0;
        for (FluidStackWrapper wrapper : this.incomingFluid.keySet()) {
            if (wrapper.stack.getFluid() != fluid) continue;
            count += wrapper.stack.amount;
        }
        return count;
    }

    public int getIncomingItems(ItemStack stack) {
        int count = 0;
        for (ItemStack s : this.incomingStacks.keySet()) {
            if (!this.isItemEqual(s, stack)) continue;
            count += s.func_190916_E();
        }
        return count;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74782_a("filters", (NBTBase)this.filters.serializeNBT());
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.fluidFilters.length; ++i) {
            FluidTank filter = this.fluidFilters[i];
            if (filter.getFluid() == null) continue;
            NBTTagCompound t = new NBTTagCompound();
            t.func_74768_a("index", i);
            filter.writeToNBT(t);
            tagList.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("fluidFilters", (NBTBase)tagList);
        tag.func_74757_a("invisible", this.invisible);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.filters.deserializeNBT(tag.func_74775_l("filters"));
        NBTTagList tagList = tag.func_150295_c("fluidFilters", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            this.fluidFilters[tagList.func_150305_b(i).func_74762_e("index")].readFromNBT(tagList.func_150305_b(i));
        }
        this.invisible = tag.func_74767_n("invisible");
    }

    public void setFilter(int filterIndex, FluidStack stack) {
        this.fluidFilters[filterIndex].setFluid(stack);
    }

    public IFluidTank getTankFilter(int filterIndex) {
        return this.fluidFilters[filterIndex];
    }

    public IItemHandlerModifiable getFilters() {
        return this.filters;
    }

    @Override
    public void addDrops(NonNullList<ItemStack> drops) {
        super.addDrops(drops);
        boolean shouldAddTag = false;
        for (int i = 0; i < this.filters.getSlots(); ++i) {
            if (this.filters.getStackInSlot(i).func_190926_b()) continue;
            shouldAddTag = true;
            break;
        }
        for (FluidTank fluidFilter : this.fluidFilters) {
            if (fluidFilter.getFluidAmount() <= 0) continue;
            shouldAddTag = true;
            break;
        }
        if (this.invisible) {
            shouldAddTag = true;
        }
        if (shouldAddTag) {
            ItemStack drop = (ItemStack)drops.get(0);
            NBTTagCompound tag = new NBTTagCompound();
            this.writeToNBT(tag);
            drop.func_77982_d(tag);
        }
    }

    @Override
    public void onPlaced(EntityPlayer player, ItemStack stack, EnumFacing facing) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            this.readFromNBT(tag);
        }
    }

    @Override
    public boolean onRightClickWithConfigurator(EntityPlayer player) {
        if (this.getGuiID() != null) {
            NetworkHandler.sendTo(new PacketAddSemiBlock(this.pos, this), (EntityPlayerMP)player);
            player.openGui((Object)PneumaticCraftRepressurized.instance, this.getGuiID().ordinal(), this.world, this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p());
        }
        return true;
    }

    public GuiHandler.EnumGuiId getGuiID() {
        return null;
    }

    public boolean canFilterStack() {
        return false;
    }

    protected boolean isItemEqual(ItemStack s1, ItemStack s2) {
        return s1.func_77969_a(s2);
    }

    protected boolean passesFilter(ItemStack stack) {
        boolean hasStack = false;
        for (int i = 0; i < this.filters.getSlots(); ++i) {
            ItemStack s = this.filters.getStackInSlot(i);
            if (s.func_190926_b()) continue;
            if (this.isItemEqual(s, stack)) {
                return true;
            }
            hasStack = true;
        }
        return !hasStack;
    }

    protected boolean passesFilter(Fluid fluid) {
        boolean hasFilter = false;
        for (FluidTank filter : this.fluidFilters) {
            if (filter.getFluidAmount() <= 0) continue;
            if (filter.getFluid().getFluid() == fluid) {
                return true;
            }
            hasFilter = true;
        }
        return !hasFilter;
    }

    @Override
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
        if (guiID == 9) {
            this.invisible = !this.invisible;
        }
    }

    @Override
    public void addWailaTooltip(List<String> curInfo, NBTTagCompound tag) {
        super.addWailaTooltip(curInfo, tag);
        NonNullList drops = NonNullList.func_191196_a();
        this.addDrops((NonNullList<ItemStack>)drops);
        ((ItemStack)drops.get(0)).func_77982_d(tag);
        ItemLogisticsFrame.addTooltip((ItemStack)drops.get(0), PneumaticCraftRepressurized.proxy.getClientWorld(), curInfo, true);
    }

    @Override
    public void addWailaInfoToTag(NBTTagCompound tag) {
        this.writeToNBT(tag);
    }

    public static class FluidStackWrapper {
        public final FluidStack stack;

        public FluidStackWrapper(FluidStack stack) {
            this.stack = stack;
        }
    }
}

