/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.semiblock;

import me.desht.pneumaticcraft.common.network.PacketDescription;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface ISemiBlock {
    public World getWorld();

    public BlockPos getPos();

    public int getIndex();

    public void writeToNBT(NBTTagCompound var1);

    public void readFromNBT(NBTTagCompound var1);

    public void update();

    public void initialize(World var1, BlockPos var2);

    public void prePlacement(EntityPlayer var1, ItemStack var2, EnumFacing var3);

    public void invalidate();

    public boolean isInvalid();

    public void addDrops(NonNullList<ItemStack> var1);

    public boolean canPlace(EnumFacing var1);

    public void onPlaced(EntityPlayer var1, ItemStack var2, EnumFacing var3);

    public boolean onRightClickWithConfigurator(EntityPlayer var1);

    public void onSemiBlockRemovedFromThisPos(ISemiBlock var1);

    default public boolean canCoexistInSameBlock(ISemiBlock semiBlock) {
        return false;
    }

    public PacketDescription getDescriptionPacket();
}

