/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.recipe.IPneumaticRecipeRegistry;
import me.desht.pneumaticcraft.api.recipe.IPressureChamberRecipe;
import me.desht.pneumaticcraft.api.recipe.IThermopneumaticProcessingPlantRecipe;
import me.desht.pneumaticcraft.common.recipes.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.AmadronOfferManager;
import me.desht.pneumaticcraft.common.recipes.AssemblyRecipe;
import me.desht.pneumaticcraft.common.recipes.BasicThermopneumaticProcessingPlantRecipe;
import me.desht.pneumaticcraft.common.recipes.HeatFrameCoolingRecipe;
import me.desht.pneumaticcraft.common.recipes.PressureChamberRecipe;
import me.desht.pneumaticcraft.common.recipes.RefineryRecipe;
import me.desht.pneumaticcraft.common.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class PneumaticRecipeRegistry
implements IPneumaticRecipeRegistry {
    private static final PneumaticRecipeRegistry INSTANCE = new PneumaticRecipeRegistry();

    public static PneumaticRecipeRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerThermopneumaticProcessingPlantRecipe(IThermopneumaticProcessingPlantRecipe recipe) {
        if (recipe == null) {
            throw new NullPointerException("Recipe can't be null!");
        }
        BasicThermopneumaticProcessingPlantRecipe.recipes.add(recipe);
    }

    @Override
    public void registerThermopneumaticProcessingPlantRecipe(FluidStack requiredFluid, @Nonnull ItemStack requiredItem, FluidStack output, double requiredTemperature, float requiredPressure) {
        if (output == null) {
            throw new NullPointerException("Output can't be null!");
        }
        this.registerThermopneumaticProcessingPlantRecipe(new BasicThermopneumaticProcessingPlantRecipe(requiredFluid, requiredItem, output, requiredTemperature, requiredPressure));
    }

    @Override
    public void addAssemblyDrillRecipe(Object input, Object output) {
        if (output == null) {
            throw new NullPointerException("Output can't be null!");
        }
        if (input == null) {
            throw new NullPointerException("Input can't be null!");
        }
        AssemblyRecipe.drillRecipes.add(new AssemblyRecipe(PneumaticRecipeRegistry.getStackFromObject(input), PneumaticRecipeRegistry.getStackFromObject(output)));
    }

    @Override
    public void addAssemblyLaserRecipe(Object input, Object output) {
        if (output == null) {
            throw new NullPointerException("Output can't be null!");
        }
        if (input == null) {
            throw new NullPointerException("Input can't be null!");
        }
        AssemblyRecipe.laserRecipes.add(new AssemblyRecipe(PneumaticRecipeRegistry.getStackFromObject(input), PneumaticRecipeRegistry.getStackFromObject(output)));
    }

    @Override
    public void registerPressureChamberRecipe(Object[] input, float pressureRequired, ItemStack[] output) {
        if (output == null) {
            throw new NullPointerException("Output can't be null!");
        }
        if (input == null) {
            throw new NullPointerException("Input can't be null!");
        }
        PressureChamberRecipe.chamberRecipes.add(new PressureChamberRecipe(input, pressureRequired, output));
    }

    public static boolean isItemEqual(Object o, @Nonnull ItemStack stack) {
        if (o instanceof ItemStack) {
            return OreDictionary.itemMatches((ItemStack)((ItemStack)o), (ItemStack)stack, (boolean)false);
        }
        String oreDict = (String)((Pair)o).getKey();
        return OreDictionaryHelper.isItemEqual(oreDict, stack);
    }

    public static int getItemAmount(Object o) {
        return o instanceof ItemStack ? ((ItemStack)o).func_190916_E() : ((Integer)((Pair)o).getValue()).intValue();
    }

    public static ItemStack getSingleStack(Object o) {
        if (o instanceof ItemStack) {
            return (ItemStack)o;
        }
        Pair pair = (Pair)o;
        ItemStack s = (ItemStack)OreDictionary.getOres((String)((String)pair.getKey())).get(0);
        s = s.func_77946_l();
        s.func_190920_e(((Integer)pair.getValue()).intValue());
        return s;
    }

    @Override
    public void registerPressureChamberRecipe(IPressureChamberRecipe recipe) {
        if (recipe == null) {
            throw new NullPointerException("Recipe can't be null!");
        }
        PressureChamberRecipe.specialRecipes.add(recipe);
    }

    private static ItemStack getStackFromObject(Object object) {
        if (object instanceof Block) {
            return new ItemStack((Block)object);
        }
        if (object instanceof Item) {
            return new ItemStack((Item)object);
        }
        if (object instanceof ItemStack) {
            return (ItemStack)object;
        }
        throw new IllegalArgumentException("object needs to be of type Block, Item or ItemStack");
    }

    @Override
    public void registerDefaultStaticAmadronOffer(Object input, Object output) {
        AmadronOffer offer = new AmadronOffer(input, output);
        AmadronOfferManager.getInstance().addStaticOffer(offer);
    }

    @Override
    public void registerDefaultPeriodicAmadronOffer(Object input, Object output) {
        AmadronOffer offer = new AmadronOffer(input, output);
        AmadronOfferManager.getInstance().addPeriodicOffer(offer);
    }

    @Override
    public void registerHeatFrameCoolRecipe(Object input, ItemStack output) {
        HeatFrameCoolingRecipe.recipes.add(new HeatFrameCoolingRecipe(input, output));
    }

    @Override
    public void registerRefineryRecipe(FluidStack input, FluidStack ... outputs) {
        RefineryRecipe.recipes.add(new RefineryRecipe(input, outputs));
    }
}

