/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import java.util.Set;
import me.desht.pneumaticcraft.client.AreaShowManager;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;

public class PacketShowArea
extends LocationIntPacket<PacketShowArea> {
    private BlockPos[] area;

    public PacketShowArea() {
    }

    public PacketShowArea(BlockPos pos, BlockPos ... area) {
        super(pos);
        this.area = area;
    }

    public PacketShowArea(BlockPos pos, Set<BlockPos> area) {
        this(pos, area.toArray(new BlockPos[area.size()]));
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.area.length);
        for (BlockPos pos : this.area) {
            buffer.writeInt(pos.func_177958_n());
            buffer.writeInt(pos.func_177956_o());
            buffer.writeInt(pos.func_177952_p());
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.area = new BlockPos[buffer.readInt()];
        for (int i = 0; i < this.area.length; ++i) {
            this.area[i] = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
        }
    }

    @Override
    public void handleClientSide(PacketShowArea message, EntityPlayer player) {
        AreaShowManager.getInstance().showArea(message.area, -1878982657, message.getTileEntity(player.field_70170_p));
    }

    @Override
    public void handleServerSide(PacketShowArea message, EntityPlayer player) {
    }
}

