/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import me.desht.pneumaticcraft.common.network.LocationDoublePacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketPlaySound
extends LocationDoublePacket<PacketPlaySound> {
    private SoundEvent soundEvent;
    private SoundCategory category;
    private float volume;
    private float pitch;
    private boolean bool;
    private ResourceLocation soundName;

    public PacketPlaySound() {
    }

    public PacketPlaySound(SoundEvent soundEvent, SoundCategory category, double x, double y, double z, float volume, float pitch, boolean bool) {
        super(x, y, z);
        this.soundEvent = soundEvent;
        this.soundName = soundEvent.field_187506_b;
        this.category = category;
        this.volume = volume;
        this.pitch = pitch;
    }

    public PacketPlaySound(SoundEvent soundEvent, SoundCategory category, BlockPos pos, float volume, float pitch, boolean bool) {
        this(soundEvent, category, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), volume, pitch, bool);
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.soundName.toString());
        buffer.writeInt(this.category.ordinal());
        buffer.writeFloat(this.volume);
        buffer.writeFloat(this.pitch);
        buffer.writeBoolean(this.bool);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.soundEvent = new SoundEvent(new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buffer)));
        this.category = SoundCategory.values()[buffer.readInt()];
        this.volume = buffer.readFloat();
        this.pitch = buffer.readFloat();
        this.bool = buffer.readBoolean();
    }

    @Override
    public void handleClientSide(PacketPlaySound message, EntityPlayer player) {
        player.field_70170_p.func_184134_a(message.x, message.y, message.z, message.soundEvent, message.category, message.volume, message.pitch, message.bool);
    }

    @Override
    public void handleServerSide(PacketPlaySound message, EntityPlayer player) {
    }
}

