/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.GuiGPSTool;
import me.desht.pneumaticcraft.common.NBTUtil;
import me.desht.pneumaticcraft.common.item.ItemPneumatic;
import me.desht.pneumaticcraft.common.remote.GlobalVariableManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ItemGPSTool
extends ItemPneumatic
implements IPositionProvider {
    public ItemGPSTool() {
        super("gps_tool");
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return EnumActionResult.PASS;
        }
        ItemGPSTool.setGPSLocation(player.func_184614_ca(), pos);
        if (!worldIn.field_72995_K) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + "[GPS Tool] Set Coordinates to " + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + "."), false);
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (handIn != EnumHand.MAIN_HAND) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
        }
        ItemStack stack = playerIn.func_184614_ca();
        if (worldIn.field_72995_K) {
            BlockPos pos = ItemGPSTool.getGPSLocation(stack);
            FMLCommonHandler.instance().showGuiScreen((Object)new GuiGPSTool(pos != null ? pos : new BlockPos(0, 0, 0), ItemGPSTool.getVariable(stack)));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> infoList, ITooltipFlag par4) {
        super.func_77624_a(stack, worldIn, infoList, par4);
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            String varName;
            int x = compound.func_74762_e("x");
            int y = compound.func_74762_e("y");
            int z = compound.func_74762_e("z");
            if (x != 0 || y != 0 || z != 0) {
                infoList.add("\u00a72Set to " + x + ", " + y + ", " + z);
            }
            if (!(varName = ItemGPSTool.getVariable(stack)).equals("")) {
                infoList.add(I18n.func_135052_a((String)"gui.tooltip.gpsTool.variable", (Object[])new Object[]{varName}));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean heldItem) {
        String var = ItemGPSTool.getVariable(stack);
        if (!var.equals("") && !world.field_72995_K) {
            BlockPos pos = GlobalVariableManager.getInstance().getPos(var);
            ItemGPSTool.setGPSLocation(stack, pos);
        }
    }

    public static BlockPos getGPSLocation(ItemStack gpsTool) {
        NBTTagCompound compound = gpsTool.func_77978_p();
        if (compound != null) {
            String var = ItemGPSTool.getVariable(gpsTool);
            if (!var.equals("") && PneumaticCraftRepressurized.proxy.getClientWorld() == null) {
                BlockPos pos = GlobalVariableManager.getInstance().getPos(var);
                ItemGPSTool.setGPSLocation(gpsTool, pos);
            }
            int x = compound.func_74762_e("x");
            int y = compound.func_74762_e("y");
            int z = compound.func_74762_e("z");
            if (x != 0 || y != 0 || z != 0) {
                return new BlockPos(x, y, z);
            }
            return null;
        }
        return null;
    }

    public static void setGPSLocation(ItemStack gpsTool, BlockPos pos) {
        NBTUtil.setPos(gpsTool, (Vec3i)pos);
        String var = ItemGPSTool.getVariable(gpsTool);
        if (!var.equals("")) {
            GlobalVariableManager.getInstance().set(var, pos);
        }
    }

    public static void setVariable(ItemStack gpsTool, String variable) {
        NBTUtil.setString(gpsTool, "variable", variable);
    }

    public static String getVariable(ItemStack gpsTool) {
        return gpsTool.func_77942_o() ? gpsTool.func_77978_p().func_74779_i("variable") : "";
    }

    @Override
    public List<BlockPos> getStoredPositions(@Nonnull ItemStack stack) {
        return Collections.singletonList(ItemGPSTool.getGPSLocation(stack));
    }

    @Override
    public int getRenderColor(int index) {
        return -1862271232;
    }
}

