/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.NBTUtil;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.IChargingStationGUIHolderItem;
import me.desht.pneumaticcraft.common.item.ItemPneumatic;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDrone
extends ItemPneumatic
implements IPressurizable,
IChargingStationGUIHolderItem,
IProgrammable,
IUpgradeAcceptor {
    ItemDrone(String registryName) {
        super(registryName);
        this.func_77656_e(1);
    }

    ItemDrone() {
        this("drone");
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return EnumActionResult.PASS;
        }
        if (!world.field_72995_K) {
            ItemStack iStack = player.func_184614_ca();
            BlockPos placePos = pos.func_177972_a(facing);
            this.spawnDrone(player, world, pos, facing, placePos, iStack);
            iStack.func_190918_g(1);
        }
        return EnumActionResult.SUCCESS;
    }

    public void spawnDrone(EntityPlayer player, World world, BlockPos clickPos, EnumFacing facing, BlockPos placePos, ItemStack iStack) {
        EntityDrone drone = new EntityDrone(world, player);
        drone.func_70107_b((double)placePos.func_177958_n() + 0.5, (double)placePos.func_177956_o() + 0.5, (double)placePos.func_177952_p() + 0.5);
        world.func_72838_d((Entity)drone);
        NBTTagCompound stackTag = iStack.func_77978_p();
        NBTTagCompound entityTag = new NBTTagCompound();
        drone.func_70014_b(entityTag);
        if (stackTag != null) {
            entityTag.func_74782_a("widgets", (NBTBase)stackTag.func_150295_c("widgets", 10).func_74737_b());
            entityTag.func_74776_a("currentAir", stackTag.func_74760_g("currentAir"));
            entityTag.func_74768_a("color", stackTag.func_74762_e("color"));
            entityTag.func_74782_a("UpgradeInventory", (NBTBase)stackTag.func_74775_l("UpgradeInventory"));
        }
        drone.func_70037_a(entityTag);
        if (iStack.func_82837_s()) {
            drone.func_96094_a(iStack.func_82833_r());
        }
        drone.naturallySpawned = false;
        drone.func_180482_a(world.func_175649_E(placePos), null);
    }

    public static void setProgWidgets(List<IProgWidget> widgets, ItemStack iStack) {
        NBTUtil.initNBTTagCompound(iStack);
        TileEntityProgrammer.setWidgetsToNBT(widgets, iStack.func_77978_p());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
            ItemStack chargedStack = new ItemStack((Item)this);
            this.addAir(chargedStack, 120000);
            subItems.add((Object)chargedStack);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
        list.add("Pressure: " + PneumaticCraftUtils.roundNumberTo(this.getPressure(stack), 1) + " bar");
        UpgradableItemUtils.addUpgradeInformation(stack, world, list, flag);
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public float getPressure(ItemStack iStack) {
        float oldVolume;
        float volume = UpgradableItemUtils.getUpgrades(IItemRegistry.EnumUpgrade.VOLUME, iStack) * 5000 + 12000;
        if (volume < (oldVolume = NBTUtil.getFloat(iStack, "volume"))) {
            float currentAir = NBTUtil.getFloat(iStack, "currentAir");
            NBTUtil.setFloat(iStack, "currentAir", currentAir *= volume / oldVolume);
        }
        NBTUtil.setFloat(iStack, "volume", volume);
        return NBTUtil.getFloat(iStack, "currentAir") / volume;
    }

    @Override
    public void addAir(ItemStack iStack, int amount) {
        NBTUtil.setFloat(iStack, "currentAir", NBTUtil.getFloat(iStack, "currentAir") + (float)amount);
    }

    @Override
    public int getVolume(ItemStack iStack) {
        return UpgradableItemUtils.getUpgrades(IItemRegistry.EnumUpgrade.VOLUME, iStack) * 5000 + 12000;
    }

    @Override
    public float maxPressure(ItemStack iStack) {
        return 10.0f;
    }

    @Override
    public GuiHandler.EnumGuiId getGuiID() {
        return GuiHandler.EnumGuiId.DRONE;
    }

    @Override
    public boolean canProgram(ItemStack stack) {
        return true;
    }

    @Override
    public boolean usesPieces(ItemStack stack) {
        return true;
    }

    @Override
    public boolean showProgramTooltip() {
        return true;
    }

    @Override
    public Set<Item> getApplicableUpgrades() {
        HashSet<Item> set = new HashSet<Item>();
        for (IItemRegistry.EnumUpgrade upgrade : IItemRegistry.EnumUpgrade.values()) {
            if (!this.upgradeApplies(upgrade)) continue;
            set.add(Itemss.upgrades.get(upgrade));
        }
        return set;
    }

    public boolean upgradeApplies(IItemRegistry.EnumUpgrade upgrade) {
        switch (upgrade) {
            case VOLUME: 
            case DISPENSER: 
            case ITEM_LIFE: 
            case SECURITY: 
            case SPEED: 
            case ENTITY_TRACKER: 
            case MAGNET: 
            case RANGE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return this.func_77658_a() + ".name";
    }
}

