/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.inventory.IPhantomSlot;
import me.desht.pneumaticcraft.common.inventory.SlotUpgrade;
import me.desht.pneumaticcraft.common.inventory.SyncedField;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.NetworkUtils;
import me.desht.pneumaticcraft.common.network.PacketUpdateGui;
import me.desht.pneumaticcraft.common.tileentity.IGUIButtonSensitive;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerPneumaticBase<Tile extends TileEntityBase>
extends Container
implements IGUIButtonSensitive {
    public Tile te;
    private final List<SyncedField> syncedFields = new ArrayList<SyncedField>();
    private boolean firstTick = true;
    int playerSlotsStart;
    private static final EntityEquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};

    public ContainerPneumaticBase(Tile te) {
        this.te = te;
        if (te != null) {
            this.addSyncedFields(te);
        }
    }

    protected void addSyncedField(SyncedField field) {
        this.syncedFields.add(field);
        field.setLazy(false);
    }

    protected void addSyncedFields(Object annotatedObject) {
        List<SyncedField> fields = NetworkUtils.getSyncedFields(annotatedObject, GuiSynced.class);
        for (SyncedField field : fields) {
            this.addSyncedField(field);
        }
    }

    public void updateField(int index, Object value) {
        this.syncedFields.get(index).setValue(value);
        if (this.te != null) {
            ((TileEntityBase)this.te).onGuiUpdate();
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return ((TileEntityBase)this.te).isGuiUseableByPlayer(player);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.syncedFields.size(); ++i) {
            if (!this.syncedFields.get(i).update() && !this.firstTick) continue;
            this.sendToContainerListeners(new PacketUpdateGui(i, this.syncedFields.get(i)));
        }
        this.firstTick = false;
    }

    protected void sendToContainerListeners(IMessage message) {
        for (IContainerListener listener : this.field_75149_d) {
            if (!(listener instanceof EntityPlayerMP)) continue;
            NetworkHandler.sendTo(message, (EntityPlayerMP)listener);
        }
    }

    protected void addPlayerSlots(InventoryPlayer inventoryPlayer, int yOffset) {
        this.playerSlotsStart = this.field_75151_b.size();
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, 8 + inventoryColumnIndex * 18, yOffset + inventoryRowIndex * 18));
            }
        }
        for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, actionBarSlotIndex, 8 + actionBarSlotIndex * 18, yOffset + 58));
        }
    }

    protected void addUpgradeSlots(int xBase, int yBase) {
        for (int i = 0; i < ((TileEntityBase)this.te).getUpgradesInventory().getSlots(); ++i) {
            this.func_75146_a((Slot)new SlotUpgrade((TileEntityBase)this.te, i, xBase + i % 2 * 18, yBase + i / 2 * 18));
        }
    }

    protected void addArmorSlots(final InventoryPlayer inventoryPlayer, int xBase, int yBase) {
        for (int i = 0; i < 4; ++i) {
            final EntityEquipmentSlot entityequipmentslot = VALID_EQUIPMENT_SLOTS[i];
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, 36 + (3 - i), xBase, yBase + i * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack stack) {
                    return stack.func_77973_b().isValidArmor(stack, entityequipmentslot, (Entity)inventoryPlayer.field_70458_d);
                }

                public boolean func_82869_a(EntityPlayer playerIn) {
                    ItemStack itemstack = this.func_75211_c();
                    return (itemstack.func_190926_b() || playerIn.func_184812_l_() || !EnchantmentHelper.func_190938_b((ItemStack)itemstack)) && super.func_82869_a(playerIn);
                }

                @Nullable
                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    return ItemArmor.field_94603_a[entityequipmentslot.func_188454_b()];
                }
            });
        }
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slot) {
        Slot srcSlot = (Slot)this.field_75151_b.get(slot);
        if (srcSlot == null || !srcSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack srcStack = srcSlot.func_75211_c().func_77946_l();
        ItemStack copyOfSrcStack = srcStack.func_77946_l();
        if (slot < this.playerSlotsStart ? !this.func_75135_a(srcStack, this.playerSlotsStart, this.playerSlotsStart + 36, false) : !this.func_75135_a(srcStack, 0, this.playerSlotsStart, false)) {
            return ItemStack.field_190927_a;
        }
        srcSlot.func_75215_d(srcStack);
        srcSlot.func_75220_a(srcStack, copyOfSrcStack);
        srcSlot.func_190901_a(player, srcStack);
        return copyOfSrcStack;
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = slotId < 0 ? null : (Slot)this.field_75151_b.get(slotId);
        if (slot instanceof IPhantomSlot) {
            return this.slotClickPhantom(slot, dragType, clickType, player);
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }

    @Nonnull
    private ItemStack slotClickPhantom(Slot slot, int dragType, ClickType clickType, EntityPlayer player) {
        ItemStack stack = ItemStack.field_190927_a;
        if (clickType == ClickType.CLONE && dragType == 2) {
            if (((IPhantomSlot)slot).canAdjust()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
        } else if (!(clickType != ClickType.PICKUP && clickType != ClickType.QUICK_MOVE || dragType != 0 && dragType != 1)) {
            InventoryPlayer playerInv = player.field_71071_by;
            slot.func_75218_e();
            ItemStack stackSlot = slot.func_75211_c();
            ItemStack stackHeld = playerInv.func_70445_o();
            stack = stackSlot.func_77946_l();
            if (stackSlot.func_190926_b()) {
                if (!stackHeld.func_190926_b() && slot.func_75214_a(stackHeld)) {
                    this.fillPhantomSlot(slot, stackHeld, clickType, dragType);
                }
            } else if (stackHeld.func_190926_b()) {
                this.adjustPhantomSlot(slot, clickType, dragType);
                slot.func_190901_a(player, playerInv.func_70445_o());
            } else if (slot.func_75214_a(stackHeld)) {
                if (this.canStacksMerge(stackSlot, stackHeld)) {
                    this.adjustPhantomSlot(slot, clickType, dragType);
                } else {
                    this.fillPhantomSlot(slot, stackHeld, clickType, dragType);
                }
            }
        }
        return stack;
    }

    private boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        return !stack1.func_190926_b() && !stack2.func_190926_b() && stack1.func_77969_a(stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    private void adjustPhantomSlot(Slot slot, ClickType clickType, int dragType) {
        if (!((IPhantomSlot)slot).canAdjust()) {
            return;
        }
        ItemStack stackSlot = slot.func_75211_c().func_77946_l();
        if (dragType == 1) {
            if (clickType == ClickType.QUICK_MOVE) {
                stackSlot.func_190920_e(Math.min(stackSlot.func_190916_E() * 2, slot.func_75219_a()));
            } else {
                stackSlot.func_190920_e(Math.min(stackSlot.func_190916_E() + 1, slot.func_75219_a()));
            }
        } else if (dragType == 0) {
            if (clickType == ClickType.QUICK_MOVE) {
                stackSlot.func_190920_e(stackSlot.func_190916_E() / 2);
            } else {
                stackSlot.func_190918_g(1);
            }
        }
        slot.func_75215_d(stackSlot);
    }

    private void fillPhantomSlot(Slot slot, ItemStack stackHeld, ClickType clickType, int dragType) {
        int stackSize;
        if (!((IPhantomSlot)slot).canAdjust()) {
            return;
        }
        int n = stackSize = dragType == 0 ? stackHeld.func_190916_E() : 1;
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        ItemStack phantomStack = stackHeld.func_77946_l();
        phantomStack.func_190920_e(stackSize);
        slot.func_75215_d(phantomStack);
    }

    @Override
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
        if (this.te != null) {
            ((TileEntityBase)this.te).handleGUIButtonPress(guiID, player);
        }
    }
}

