/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticBase;
import me.desht.pneumaticcraft.common.inventory.SlotPhantom;
import me.desht.pneumaticcraft.common.inventory.SlotPhantomUnstackable;
import me.desht.pneumaticcraft.common.item.ItemLogisticsFrame;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockLogistics;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ContainerLogistics
extends ContainerPneumaticBase {
    public final SemiBlockLogistics logistics;
    private final boolean itemContainer;

    public ContainerLogistics(InventoryPlayer inventoryPlayer, SemiBlockLogistics logistics) {
        super(null);
        boolean bl = this.itemContainer = logistics == null;
        if (this.itemContainer) {
            logistics = ContainerLogistics.getLogistics(inventoryPlayer.field_70458_d, inventoryPlayer.func_70448_g());
        }
        this.logistics = logistics;
        if (logistics != null) {
            this.addSyncedFields(logistics);
            IItemHandlerModifiable requests = logistics.getFilters();
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.func_75146_a((Slot)(logistics.canFilterStack() ? new SlotPhantom((IItemHandler)requests, y * 9 + x, x * 18 + 8, y * 18 + 29) : new SlotPhantomUnstackable((IItemHandler)requests, y * 9 + x, x * 18 + 8, y * 18 + 29)));
                }
            }
            for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
                for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                    this.func_75146_a(new Slot((IInventory)inventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, 8 + inventoryColumnIndex * 18, 134 + inventoryRowIndex * 18));
                }
            }
            for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, actionBarSlotIndex, 8 + actionBarSlotIndex * 18, 192));
            }
        }
    }

    public static SemiBlockLogistics getLogistics(EntityPlayer player, ItemStack itemRequester) {
        if (itemRequester.func_77973_b() instanceof ItemLogisticsFrame) {
            SemiBlockLogistics logistics = (SemiBlockLogistics)SemiBlockManager.getSemiBlockForKey(((ItemLogisticsFrame)itemRequester.func_77973_b()).semiBlockId);
            logistics.initialize(player.field_70170_p, new BlockPos(0, 0, 0));
            logistics.onPlaced(player, itemRequester, null);
            return logistics;
        }
        return null;
    }

    public void func_75134_a(EntityPlayer player) {
        if (this.itemContainer && this.logistics != null) {
            NonNullList drops = NonNullList.func_191196_a();
            this.logistics.addDrops((NonNullList<ItemStack>)drops);
            NBTTagCompound settingTag = ((ItemStack)drops.get(0)).func_77978_p();
            if (player.func_184614_ca().func_77942_o()) {
                NBTTagCompound itemTag = player.func_184614_ca().func_77978_p();
                if (settingTag != null) {
                    itemTag.func_74782_a("filters", (NBTBase)settingTag.func_150295_c("filters", 10));
                    itemTag.func_74782_a("fluidFilters", (NBTBase)settingTag.func_150295_c("fluidFilters", 10));
                    itemTag.func_74757_a("invisible", settingTag.func_74767_n("invisible"));
                } else {
                    itemTag.func_82580_o("filters");
                    itemTag.func_82580_o("fluidFilters");
                    itemTag.func_82580_o("invisible");
                }
            } else {
                player.func_184614_ca().func_77982_d(settingTag);
            }
        }
    }

    @Override
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
        super.handleGUIButtonPress(guiID, player);
        if (this.logistics != null) {
            this.logistics.handleGUIButtonPress(guiID, player);
        }
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return this.logistics != null && !this.logistics.isInvalid();
    }

    @Override
    @Nonnull
    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int slotIndex) {
        Slot srcSlot = (Slot)this.field_75151_b.get(slotIndex);
        if (slotIndex >= 27 && srcSlot != null && srcSlot.func_75216_d()) {
            ItemStack stackInSlot = srcSlot.func_75211_c();
            for (int i = 0; i < 27; ++i) {
                Slot slot = (Slot)this.field_75151_b.get(i);
                if (slot.func_75216_d()) continue;
                slot.func_75215_d(stackInSlot.func_77946_l());
                slot.func_75211_c().func_190920_e(slot.func_75219_a());
                break;
            }
        }
        return ItemStack.field_190927_a;
    }
}

