/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.api.tileentity.IHeatRegistry;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicConstant;
import me.desht.pneumaticcraft.common.heat.SimpleHeatExchanger;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourManager;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class HeatExchangerManager
implements IHeatRegistry {
    public static final double DEFAULT_FLUID_RESISTANCE = 10.0;
    private final Map<Block, IHeatExchanger> specialBlockExchangers = new HashMap<Block, IHeatExchanger>();
    private static final IHeatExchangerLogic AIR_EXCHANGER = new HeatExchangerLogicConstant(295.0, 100.0);
    private static HeatExchangerManager INSTANCE = new HeatExchangerManager();

    public static HeatExchangerManager getInstance() {
        return INSTANCE;
    }

    public void init() {
        this.registerBlockExchanger(Blocks.field_150432_aD, 263.0, 500.0);
        this.registerBlockExchanger(Blocks.field_150403_cj, 263.0, 500.0);
        this.registerBlockExchanger(Blocks.field_150433_aE, 268.0, 1000.0);
        this.registerBlockExchanger(Blocks.field_150478_aa, 1700.0, 100000.0);
        this.registerBlockExchanger((Block)Blocks.field_150480_ab, 1700.0, 1000.0);
        this.registerBlockExchanger(Blocks.field_189877_df, 1700.0, 500.0);
        Map fluids = FluidRegistry.getRegisteredFluids();
        for (Fluid fluid : fluids.values()) {
            if (fluid.getBlock() == null) continue;
            this.registerBlockExchanger(fluid.getBlock(), fluid.getTemperature(), ConfigHandler.general.fluidThermalResistance);
        }
        this.registerBlockExchanger((Block)Blocks.field_150358_i, FluidRegistry.WATER.getTemperature(), 500.0);
        this.registerBlockExchanger((Block)Blocks.field_150356_k, FluidRegistry.LAVA.getTemperature(), 500.0);
    }

    public IHeatExchangerLogic getLogic(World world, BlockPos pos, EnumFacing side) {
        if (!world.func_175667_e(pos)) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IHeatExchanger) {
            return ((IHeatExchanger)te).getHeatExchangerLogic(side);
        }
        if (world.func_175623_d(pos)) {
            return AIR_EXCHANGER;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof IHeatExchanger) {
            return ((IHeatExchanger)block).getHeatExchangerLogic(side);
        }
        IHeatExchanger exchanger = this.specialBlockExchangers.get(block);
        return exchanger == null ? null : exchanger.getHeatExchangerLogic(side);
    }

    public void registerBlockExchanger(Block block, IHeatExchanger heatExchanger) {
        if (block == null) {
            throw new IllegalArgumentException("block is null when trying to register a heat exchanger!");
        }
        if (block instanceof IHeatExchanger) {
            Log.warning("The block " + block.func_149739_a() + " is implementing IHeatExchanger. Therefore you don't need to register it as such");
        }
        if (this.specialBlockExchangers.containsKey(block)) {
            Log.error("The block " + block.func_149739_a() + " was registered as heat exchanger already! It won't be added!");
        } else {
            this.specialBlockExchangers.put(block, heatExchanger);
        }
    }

    public void registerBlockExchanger(Block block, IHeatExchangerLogic heatExchangerLogic) {
        this.registerBlockExchanger(block, new SimpleHeatExchanger(heatExchangerLogic));
    }

    @Override
    public void registerBlockExchanger(Block block, double temperature, double thermalResistance) {
        this.registerBlockExchanger(block, new HeatExchangerLogicConstant(temperature, thermalResistance));
    }

    @Override
    public void registerHeatBehaviour(Class<? extends HeatBehaviour> heatBehaviour) {
        HeatBehaviourManager.getInstance().registerBehaviour(heatBehaviour);
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic() {
        return new HeatExchangerLogic();
    }

    public static class TemperatureData {
        private final Double[] temp = new Double[7];
        private boolean isMultisided = true;

        public TemperatureData(IHeatExchanger heatExchanger) {
            Arrays.fill((Object[])this.temp, null);
            HashSet<IHeatExchangerLogic> heatExchangers = new HashSet<IHeatExchangerLogic>();
            IHeatExchangerLogic logic = null;
            for (EnumFacing face : EnumFacing.field_82609_l) {
                logic = heatExchanger.getHeatExchangerLogic(face);
                if (logic == null) continue;
                if (heatExchangers.contains(logic)) {
                    this.isMultisided = false;
                    break;
                }
                heatExchangers.add(logic);
            }
            if (this.isMultisided) {
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    logic = heatExchanger.getHeatExchangerLogic(face);
                    if (logic == null) continue;
                    this.temp[face.ordinal()] = logic.getTemperature();
                }
            } else if (logic != null) {
                this.temp[6] = logic.getTemperature();
            }
        }

        public boolean isMultisided() {
            return this.isMultisided;
        }

        public double getTemperature(EnumFacing face) {
            return face == null ? this.temp[6] : this.temp[face.ordinal()];
        }

        public boolean hasData(EnumFacing face) {
            return face == null ? this.temp[6] != null : this.temp[face.ordinal()] != null;
        }
    }
}

