/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.harvesting;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.api.harvesting.IHarvestHandler;
import me.desht.pneumaticcraft.api.harvesting.IHarvestRegistry;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCactusLike;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCropLike;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCrops;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerLeaves;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerTree;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class HarvestRegistry
implements IHarvestRegistry {
    private static final HarvestRegistry INSTANCE = new HarvestRegistry();
    private List<IHarvestHandler> harvestHandlers = new ArrayList<IHarvestHandler>();
    private List<Pair<Predicate<ItemStack>, BiConsumer<ItemStack, EntityPlayer>>> hoeHandlers = new ArrayList<Pair<Predicate<ItemStack>, BiConsumer<ItemStack, EntityPlayer>>>();

    public static HarvestRegistry getInstance() {
        return INSTANCE;
    }

    public void init() {
        ItemStack cocoaBean = new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BROWN.func_176767_b());
        this.registerHarvestHandler(new HarvestHandlerCrops());
        this.registerHarvestHandlerCroplike(state -> state.func_177230_c() == Blocks.field_150388_bm, BlockNetherWart.field_176486_a, stack -> stack.func_77973_b() == Items.field_151075_bm);
        this.registerHarvestHandlerCroplike(state -> state.func_177230_c() == Blocks.field_150375_by, BlockCocoa.field_176501_a, stack -> stack.func_77969_a(cocoaBean));
        this.registerHarvestHandlerCactuslike(state -> state.func_177230_c() == Blocks.field_150434_aF);
        this.registerHarvestHandlerCactuslike(state -> state.func_177230_c() == Blocks.field_150436_aH);
        this.registerHarvestHandler((w, c, p, state, drone) -> state.func_177230_c() == Blocks.field_150423_aK || state.func_177230_c() == Blocks.field_150440_ba);
        this.registerHarvestHandler(new HarvestHandlerLeaves());
        for (BlockPlanks.EnumType treeType : BlockPlanks.EnumType.values()) {
            Predicate<IBlockState> isOldLog = state -> state.func_177230_c() == Blocks.field_150364_r && state.func_177229_b((IProperty)BlockOldLog.field_176301_b) == treeType;
            Predicate<IBlockState> isNewLog = state -> state.func_177230_c() == Blocks.field_150363_s && state.func_177229_b((IProperty)BlockNewLog.field_176300_b) == treeType;
            Predicate<IBlockState> blockChecker = isOldLog.or(isNewLog);
            Predicate<ItemStack> isSapling = item -> item.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150345_g) && item.func_77960_j() == treeType.func_176839_a();
            IBlockState saplingState = Blocks.field_150345_g.func_176203_a(treeType.func_176839_a());
            this.registerHarvestHandlerTreelike(blockChecker, isSapling, saplingState);
        }
        this.registerHoe(item -> item.func_77973_b() instanceof ItemHoe, (stack, player) -> stack.func_77972_a(1, (EntityLivingBase)player));
    }

    public List<IHarvestHandler> getHarvestHandlers() {
        return this.harvestHandlers;
    }

    public BiConsumer<ItemStack, EntityPlayer> getDamageableHoe(ItemStack stack) {
        return this.hoeHandlers.stream().filter(handler -> ((Predicate)handler.getLeft()).test(stack)).map(handler -> (BiConsumer)handler.getRight()).findFirst().orElse(null);
    }

    @Override
    public void registerHarvestHandler(IHarvestHandler harvestHandler) {
        Validate.notNull((Object)harvestHandler);
        this.harvestHandlers.add(harvestHandler);
    }

    @Override
    public void registerHarvestHandlerCactuslike(Predicate<IBlockState> blockChecker) {
        Validate.notNull(blockChecker);
        this.registerHarvestHandler(new HarvestHandlerCactusLike(blockChecker));
    }

    @Override
    public void registerHarvestHandlerCroplike(Predicate<IBlockState> blockChecker, PropertyInteger ageProperty, Predicate<ItemStack> isSeed) {
        Validate.notNull(blockChecker);
        Validate.notNull((Object)ageProperty);
        Validate.notNull(isSeed);
        this.registerHarvestHandler(new HarvestHandlerCropLike(blockChecker, ageProperty, isSeed));
    }

    @Override
    public void registerHarvestHandlerTreelike(Predicate<IBlockState> blockChecker, Predicate<ItemStack> isSapling, IBlockState saplingState) {
        Validate.notNull(blockChecker);
        Validate.notNull(isSapling);
        Validate.notNull((Object)saplingState);
        this.registerHarvestHandler(new HarvestHandlerTree(blockChecker, isSapling, saplingState));
    }

    @Override
    public void registerHoe(Predicate<ItemStack> isHoeWithDurability, BiConsumer<ItemStack, EntityPlayer> useDurability) {
        Validate.notNull(isHoeWithDurability);
        Validate.notNull(useDurability);
        this.hoeHandlers.add((Pair<Predicate<ItemStack>, BiConsumer<ItemStack, EntityPlayer>>)new ImmutablePair(isHoeWithDurability, useDurability));
    }
}

