/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.api.tileentity.IPneumaticMachine;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.NBTUtil;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.thirdparty.ModInteractionUtils;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.ITOPInfoProvider;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.TOPCallback;
import me.desht.pneumaticcraft.common.thirdparty.waila.IInfoForwarder;
import me.desht.pneumaticcraft.common.tileentity.IComparatorSupport;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheralProvider", modid="computercraft")
public abstract class BlockPneumaticCraft
extends Block
implements IPneumaticWrenchable,
IUpgradeAcceptor,
IPeripheralProvider,
ITOPInfoProvider {
    public static final PropertyEnum<EnumFacing> ROTATION = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool[] CONNECTION_PROPERTIES = new PropertyBool[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    private static final String NBT_UPGRADE_INVENTORY = "UpgradeInventory";
    private AxisAlignedBB bounds = field_185505_j;

    protected BlockPneumaticCraft(Material material, String registryName) {
        super(material);
        this.func_149663_c(registryName);
        this.setRegistryName(registryName);
        this.func_149647_a(PneumaticCraftRepressurized.tabPneumaticCraft);
        this.func_149711_c(3.0f);
        this.func_149752_b(10.0f);
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.getTileEntityClass() != null;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        try {
            TileEntity te = this.getTileEntityClass().newInstance();
            te.func_145834_a(world);
            if (te instanceof TileEntityBase) {
                ((TileEntityBase)te).onTileEntityCreated();
            }
            return te;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract Class<? extends TileEntity> getTileEntityClass();

    public GuiHandler.EnumGuiId getGuiID() {
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te;
        ItemStack heldItem = player.func_184586_b(hand);
        if (player.func_70093_af() || this.getGuiID() == null || this.isRotatable() && (heldItem.func_77973_b() == Itemss.MANOMETER || ModInteractionUtils.getInstance().isModdedWrench(heldItem)) || hand == EnumHand.OFF_HAND && ModInteractionUtils.getInstance().isModdedWrench(player.func_184614_ca())) {
            return false;
        }
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) != null) {
            if (FluidUtils.tryFluidInsertion(te, null, player, hand)) {
                return true;
            }
            if (FluidUtils.tryFluidExtraction(te, null, player, hand)) {
                return true;
            }
            player.openGui((Object)PneumaticCraftRepressurized.instance, this.getGuiID().ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        TileEntity te;
        if (this.isRotatable()) {
            EnumFacing rotation = PneumaticCraftUtils.getDirectionFacing(entity, this.canRotateToTopOrBottom());
            this.setRotation(world, pos, rotation, state);
        }
        if ((te = world.func_175625_s(pos)) instanceof ISerializableTanks && stack.func_77942_o() && stack.func_77978_p().func_150297_b("SavedTanks", 10)) {
            ((ISerializableTanks)te).deserializeTanks(stack.func_77978_p().func_74775_l("SavedTanks"));
        }
        if (te instanceof TileEntityBase && stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_UPGRADE_INVENTORY)) {
            ((TileEntityBase)te).getUpgradesInventory().deserializeNBT(stack.func_77978_p().func_74775_l(NBT_UPGRADE_INVENTORY));
        }
    }

    protected void setRotation(World world, BlockPos pos, EnumFacing rotation) {
        this.setRotation(world, pos, rotation, world.func_180495_p(pos));
    }

    protected EnumFacing getRotation(IBlockAccess world, BlockPos pos) {
        return this.getRotation(world.func_180495_p(pos));
    }

    protected EnumFacing getRotation(IBlockState state) {
        return (EnumFacing)state.func_177229_b(ROTATION);
    }

    private void setRotation(World world, BlockPos pos, EnumFacing rotation, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a(ROTATION, (Comparable)rotation));
    }

    public boolean isRotatable() {
        return false;
    }

    protected boolean canRotateToTopOrBottom() {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        if (this.isRotatable()) {
            return new BlockStateContainer((Block)this, new IProperty[]{ROTATION});
        }
        return super.func_180661_e();
    }

    public int func_176201_c(IBlockState state) {
        if (this.isRotatable()) {
            return ((EnumFacing)state.func_177229_b(ROTATION)).ordinal();
        }
        return super.func_176201_c(state);
    }

    public IBlockState func_176203_a(int meta) {
        if (this.isRotatable()) {
            return super.func_176203_a(meta).func_177226_a(ROTATION, (Comparable)EnumFacing.func_82600_a((int)meta));
        }
        return super.func_176203_a(meta);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    @Override
    public boolean rotateBlock(World world, EntityPlayer player, BlockPos pos, EnumFacing side) {
        if (player != null && player.func_70093_af()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityBase) {
                ((TileEntityBase)te).preserveUpgradesOnBreak = true;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            }
            world.func_175698_g(pos);
            return true;
        }
        if (this.isRotatable()) {
            IBlockState state = world.func_180495_p(pos);
            if (!this.rotateCustom(world, pos, state, side)) {
                TileEntity te;
                if (this.rotateForgeWay()) {
                    if (!this.canRotateToTopOrBottom()) {
                        side = EnumFacing.UP;
                    }
                    if (this.getRotation((IBlockAccess)world, pos).func_176740_k() != side.func_176740_k()) {
                        this.setRotation(world, pos, this.getRotation((IBlockAccess)world, pos).func_176732_a(side.func_176740_k()));
                    }
                } else {
                    EnumFacing f = this.getRotation((IBlockAccess)world, pos);
                    do {
                        f = EnumFacing.func_82600_a((int)(f.ordinal() + 1));
                    } while (!this.canRotateToTopOrBottom() && f.func_176740_k() == EnumFacing.Axis.Y);
                    this.setRotation(world, pos, f);
                }
                if ((te = world.func_175625_s(pos)) instanceof TileEntityBase) {
                    ((TileEntityBase)te).onBlockRotated();
                }
            }
            return true;
        }
        return false;
    }

    protected boolean rotateForgeWay() {
        return true;
    }

    protected boolean rotateCustom(World world, BlockPos pos, IBlockState state, EnumFacing side) {
        return false;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos tilePos) {
        TileEntity te;
        if (world instanceof World && !((World)world).field_72995_K && (te = world.func_175625_s(pos)) instanceof TileEntityBase) {
            ((TileEntityBase)te).onNeighborTileUpdate();
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TileEntityBase) {
            ((TileEntityBase)te).onNeighborBlockUpdate();
        }
    }

    @Optional.Method(modid="computercraft")
    public IPeripheral getPeripheral(World world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof IPeripheral ? (IPeripheral)te : null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World world, List<String> curInfo, ITooltipFlag flag) {
        String info;
        String translatedInfo;
        TileEntity te;
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("SavedTanks", 10)) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("SavedTanks");
            for (String s : tag.func_150296_c()) {
                NBTTagCompound tankTag = tag.func_74775_l(s);
                FluidTank tank = new FluidTank(tankTag.func_74762_e("Amount"));
                tank.readFromNBT(tankTag);
                FluidStack fluidStack = tank.getFluid();
                if (fluidStack == null || fluidStack.amount <= 0) continue;
                curInfo.add(fluidStack.getFluid().getLocalizedName(fluidStack) + ": " + fluidStack.amount + "mB");
            }
        }
        if (PneumaticCraftRepressurized.proxy.isSneakingInGui() && (te = this.createTileEntity(world, this.func_176223_P())) instanceof TileEntityPneumaticBase) {
            float pressure = ((TileEntityPneumaticBase)te).dangerPressure;
            curInfo.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.tooltip.maxPressure", (Object[])new Object[]{Float.valueOf(pressure)}));
        }
        if (!(translatedInfo = I18n.func_135052_a((String)(info = "gui.tab.info." + stack.func_77977_a()), (Object[])new Object[0])).equals(info)) {
            if (PneumaticCraftRepressurized.proxy.isSneakingInGui()) {
                translatedInfo = TextFormatting.AQUA + translatedInfo.substring(2);
                if (!Loader.isModLoaded((String)"igwmod")) {
                    translatedInfo = translatedInfo + " \\n \\n" + I18n.func_135052_a((String)"gui.tab.info.assistIGW", (Object[])new Object[0]);
                }
                curInfo.addAll(PneumaticCraftUtils.convertStringIntoList(translatedInfo, 40));
            } else {
                curInfo.add(TextFormatting.AQUA + I18n.func_135052_a((String)"gui.tooltip.sneakForInfo", (Object[])new Object[0]));
            }
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return IComparatorSupport.class.isAssignableFrom(this.getTileEntityClass());
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return ((IComparatorSupport)world.func_175625_s(pos)).getComparatorValue();
    }

    @Override
    public Set<Item> getApplicableUpgrades() {
        TileEntity te = this.createTileEntity(null, this.func_176223_P());
        return te instanceof IUpgradeAcceptor ? ((IUpgradeAcceptor)te).getApplicableUpgrades() : Collections.emptySet();
    }

    @Override
    public String getName() {
        return this.func_149739_a() + ".name";
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.bounds;
    }

    protected void setBlockBounds(AxisAlignedBB bounds) {
        this.bounds = bounds;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (player.func_184812_l_()) {
            TileEntity te;
            if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TileEntityBase) {
                NonNullList drops = NonNullList.func_191196_a();
                ((TileEntityBase)te).getContentsToDrop((NonNullList<ItemStack>)drops);
                drops.forEach(stack -> PneumaticCraftUtils.dropItemOnGround(stack, world, pos));
            }
            return super.removedByPlayer(state, world, pos, player, false);
        }
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityBase) {
            NonNullList drops = NonNullList.func_191196_a();
            ((TileEntityBase)te).getContentsToDrop((NonNullList<ItemStack>)drops);
            drops.forEach(stack -> PneumaticCraftUtils.dropItemOnGround(stack, worldIn, pos));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity te = world.func_175625_s(pos);
        ItemStack customDrop = ItemStack.field_190927_a;
        if (te instanceof ISerializableTanks) {
            customDrop = ((ISerializableTanks)te).getDroppedStack(this);
        }
        if (te instanceof TileEntityBase && ((TileEntityBase)te).preserveUpgradesOnBreak) {
            if (customDrop.func_190926_b()) {
                customDrop = new ItemStack(Item.func_150898_a((Block)this));
                NBTUtil.initNBTTagCompound(customDrop);
            }
            customDrop.func_77978_p().func_74782_a(NBT_UPGRADE_INVENTORY, (NBTBase)((TileEntityBase)te).getUpgradesInventory().serializeNBT());
        }
        if (customDrop.func_190926_b()) {
            super.getDrops(drops, world, pos, state, fortune);
        } else {
            drops.add((Object)customDrop);
        }
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof IInfoForwarder) {
            te = ((IInfoForwarder)te).getInfoTileEntity();
        }
        if (te instanceof IPneumaticMachine) {
            TOPCallback.handlePneumatic(mode, probeInfo, (IPneumaticMachine)te);
        }
        if (te instanceof IHeatExchanger) {
            TOPCallback.handleHeat(mode, probeInfo, (IHeatExchanger)te);
        }
        if (ConfigHandler.client.topShowsFluids && te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, data.getSideHit())) {
            IFluidHandler handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, data.getSideHit());
            TOPCallback.handleFluidTanks(mode, probeInfo, handler);
        }
        if (te instanceof TileEntityBase) {
            TOPCallback.handleRedstoneMode(mode, probeInfo, (TileEntityBase)te);
        }
        if (te instanceof TileEntityPressureTube) {
            TOPCallback.handlePressureTube(mode, probeInfo, (TileEntityPressureTube)te, data.getSideHit());
        }
    }
}

