/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftModeled;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorFrame;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockElevatorFrame
extends BlockPneumaticCraftModeled {
    public static final PropertyBool NE = PropertyBool.func_177716_a((String)"ne");
    public static final PropertyBool SE = PropertyBool.func_177716_a((String)"se");
    public static final PropertyBool SW = PropertyBool.func_177716_a((String)"sw");
    public static final PropertyBool NW = PropertyBool.func_177716_a((String)"nw");

    public BlockElevatorFrame() {
        super(Material.field_151573_f, "elevator_frame");
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        TileEntityElevatorBase elevatorBase = BlockElevatorFrame.getElevatorTE((IBlockAccess)world, pos);
        if (elevatorBase != null) {
            elevatorBase.updateMaxElevatorHeight();
        }
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NE, SW, SE, NW});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean[] connected = this.getConnections(worldIn, pos);
        for (Corner corner : Corner.values()) {
            state = state.func_177226_a((IProperty)corner.prop, (Comparable)Boolean.valueOf(connected[corner.ordinal()]));
        }
        return state;
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityElevatorFrame.class;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return super.func_185496_a(state, source, pos);
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d origin, Vec3d direction) {
        ItemStack playerStack;
        if (world.field_72995_K && (playerStack = PneumaticCraftRepressurized.proxy.getClientPlayer().func_184614_ca()).func_77973_b() == Item.func_150898_a((Block)this)) {
            return super.func_180636_a(state, world, pos, origin, direction);
        }
        boolean isColliding = false;
        boolean[] connected = this.getConnections((IBlockAccess)world, pos);
        for (Corner corner : Corner.values()) {
            if (connected[corner.ordinal()]) continue;
            this.setBlockBounds(corner.aabb);
            if (super.func_180636_a(state, world, pos, origin, direction) == null) continue;
            isColliding = true;
        }
        this.setBlockBounds(field_185505_j);
        return isColliding ? super.func_180636_a(state, world, pos, origin, direction) : null;
    }

    private boolean[] getConnections(IBlockAccess world, BlockPos pos) {
        boolean[] res = new boolean[4];
        boolean frameXPos = world.func_180495_p(pos.func_177974_f()).func_177230_c() == Blockss.ELEVATOR_FRAME;
        boolean frameXNeg = world.func_180495_p(pos.func_177976_e()).func_177230_c() == Blockss.ELEVATOR_FRAME;
        boolean frameZPos = world.func_180495_p(pos.func_177968_d()).func_177230_c() == Blockss.ELEVATOR_FRAME;
        boolean frameZNeg = world.func_180495_p(pos.func_177978_c()).func_177230_c() == Blockss.ELEVATOR_FRAME;
        res[Corner.SE.ordinal()] = frameXPos || frameZPos;
        res[Corner.NE.ordinal()] = frameXPos || frameZNeg;
        res[Corner.SW.ordinal()] = frameXNeg || frameZPos;
        res[Corner.NW.ordinal()] = frameXNeg || frameZNeg;
        return res;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        boolean[] connected = this.getConnections((IBlockAccess)worldIn, pos);
        for (Corner corner : Corner.values()) {
            if (connected[corner.ordinal()]) continue;
            BlockElevatorFrame.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)corner.aabb);
        }
        float blockHeight = this.getElevatorBlockHeight((IBlockAccess)worldIn, pos);
        if (blockHeight > 0.0f) {
            AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)blockHeight, 1.0);
            BlockElevatorFrame.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)aabb);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntityElevatorBase te = BlockElevatorFrame.getElevatorTE((IBlockAccess)world, pos);
        if (te != null && te.oldExtension != te.extension) {
            entity.func_70107_b(entity.field_70165_t, (double)((float)(te.func_174877_v().func_177956_o() + 1) + te.extension), entity.field_70161_v);
        }
        entity.field_70143_R = 0.0f;
    }

    static TileEntityElevatorBase getElevatorTE(IBlockAccess world, BlockPos pos) {
        while (world.func_180495_p(pos = pos.func_177972_a(EnumFacing.DOWN)).func_177230_c() != Blockss.ELEVATOR_BASE) {
            if (world.func_180495_p(pos).func_177230_c() == Blockss.ELEVATOR_FRAME && pos.func_177956_o() > 0) continue;
            return null;
        }
        return (TileEntityElevatorBase)world.func_175625_s(pos);
    }

    private float getElevatorBlockHeight(IBlockAccess world, BlockPos pos) {
        TileEntityElevatorBase te = BlockElevatorFrame.getElevatorTE(world, pos);
        if (te == null) {
            return 0.0f;
        }
        float blockHeight = te.extension - (float)(pos.func_177956_o() - te.func_174877_v().func_177956_o()) + 1.0f;
        if (blockHeight < 0.0f) {
            return 0.0f;
        }
        if (blockHeight > 1.0f) {
            return 1.0f;
        }
        return blockHeight;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityElevatorBase elevatorBase = BlockElevatorFrame.getElevatorTE((IBlockAccess)world, pos);
        if (elevatorBase != null) {
            elevatorBase.updateMaxElevatorHeight();
        }
        super.func_180663_b(world, pos, state);
    }

    private static enum Corner {
        NE(1, -1, NE, new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 0.125)),
        SE(1, 1, SE, new AxisAlignedBB(0.875, 0.0, 0.875, 1.0, 1.0, 1.0)),
        SW(-1, 1, SW, new AxisAlignedBB(0.0, 0.0, 0.875, 0.125, 1.0, 1.0)),
        NW(-1, -1, NW, new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 0.125));

        final int x;
        final int z;
        final PropertyBool prop;
        final AxisAlignedBB aabb;

        private Corner(int x, int z, PropertyBool prop, AxisAlignedBB aabb) {
            this.x = x;
            this.z = z;
            this.prop = prop;
            this.aabb = aabb;
        }
    }
}

