/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.IToolUser;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class DroneAIDig
extends DroneAIBlockInteraction<ProgWidgetAreaItemBase> {
    public DroneAIDig(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        IBlockState blockState = this.worldCache.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (!this.worldCache.func_175623_d(pos) && !DroneAIDig.ignoreBlock(block)) {
            NonNullList droppedStacks = NonNullList.func_191196_a();
            if (block.canSilkHarvest(this.drone.world(), pos, blockState, (EntityPlayer)this.drone.getFakePlayer())) {
                droppedStacks.add((Object)DroneAIDig.getSilkTouchBlock(block, blockState));
            } else {
                block.getDrops(droppedStacks, (IBlockAccess)this.drone.world(), pos, blockState, 0);
            }
            for (ItemStack droppedStack : droppedStacks) {
                if (!this.widget.isItemValidForFilters(droppedStack, blockState)) continue;
                return this.swapBestItemToFirstSlot(pos) || !((IToolUser)((Object)this.widget)).requiresTool();
            }
        }
        return false;
    }

    @Override
    protected boolean respectClaims() {
        return true;
    }

    private boolean swapBestItemToFirstSlot(BlockPos pos) {
        ItemStack oldCurrentStack = this.drone.getInv().getStackInSlot(0).func_77946_l();
        this.drone.getInv().setStackInSlot(0, ItemStack.field_190927_a);
        float baseSoftness = this.worldCache.func_180495_p(pos).func_185903_a((EntityPlayer)this.drone.getFakePlayer(), this.drone.world(), pos);
        this.drone.getInv().setStackInSlot(0, oldCurrentStack);
        boolean hasDiggingTool = false;
        int bestSlot = 0;
        float bestSoftness = Float.MIN_VALUE;
        for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
            this.drone.getInv().setStackInSlot(0, this.drone.getInv().getStackInSlot(i));
            float softness = this.worldCache.func_180495_p(pos).func_185903_a((EntityPlayer)this.drone.getFakePlayer(), this.drone.world(), pos);
            if (!(softness > bestSoftness)) continue;
            bestSlot = i;
            bestSoftness = softness;
            if (!(softness > baseSoftness)) continue;
            hasDiggingTool = true;
        }
        this.drone.getInv().setStackInSlot(0, oldCurrentStack);
        if (bestSlot != 0) {
            ItemStack bestItem = this.drone.getInv().getStackInSlot(bestSlot).func_77946_l();
            this.drone.getInv().setStackInSlot(bestSlot, this.drone.getInv().getStackInSlot(0));
            this.drone.getInv().setStackInSlot(0, bestItem);
        }
        return hasDiggingTool;
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        PlayerInteractionManager manager = this.drone.getFakePlayer().field_71134_c;
        if (!manager.field_73088_d || !manager.field_73097_j) {
            IBlockState blockState = this.worldCache.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (!DroneAIDig.ignoreBlock(block) && DroneAIDig.isBlockValidForFilter(this.worldCache, this.drone, pos, this.widget)) {
                if (blockState.func_185887_b(this.drone.world(), pos) < 0.0f) {
                    this.addToBlacklist(pos);
                    this.drone.addDebugEntry("gui.progWidget.dig.debug.cantDigBlock", pos);
                    this.drone.setDugBlock(null);
                    return false;
                }
                manager.func_180784_a(pos, EnumFacing.DOWN);
                manager.func_180785_a(pos);
                this.drone.setDugBlock(pos);
                return true;
            }
            this.drone.setDugBlock(null);
            return false;
        }
        return true;
    }

    public static boolean isBlockValidForFilter(IBlockAccess worldCache, IDroneBase drone, BlockPos pos, ProgWidgetAreaItemBase widget) {
        IBlockState blockState = worldCache.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (!block.isAir(blockState, worldCache, pos)) {
            NonNullList droppedStacks = NonNullList.func_191196_a();
            if (block.canSilkHarvest(drone.world(), pos, blockState, (EntityPlayer)drone.getFakePlayer())) {
                droppedStacks.add((Object)DroneAIDig.getSilkTouchBlock(block, blockState));
            } else {
                block.getDrops(droppedStacks, (IBlockAccess)drone.world(), pos, blockState, 0);
            }
            for (ItemStack droppedStack : droppedStacks) {
                if (!widget.isItemValidForFilters(droppedStack, blockState)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    private static ItemStack getSilkTouchBlock(Block block, IBlockState state) {
        Item item = Item.func_150898_a((Block)block);
        if (item == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(item, 1, block.func_176201_c(state));
    }

    private static boolean ignoreBlock(Block block) {
        return PneumaticCraftUtils.isBlockLiquid(block);
    }
}

