/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import me.desht.pneumaticcraft.common.ai.DroneClaimManager;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.config.AmadronOfferPeriodicConfig;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketServerTickTime;
import me.desht.pneumaticcraft.common.recipes.AmadronOfferManager;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElectrostaticCompressor;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TickHandlerPneumaticCraft {
    @SubscribeEvent
    public void onWorldTickEnd(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.world.field_72995_K) {
            World world = event.world;
            this.checkLightning(world);
            DroneClaimManager.getInstance(world).update();
            if (event.world.func_82737_E() % 100L == 0L) {
                double tickTime = MathHelper.func_76127_a((long[])FMLCommonHandler.instance().getMinecraftServerInstance().field_71311_j) * 1.0E-6;
                NetworkHandler.sendToDimension(new PacketServerTickTime(tickTime), event.world.field_73011_w.getDimension());
            }
        }
    }

    @SubscribeEvent
    public void onServerTickEnd(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            int ticks = FMLCommonHandler.instance().getMinecraftServerInstance().func_71259_af();
            if (ticks % (24000 / AmadronOfferPeriodicConfig.timesPerDay) == 1) {
                AmadronOfferManager.getInstance().shufflePeriodicOffers();
            }
            if (ticks % 600 == 0) {
                AmadronOfferManager.getInstance().tryRestockCustomOffers();
            }
        }
    }

    private void checkLightning(World world) {
        if (world.field_72995_K) {
            return;
        }
        for (int i = 0; i < world.field_73007_j.size(); ++i) {
            Entity entity = (Entity)world.field_73007_j.get(i);
            if (entity.field_70173_aa != 1 || !(entity instanceof EntityLightningBolt)) continue;
            this.handleElectrostaticGeneration(world, entity);
        }
    }

    private void handleElectrostaticGeneration(World world, Entity entity) {
        HashSet<BlockPos> posSet = new HashSet<BlockPos>();
        TickHandlerPneumaticCraft.getElectrostaticGrid(posSet, world, new BlockPos((double)Math.round(entity.field_70165_t), (double)Math.round(entity.field_70163_u), (double)Math.round(entity.field_70161_v)));
        ArrayList<TileEntityElectrostaticCompressor> compressors = new ArrayList<TileEntityElectrostaticCompressor>();
        for (BlockPos pos : posSet) {
            TileEntity te;
            if (world.func_180495_p(pos).func_177230_c() != Blockss.ELECTROSTATIC_COMPRESSOR || !((te = world.func_175625_s(pos)) instanceof TileEntityElectrostaticCompressor)) continue;
            compressors.add((TileEntityElectrostaticCompressor)te);
        }
        for (TileEntityElectrostaticCompressor compressor : compressors) {
            compressor.addAir(200000 / compressors.size());
            compressor.onStruckByLightning();
        }
    }

    public static void getElectrostaticGrid(Set<BlockPos> set, World world, BlockPos pos) {
        for (EnumFacing d : EnumFacing.field_82609_l) {
            BlockPos newPos = pos.func_177972_a(d);
            Block block = world.func_180495_p(newPos).func_177230_c();
            if (block != Blocks.field_150411_aY && block != Blockss.ELECTROSTATIC_COMPRESSOR || !set.add(newPos)) continue;
            TickHandlerPneumaticCraft.getElectrostaticGrid(set, world, newPos);
        }
    }
}

