/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumaticArmor;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IHackableBlock;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.render.RenderProgressBar;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.BlockTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.RenderBlockArrows;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.blockTracker.BlockTrackEntryList;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.hacking.HackableHandler;
import me.desht.pneumaticcraft.common.CommonHUDHandler;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketDescriptionPacketRequest;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockStart;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.client.FMLClientHandler;

public class RenderBlockTarget {
    private final World world;
    private final BlockPos pos;
    private final RenderBlockArrows arrowRenderer = new RenderBlockArrows();
    public int ticksExisted = 0;
    public final GuiAnimatedStat stat;
    private final EntityPlayer player;
    private boolean playerIsLooking;
    public List<String> textList = new ArrayList<String>();
    private int hackTime;
    private final BlockTrackUpgradeHandler blockTracker;
    private TileEntity te;

    public RenderBlockTarget(World world, EntityPlayer player, BlockPos pos, TileEntity te, BlockTrackUpgradeHandler blockTracker) {
        this.world = world;
        this.player = player;
        this.pos = pos;
        this.te = te;
        this.blockTracker = blockTracker;
        String title = world.func_180495_p(pos).func_177230_c().func_149732_F();
        if (title.contains(".name")) {
            try {
                IBlockState state = world.func_180495_p(pos);
                ItemStack stack = state.func_177230_c().getPickBlock(state, FMLClientHandler.instance().getClient().field_71476_x, world, pos, (EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
                if (!stack.func_190926_b()) {
                    title = stack.func_82833_r();
                }
            }
            catch (Throwable state) {
                // empty catch block
            }
        }
        if (title.contains(".name")) {
            ITextComponent text = te.func_145748_c_();
            title = text == null ? "???" : te.func_145748_c_().func_150254_d();
        }
        this.stat = new GuiAnimatedStat(null, title, "", 20, -20, 0x3000AA00, null, false);
        this.stat.setMinDimensionsAndReset(0, 0);
    }

    public void setTileEntity(TileEntity te) {
        this.te = te;
    }

    public boolean isTargetStillValid() {
        return this.getApplicableEntries().size() > 0;
    }

    public List<IBlockTrackEntry> getApplicableEntries() {
        return BlockTrackEntryList.instance.getEntriesForCoordinate((IBlockAccess)this.world, this.pos, this.te);
    }

    public boolean isSameTarget(World world, BlockPos pos) {
        return this.pos.equals((Object)pos);
    }

    public Block getBlock() {
        return this.world.func_180495_p(this.pos).func_177230_c();
    }

    public double getDistanceToEntity(Entity entity) {
        return entity.func_70011_f((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5);
    }

    public void update() {
        if (this.te != null && this.te.func_145837_r()) {
            this.te = null;
        }
        this.stat.update();
        List<IBlockTrackEntry> applicableTrackEntries = this.getApplicableEntries();
        if (CommonHUDHandler.getHandlerForPlayer().getTicksSinceEquipped(EntityEquipmentSlot.HEAD) % 100 == 0) {
            boolean sentUpdate = false;
            for (IBlockTrackEntry entry : applicableTrackEntries) {
                if (!entry.shouldBeUpdatedFromServer(this.te) || sentUpdate) continue;
                NetworkHandler.sendToServer(new PacketDescriptionPacketRequest(this.pos));
                sentUpdate = true;
            }
        }
        this.playerIsLooking = this.isPlayerLookingAtTarget();
        ++this.arrowRenderer.ticksExisted;
        if (!this.getBlock().isAir(this.world.func_180495_p(this.pos), (IBlockAccess)this.world, this.pos)) {
            this.textList = new ArrayList<String>();
            if (this.ticksExisted > 120) {
                this.stat.closeWindow();
                for (IBlockTrackEntry entry : applicableTrackEntries) {
                    if (this.blockTracker.countBlockTrackersOfType(entry) > entry.spamThreshold()) continue;
                    this.stat.openWindow();
                    break;
                }
                if (this.playerIsLooking) {
                    this.stat.openWindow();
                    this.addBlockTrackInfo(this.textList);
                }
                this.stat.setText(this.textList);
            } else if (this.ticksExisted < -30) {
                this.stat.closeWindow();
                this.stat.setText(this.textList);
            }
        }
        if (this.hackTime > 0) {
            IHackableBlock hackableBlock = HackableHandler.getHackableForCoord((IBlockAccess)this.world, this.pos, this.player);
            this.hackTime = hackableBlock != null ? ++this.hackTime : 0;
        }
    }

    public void render(float partialTicks) {
        double x = (double)this.pos.func_177958_n() + 0.5;
        double y = (double)this.pos.func_177956_o() + 0.5;
        double z = (double)this.pos.func_177952_p() + 0.5;
        GlStateManager.func_179090_x();
        GlStateManager.func_179094_E();
        GlStateManager.func_179086_m((int)256);
        float red = 0.5f;
        float green = 0.5f;
        float blue = 1.0f;
        float alpha = 0.5f;
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        IBlockState state = this.world.func_180495_p(this.pos);
        if (!this.getBlock().isAir(state, (IBlockAccess)this.world, this.pos)) {
            this.arrowRenderer.render(this.world, this.pos, partialTicks);
        }
        int targetAcquireProgress = (int)((float)(this.ticksExisted - 50) / 0.7f);
        GlStateManager.func_179114_b((float)(180.0f - Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(180.0f - Minecraft.func_71410_x().func_175598_ae().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        if (this.ticksExisted <= 120 && this.ticksExisted > 50) {
            GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)0.0f, (float)0.8f);
            RenderProgressBar.render(0.0, 0.4, 1.8, 0.9, 0.0, targetAcquireProgress);
        }
        GlStateManager.func_179098_w();
        if (!this.getBlock().isAir(state, (IBlockAccess)this.world, this.pos)) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
            if (this.ticksExisted > 120) {
                GlStateManager.func_179139_a((double)0.02, (double)0.02, (double)0.02);
                this.stat.render(-1, -1, partialTicks);
            } else if (this.ticksExisted > 50) {
                GlStateManager.func_179139_a((double)0.02, (double)0.02, (double)0.02);
                fontRenderer.func_78276_b("Acquiring Target...", 0, 0, 0x7F7F7F);
                fontRenderer.func_78276_b(targetAcquireProgress + "%", 37, 28, 12032);
            } else if (this.ticksExisted < -30) {
                GlStateManager.func_179139_a((double)0.03, (double)0.03, (double)0.03);
                this.stat.render(-1, -1, partialTicks);
                fontRenderer.func_78276_b("Lost Target!", 0, 0, 0xFF0000);
            }
        }
        GlStateManager.func_179121_F();
    }

    public boolean isInitialized() {
        return this.ticksExisted >= 120;
    }

    public void addBlockTrackInfo(List<String> textList) {
        for (IBlockTrackEntry blockTrackEntry : this.getApplicableEntries()) {
            blockTrackEntry.addInformation(this.world, this.pos, this.te, textList);
        }
    }

    public boolean isPlayerLooking() {
        return this.playerIsLooking;
    }

    private boolean isPlayerLookingAtTarget() {
        Vec3d vec3 = this.player.func_70676_i(1.0f).func_72432_b();
        Vec3d vec31 = new Vec3d((double)this.pos.func_177958_n() + 0.5 - this.player.field_70165_t, (double)this.pos.func_177956_o() + 0.5 - this.player.field_70163_u - (double)this.player.func_70047_e(), (double)this.pos.func_177952_p() + 0.5 - this.player.field_70161_v);
        double d0 = vec31.func_72433_c();
        double d1 = vec3.func_72430_b(vec31 = vec31.func_72432_b());
        return d1 > 1.0 - 0.025 / d0;
    }

    public void hack() {
        IHackableBlock block;
        if (this.isInitialized() && this.isPlayerLookingAtTarget() && (block = HackableHandler.getHackableForCoord((IBlockAccess)this.world, this.pos, this.player)) != null && (this.hackTime == 0 || this.hackTime > block.getHackTime((IBlockAccess)this.world, this.pos, this.player))) {
            NetworkHandler.sendToServer(new PacketHackingBlockStart(this.pos));
        }
    }

    public void onHackConfirmServer() {
        this.hackTime = 1;
    }

    public int getHackTime() {
        return this.hackTime;
    }

    public boolean scroll(MouseEvent event) {
        if (this.isInitialized() && this.isPlayerLookingAtTarget()) {
            return this.stat.handleMouseWheel(event.getDwheel());
        }
        return false;
    }
}

