/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumaticArmor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.EntityTrackEvent;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.client.gui.pneumaticHelmet.GuiEntityTrackOptions;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.ArmorMessage;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.RenderTarget;
import me.desht.pneumaticcraft.common.CommonHUDHandler;
import me.desht.pneumaticcraft.common.NBTUtil;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.recipes.CraftingRegistrator;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityTrackUpgradeHandler
implements IUpgradeRenderHandler {
    private static final int ENTITY_TRACK_THRESHOLD = 7;
    private static final float ENTITY_TRACKING_RANGE = 16.0f;
    public static final String UPGRADE_NAME = "entityTracker";
    private final List<RenderTarget> targets = new ArrayList<RenderTarget>();
    private final Map<Entity, Integer> targetingEntities = new HashMap<Entity, Integer>();
    private boolean shouldStopSpamOnEntityTracking = false;
    public boolean gaveNotAbleToTrackEntityWarning;
    @SideOnly(value=Side.CLIENT)
    private GuiAnimatedStat entityTrackInfo;
    private int statX;
    private int statY;
    private boolean statLeftSided;

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getUpgradeName() {
        return UPGRADE_NAME;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void update(EntityPlayer player, int rangeUpgrades) {
        ItemStack helmetStack = player.func_184582_a(EntityEquipmentSlot.HEAD);
        String entityFilter = "";
        if (!helmetStack.func_190926_b()) {
            entityFilter = NBTUtil.getString(helmetStack, "entityFilter");
        }
        double entityTrackRange = 16.0f + (float)(rangeUpgrades * 5);
        AxisAlignedBB bbBox = EntityTrackUpgradeHandler.getAABBFromRange(player, rangeUpgrades);
        List mobs = player.field_70170_p.func_72872_a(EntityLivingBase.class, bbBox);
        mobs.remove(player);
        for (EntityLivingBase mob : mobs) {
            if ((double)player.func_70032_d((Entity)mob) > entityTrackRange || !PneumaticCraftUtils.isEntityValidForFilter(entityFilter, (Entity)mob) || MinecraftForge.EVENT_BUS.post((Event)new EntityTrackEvent((Entity)mob))) continue;
            boolean inList = false;
            for (RenderTarget target : this.targets) {
                if (target.entity != mob) continue;
                inList = true;
                target.ticksExisted = Math.abs(target.ticksExisted);
                break;
            }
            if (inList) continue;
            this.targets.add(new RenderTarget((Entity)mob));
            if (mob instanceof EntityMob && this.isEntityWithinPlayerFOV(player, (Entity)mob)) continue;
        }
        for (int j = 0; j < this.targets.size(); ++j) {
            RenderTarget target = this.targets.get(j);
            if (!target.entity.field_70128_L && !((double)player.func_70032_d(target.entity) > entityTrackRange + 5.0) && PneumaticCraftUtils.isEntityValidForFilter(entityFilter, target.entity)) continue;
            if (target.ticksExisted > 0) {
                target.ticksExisted = -60;
                continue;
            }
            if (target.ticksExisted != -1) continue;
            this.targets.remove(target);
            --j;
        }
        if (this.targets.size() > 7) {
            if (!this.shouldStopSpamOnEntityTracking) {
                this.shouldStopSpamOnEntityTracking = true;
                HUDHandler.instance().addMessage(new ArmorMessage("Stopped spam on Entity Tracker", new ArrayList<String>(), 60, 0x7700AA00));
            }
        } else {
            this.shouldStopSpamOnEntityTracking = false;
        }
        ArrayList<String> text = new ArrayList<String>();
        for (RenderTarget target : this.targets) {
            boolean wasNegative = target.ticksExisted < 0;
            target.ticksExisted += CommonHUDHandler.getHandlerForPlayer(player).getSpeedFromUpgrades();
            if (target.ticksExisted >= 0 && wasNegative) {
                target.ticksExisted = -1;
            }
            target.update();
            if (!target.isLookingAtTarget) continue;
            if (target.isInitialized()) {
                text.add(TextFormatting.GRAY + target.entity.func_70005_c_());
                text.addAll(target.getEntityText());
                continue;
            }
            text.add(TextFormatting.GRAY + "Acquiring target...");
        }
        if (text.size() == 0) {
            text.add("Filter mode: " + (entityFilter.equals("") ? "None" : entityFilter));
        }
        this.entityTrackInfo.setText(text);
        Iterator<Map.Entry<Entity, Integer>> iterator = this.targetingEntities.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Entity, Integer> entry = iterator.next();
            Entity entity = entry.getKey();
            if (entry.getValue() >= 0) {
                entry.setValue(entry.getValue() + 1);
            }
            if (!entity.field_70128_L && player.field_70170_p.func_72910_y().contains(entity) && entry.getValue() <= 50) continue;
            iterator.remove();
        }
    }

    public void warnIfNecessary(Entity entity) {
        if (!this.targetingEntities.containsKey(entity)) {
            HUDHandler.instance().addMessage(new ArmorMessage("A mob is targeting you!", new ArrayList<String>(), 60, 0x70FF0000));
        }
        this.targetingEntities.put(entity, -1);
    }

    public void removeTargetingEntity(Entity entity) {
        if (this.targetingEntities.containsKey(entity)) {
            this.targetingEntities.put(entity, 0);
        }
    }

    public static AxisAlignedBB getAABBFromRange(EntityPlayer player, int rangeUpgrades) {
        double entityTrackRange = 16.0f + (float)(Math.min(10, rangeUpgrades) * 5);
        return new AxisAlignedBB(player.field_70165_t - entityTrackRange, player.field_70163_u - entityTrackRange, player.field_70161_v - entityTrackRange, player.field_70165_t + entityTrackRange, player.field_70163_u + entityTrackRange, player.field_70161_v + entityTrackRange);
    }

    private boolean isEntityWithinPlayerFOV(EntityPlayer player, Entity entity) {
        Vec3d vec3 = player.func_70676_i(1.0f).func_72432_b();
        Vec3d vec31 = new Vec3d(entity.field_70165_t - player.field_70165_t, entity.func_174813_aQ().field_72338_b + (double)(entity.field_70131_O / 2.0f) - (player.field_70163_u + (double)player.func_70047_e()), entity.field_70161_v - player.field_70161_v);
        double d0 = vec31.func_72433_c();
        double d1 = vec3.func_72430_b(vec31 = vec31.func_72432_b());
        return d1 > 1.0 - 2.5 / d0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render3D(float partialTicks) {
        for (RenderTarget target : this.targets) {
            target.render(partialTicks, this.shouldStopSpamOnEntityTracking);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render2D(float partialTicks, boolean upgradeEnabled) {
    }

    @Override
    public Item[] getRequiredUpgrades() {
        return new Item[]{Itemss.upgrades.get(IItemRegistry.EnumUpgrade.ENTITY_TRACKER)};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void reset() {
        this.targets.clear();
    }

    @Override
    public float getEnergyUsage(int rangeUpgrades, EntityPlayer player) {
        return 1.0f * (1.0f + (float)Math.min(10, rangeUpgrades) * 5.0f / 16.0f) * (float)CommonHUDHandler.getHandlerForPlayer(player).getSpeedFromUpgrades();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IOptionPage getGuiOptionsPage() {
        return new GuiEntityTrackOptions(this);
    }

    @Override
    public EntityEquipmentSlot getEquipmentSlot() {
        return EntityEquipmentSlot.HEAD;
    }

    @Override
    public void initConfig() {
        this.statX = ConfigHandler.helmetOptions.entityTrackerX;
        this.statY = ConfigHandler.helmetOptions.entityTrackerY;
        this.statLeftSided = ConfigHandler.helmetOptions.entityTrackerLeft;
    }

    @Override
    public void saveToConfig() {
        ConfigHandler.helmetOptions.entityTrackerX = this.statX = this.entityTrackInfo.getBaseX();
        ConfigHandler.helmetOptions.entityTrackerY = this.statY = this.entityTrackInfo.getBaseY();
        ConfigHandler.helmetOptions.entityTrackerLeft = this.statLeftSided = this.entityTrackInfo.isLeftSided();
        ConfigHandler.sync();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiAnimatedStat getAnimatedStat() {
        if (this.entityTrackInfo == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ScaledResolution sr = new ScaledResolution(minecraft);
            this.entityTrackInfo = new GuiAnimatedStat(null, "Current tracked entities:", CraftingRegistrator.getUpgrade(IItemRegistry.EnumUpgrade.ENTITY_TRACKER), this.statX != -1 ? this.statX : sr.func_78326_a() - 2, this.statY, 0x3000AA00, null, this.statLeftSided);
            this.entityTrackInfo.setMinDimensionsAndReset(0, 0);
        }
        return this.entityTrackInfo;
    }

    public List<RenderTarget> getTargets() {
        return this.targets;
    }

    public RenderTarget getTargetForEntity(Entity entity) {
        for (RenderTarget target : this.targets) {
            if (target.entity != entity) continue;
            return target;
        }
        return null;
    }

    public void hack() {
        for (RenderTarget target : this.targets) {
            target.hack();
        }
    }

    public void selectAsDebuggingTarget() {
        for (RenderTarget target : this.targets) {
            target.selectAsDebuggingTarget();
        }
    }

    public boolean scroll(MouseEvent event) {
        for (RenderTarget target : this.targets) {
            if (!target.scroll(event)) continue;
            return true;
        }
        return false;
    }
}

