/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.tubemodule;

import java.awt.Rectangle;
import java.io.IOException;
import me.desht.pneumaticcraft.client.gui.tubemodule.GuiPressureModuleSimple;
import me.desht.pneumaticcraft.client.gui.tubemodule.GuiTubeModule;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.GuiCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.IGuiWidget;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTooltipArea;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.block.tubes.TubeModuleRedstoneReceiving;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;

public class GuiPressureModule
extends GuiTubeModule {
    private GuiTextField lowerBoundField;
    private GuiTextField higherBoundField;
    private int graphLowY;
    private int graphHighY;
    private int graphLeft;
    private int graphRight;
    private Rectangle lowerBoundArea;
    private Rectangle higherBoundArea;
    private boolean grabLower;
    private boolean grabHigher;

    public GuiPressureModule(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        this.ySize = 191;
    }

    public GuiPressureModule(TubeModule module) {
        super(module);
        this.ySize = 191;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xStart = (this.field_146294_l - this.xSize) / 2;
        int yStart = (this.field_146295_m - this.ySize) / 2;
        this.addLabel("lower", this.guiLeft + 10, this.guiTop + 30);
        this.addLabel("bar", this.guiLeft + 45, this.guiTop + 42);
        this.addLabel("higher", this.guiLeft + 140, this.guiTop + 30);
        String title = I18n.func_135052_a((String)("item." + this.module.getType() + ".name"), (Object[])new Object[0]);
        this.addLabel(title, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(title) / 2, this.guiTop + 5);
        this.lowerBoundField = new GuiTextField(-1, this.field_146289_q, xStart + 10, yStart + 41, 30, 10);
        this.lowerBoundField.func_146180_a(PneumaticCraftUtils.roundNumberTo(this.module.lowerBound, 1));
        this.higherBoundField = new GuiTextField(-1, this.field_146289_q, xStart + 140, yStart + 41, 30, 10);
        this.higherBoundField.func_146180_a(PneumaticCraftUtils.roundNumberTo(this.module.higherBound, 1));
        this.graphLowY = this.guiTop + 153;
        this.graphHighY = this.guiTop + 93;
        this.graphLeft = this.guiLeft + 22;
        this.graphRight = this.guiLeft + 172;
        this.addWidget(new WidgetTooltipArea(this.graphLeft - 20, this.graphHighY, 25, this.graphLowY - this.graphHighY, "gui.redstone"));
        this.addWidget(new WidgetTooltipArea(this.graphLeft, this.graphLowY - 5, this.graphRight - this.graphLeft, 25, "gui.threshold"));
        this.addWidget((IGuiWidget)((Object)new GuiAnimatedStat((GuiScreen)this, "gui.tab.info", "pneumaticcraft:textures/gui/gui_info.png", xStart, yStart + 5, -7829249, null, true).setText("gui.tab.info.tubeModule")));
        GuiCheckBox advancedMode = new GuiCheckBox(0, this.guiLeft + 6, this.guiTop + 15, -12566464, "gui.tubeModule.advancedConfig").setTooltip(I18n.func_135052_a((String)"gui.tubeModule.advancedConfig.tooltip", (Object[])new Object[0]));
        advancedMode.checked = true;
        this.addWidget(advancedMode);
        this.higherBoundArea = new Rectangle(this.guiLeft + 11, this.guiTop + 59, 158, 15);
        this.lowerBoundArea = new Rectangle(this.guiLeft + 11, this.guiTop + 73, 158, 15);
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_TUBE_MODULE;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        boolean longer;
        int i;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(this.getTexture());
        int scrollbarLowerBoundX = (int)((float)(this.guiLeft + 16) + 147.0f * (this.module.lowerBound / (this.module.maxValue + 1.0f)));
        int scrollbarHigherBoundX = (int)((float)(this.guiLeft + 16) + 147.0f * (this.module.higherBound / (this.module.maxValue + 1.0f)));
        this.func_73729_b(scrollbarLowerBoundX, this.guiTop + 73, 183, 0, 15, 12);
        this.func_73729_b(scrollbarHigherBoundX, this.guiTop + 59, 183, 0, 15, 12);
        this.lowerBoundField.func_146194_f();
        this.higherBoundField.func_146194_f();
        this.func_73728_b(this.graphLeft, this.graphHighY, this.graphLowY, -16777216);
        for (i = 0; i < 16; ++i) {
            boolean bl = longer = i % 5 == 0;
            if (longer) {
                this.field_146289_q.func_78276_b(i + "", this.graphLeft - 5 - this.field_146289_q.func_78256_a(i + ""), this.graphHighY + (this.graphLowY - this.graphHighY) * (15 - i) / 15 - 3, -16777216);
                this.func_73730_a(this.graphLeft + 4, this.graphRight, this.graphHighY + (this.graphLowY - this.graphHighY) * (15 - i) / 15, i == 0 ? -16777216 : 0x33000000);
            }
            this.func_73730_a(this.graphLeft - (longer ? 5 : 3), this.graphLeft + 3, this.graphHighY + (this.graphLowY - this.graphHighY) * (15 - i) / 15, -16777216);
        }
        for (i = 0; i < 31; ++i) {
            boolean bl = longer = i % 5 == 0;
            if (longer) {
                this.field_146289_q.func_78276_b(i + "", this.graphLeft + (this.graphRight - this.graphLeft) * i / 30 - this.field_146289_q.func_78256_a(i + "") / 2 + 1, this.graphLowY + 6, -16777216);
                this.func_73728_b(this.graphLeft + (this.graphRight - this.graphLeft) * i / 30, this.graphHighY, this.graphLowY - 2, 0x33000000);
            }
            this.func_73728_b(this.graphLeft + (this.graphRight - this.graphLeft) * i / 30, this.graphLowY - 3, this.graphLowY + (longer ? 5 : 3), -16777216);
        }
        if (this.module instanceof TubeModuleRedstoneReceiving) {
            this.module.onNeighborBlockUpdate();
            this.func_73730_a(this.graphLeft + 4, this.graphRight, this.graphHighY + (this.graphLowY - this.graphHighY) * (15 - ((TubeModuleRedstoneReceiving)this.module).getReceivingRedstoneLevel()) / 15, -65536);
            String status = "Current threshold: " + PneumaticCraftUtils.roundNumberTo(((TubeModuleRedstoneReceiving)this.module).getThreshold(), 1) + " bar";
            this.field_146289_q.func_78276_b(status, this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(status) / 2, this.guiTop + 173, -16777216);
        }
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        for (int i2 = 0; i2 < 16; ++i2) {
            double y = this.graphHighY + (this.graphLowY - this.graphHighY) * (15 - i2) / 15;
            double x = (float)this.graphLeft + (float)(this.graphRight - this.graphLeft) * this.module.getThreshold(i2) / 30.0f;
            bufferBuilder.func_181662_b(x, y, 90.0).func_181666_a(0.25f + (float)i2 * 0.05f, 0.0f, 0.0f, 1.0f).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        boolean wasFocused = this.lowerBoundField.func_146206_l();
        this.lowerBoundField.func_146192_a(mouseX, mouseY, mouseButton);
        if (wasFocused && !this.lowerBoundField.func_146206_l()) {
            this.updateBoundFromTextfield(0);
        }
        wasFocused = this.higherBoundField.func_146206_l();
        this.higherBoundField.func_146192_a(mouseX, mouseY, mouseButton);
        if (wasFocused && !this.higherBoundField.func_146206_l()) {
            this.updateBoundFromTextfield(1);
        }
        if (this.lowerBoundArea.contains(mouseX, mouseY)) {
            this.module.lowerBound = (float)(mouseX - 6 - (this.guiLeft + 11)) / 147.0f * this.module.maxValue;
            this.module.lowerBound = Math.min(Math.max(-1.0f, this.module.lowerBound), this.module.maxValue);
            this.grabLower = true;
        } else if (this.higherBoundArea.contains(mouseX, mouseY)) {
            this.module.higherBound = (float)(mouseX - 6 - (this.guiLeft + 11)) / 147.0f * this.module.maxValue;
            this.module.higherBound = Math.min(Math.max(-1.0f, this.module.higherBound), this.module.maxValue);
            this.grabHigher = true;
        }
    }

    private void updateBoundFromTextfield(int fieldId) {
        try {
            switch (fieldId) {
                case 0: {
                    this.module.lowerBound = Float.parseFloat(this.lowerBoundField.func_146179_b());
                    this.module.lowerBound = Math.max(-1.0f, Math.min(this.module.lowerBound, this.module.maxValue));
                    NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module, 0, this.module.lowerBound));
                    break;
                }
                case 1: {
                    this.module.higherBound = Float.parseFloat(this.higherBoundField.func_146179_b());
                    this.module.higherBound = Math.max(-1.0f, Math.min(this.module.higherBound, this.module.maxValue));
                    NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module, 1, this.module.higherBound));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown field id " + fieldId);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.grabLower) {
            this.module.lowerBound = (float)(mouseX - 6 - (this.guiLeft + 11)) / 147.0f * this.module.maxValue;
            this.module.lowerBound = Math.min(Math.max(-1.0f, this.module.lowerBound), this.module.maxValue);
        } else if (this.grabHigher) {
            this.module.higherBound = (float)(mouseX - 6 - (this.guiLeft + 11)) / 147.0f * this.module.maxValue;
            this.module.higherBound = Math.min(Math.max(-1.0f, this.module.higherBound), this.module.maxValue);
        } else {
            super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.grabLower) {
            NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module, 0, this.module.lowerBound));
            this.grabLower = false;
        } else if (this.grabHigher) {
            NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module, 1, this.module.higherBound));
            this.grabHigher = false;
        } else {
            super.func_146286_b(mouseX, mouseY, state);
        }
    }

    @Override
    protected void func_73869_a(char key, int keyCode) throws IOException {
        if (this.lowerBoundField.func_146206_l() && keyCode != 1) {
            this.lowerBoundField.func_146201_a(key, keyCode);
            if (keyCode == 28) {
                this.updateBoundFromTextfield(0);
            }
        } else if (this.higherBoundField.func_146206_l() && keyCode != 1) {
            this.higherBoundField.func_146201_a(key, keyCode);
            if (keyCode == 28) {
                this.updateBoundFromTextfield(1);
            }
        } else {
            super.func_73869_a(key, keyCode);
        }
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        super.actionPerformed(widget);
        if (widget.getID() == 0) {
            this.module.advancedConfig = ((GuiCheckBox)widget).checked;
            NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module, 2, this.module.advancedConfig ? 1.0f : 0.0f));
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (!this.module.advancedConfig) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiPressureModuleSimple(this.module));
        }
        if (!this.lowerBoundField.func_146206_l()) {
            this.lowerBoundField.func_146180_a(PneumaticCraftUtils.roundNumberTo(this.module.lowerBound, 1));
        }
        if (!this.higherBoundField.func_146206_l()) {
            this.higherBoundField.func_146180_a(PneumaticCraftUtils.roundNumberTo(this.module.higherBound, 1));
        }
    }
}

