/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.universalSensor.ISensorSetting;
import me.desht.pneumaticcraft.client.gui.GuiButtonSpecial;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.GuiUtils;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.inventory.ContainerUniversalSensor;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.sensor.SensorHandler;
import me.desht.pneumaticcraft.common.tileentity.TileEntityUniversalSensor;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiUniversalSensor
extends GuiPneumaticContainerBase<TileEntityUniversalSensor> {
    private GuiAnimatedStat sensorInfoStat;
    private GuiTextField nameFilterField;
    private int page;
    private int maxPage;
    private static final int MAX_SENSORS_PER_PAGE = 4;
    private int ticksExisted;

    public GuiUniversalSensor(InventoryPlayer player, TileEntityUniversalSensor te) {
        super(new ContainerUniversalSensor(player, te), te, "pneumaticcraft:textures/gui/gui_universal_sensor.png");
        this.field_147000_g = 239;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        this.sensorInfoStat = this.addAnimatedStat("Sensor Info", new ItemStack(Blockss.UNIVERSAL_SENSOR), -22016, false);
        this.addAnimatedStat("gui.tab.upgrades", "pneumaticcraft:textures/gui/gui_upgrade.png", -16776961, true).setText(this.getUpgradeText());
        this.nameFilterField = new GuiTextField(-1, this.field_146289_q, xStart + 70, yStart + 58, 100, 10);
        this.nameFilterField.func_146180_a(((TileEntityUniversalSensor)this.te).getText(0));
        this.updateButtons();
    }

    @Override
    protected boolean shouldAddUpgradeTab() {
        return false;
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        if (this.maxPage > 1) {
            this.field_146289_q.func_78276_b(this.page + "/" + this.maxPage, 110, 134, 0x404040);
        }
        this.field_146289_q.func_78276_b("Upgr.", 23, 98, 0x404040);
        String[] folders = ((TileEntityUniversalSensor)this.te).getSensorSetting().split("/");
        if (folders.length == 1 && !folders[0].equals("")) {
            Set<Item> requiredItems = SensorHandler.getInstance().getRequiredStacksFromText(folders[0]);
            int curX = 102;
            for (Item requiredItem : requiredItems) {
                GuiUtils.drawItemStack(new ItemStack(requiredItem), curX, 20);
                curX += 18;
            }
        } else {
            this.field_146289_q.func_78276_b(folders[folders.length - 1], 102, 24, 0x404040);
        }
    }

    @Override
    protected Point getInvTextOffset() {
        return new Point(0, 2);
    }

    @Override
    protected void func_146976_a(float opacity, int x, int y) {
        ISensorSetting sensor;
        super.func_146976_a(opacity, x, y);
        if (this.nameFilterField != null) {
            this.nameFilterField.func_146194_f();
        }
        if ((sensor = SensorHandler.getInstance().getSensorFromPath(((TileEntityUniversalSensor)this.te).getSensorSetting())) != null) {
            sensor.drawAdditionalInfo(this.field_146289_q);
        }
    }

    @Override
    protected Point getGaugeLocation() {
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        return new Point(xStart + 34, yStart + this.field_147000_g * 1 / 4);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.nameFilterField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    @Override
    protected void func_73869_a(char par1, int par2) throws IOException {
        if (this.nameFilterField.func_146206_l() && par2 != 1) {
            this.nameFilterField.func_146201_a(par1, par2);
            ((TileEntityUniversalSensor)this.te).setText(0, this.nameFilterField.func_146179_b());
            NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, 0));
        } else {
            super.func_73869_a(par1, par2);
        }
    }

    public void updateButtons() {
        this.field_146292_n.clear();
        this.field_146292_n.add(this.redstoneButton);
        if (!((TileEntityUniversalSensor)this.te).getSensorSetting().equals("")) {
            this.field_146292_n.add(new GuiButton(1, this.field_147003_i + 70, this.field_147009_r + 18, 30, 20, "back"));
        } else {
            this.field_146292_n.add(new GuiButton(-1, this.field_147003_i + 70, this.field_147009_r + 125, 98, 20, I18n.func_135052_a((String)"gui.universalSensor.button.showRange", (Object[])new Object[0])));
        }
        String[] directories = SensorHandler.getInstance().getDirectoriesAtLocation(((TileEntityUniversalSensor)this.te).getSensorSetting());
        this.maxPage = (directories.length - 1) / 4 + 1;
        if (this.page > this.maxPage) {
            this.page = this.maxPage;
        }
        if (this.page < 1) {
            this.page = 1;
        }
        if (this.maxPage > 1) {
            this.field_146292_n.add(new GuiButton(2, this.field_147003_i + 70, this.field_147009_r + 40 + 88, 30, 20, "<--"));
            this.field_146292_n.add(new GuiButton(3, this.field_147003_i + 138, this.field_147009_r + 40 + 88, 30, 20, "-->"));
        }
        int buttonsOnPage = 4;
        if (this.page == this.maxPage && (directories.length % 4 > 0 || directories.length == 0)) {
            buttonsOnPage = directories.length % 4;
        }
        for (int i = 0; i < buttonsOnPage; ++i) {
            String buttonText = directories[i + (this.page - 1) * 4];
            if (SensorHandler.getInstance().getSensorFromPath(((TileEntityUniversalSensor)this.te).getSensorSetting() + "/" + buttonText) != null) {
                buttonText = TextFormatting.YELLOW + buttonText;
            }
            int buttonID = i * 10 + 10 + (this.page - 1) * 4 * 10;
            int buttonX = this.field_147003_i + 70;
            int buttonY = this.field_147009_r + 40 + i * 22;
            int buttonWidth = 98;
            int buttonHeight = 20;
            if (((TileEntityUniversalSensor)this.te).getSensorSetting().equals("")) {
                Set<Item> requiredItems = SensorHandler.getInstance().getRequiredStacksFromText(buttonText);
                GuiButtonSpecial button = new GuiButtonSpecial(buttonID, buttonX, buttonY, buttonWidth, buttonHeight, "");
                ItemStack[] requiredStacks = new ItemStack[requiredItems.size()];
                Iterator<Item> iterator = requiredItems.iterator();
                for (int j = 0; j < requiredStacks.length; ++j) {
                    requiredStacks[j] = new ItemStack(iterator.next());
                }
                button.setRenderStacks(requiredStacks);
                button.field_146124_l = ((TileEntityUniversalSensor)this.te).areGivenUpgradesInserted(requiredItems);
                this.field_146292_n.add(button);
                continue;
            }
            this.field_146292_n.add(new GuiButton(buttonID, buttonX, buttonY, buttonWidth, buttonHeight, buttonText));
        }
        this.sensorInfoStat.setText(this.getSensorInfo());
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(((TileEntityUniversalSensor)this.te).getSensorSetting());
        boolean textboxEnabled = sensor != null && sensor.needsTextBox();
        this.nameFilterField.func_146189_e(textboxEnabled);
        if (!textboxEnabled) {
            this.nameFilterField.func_146195_b(false);
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (((TileEntityUniversalSensor)this.te).getSensorSetting().equals("") && this.ticksExisted++ > 5) {
            this.ticksExisted = 0;
            this.updateButtons();
        }
        if (!this.nameFilterField.func_146206_l()) {
            this.nameFilterField.func_146180_a(((TileEntityUniversalSensor)this.te).getText(0));
        }
    }

    private List<String> getUpgradeText() {
        ArrayList<String> upgradeInfo = new ArrayList<String>();
        upgradeInfo.add("gui.tab.upgrades.volume");
        upgradeInfo.add("gui.tab.upgrades.security");
        upgradeInfo.addAll(SensorHandler.getInstance().getUpgradeInfo());
        return upgradeInfo;
    }

    private List<String> getSensorInfo() {
        ArrayList<String> text = new ArrayList<String>();
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(((TileEntityUniversalSensor)this.te).getSensorSetting());
        if (sensor != null) {
            String[] folders = ((TileEntityUniversalSensor)this.te).getSensorSetting().split("/");
            text.add(TextFormatting.GRAY + folders[folders.length - 1]);
            text.addAll(sensor.getDescription());
        } else {
            text.add(TextFormatting.BLACK + "No sensor selected.");
        }
        return text;
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        if (((TileEntityUniversalSensor)this.te).isSensorActive) {
            pressureStatText.add(TextFormatting.GRAY + "Usage:");
            pressureStatText.add(TextFormatting.BLACK.toString() + 1 + "mL/tick");
        }
    }

    @Override
    protected void addProblems(List<String> textList) {
        super.addProblems(textList);
        if (SensorHandler.getInstance().getSensorFromPath(((TileEntityUniversalSensor)this.te).getSensorSetting()) == null) {
            textList.add(TextFormatting.GRAY + "No sensor selected!");
            textList.add(TextFormatting.BLACK + "Insert upgrades and select the desired sensor.");
        }
        for (int i = 0; i < ((TileEntityUniversalSensor)this.te).getUpgradesInventory().getSlots(); ++i) {
            ItemStack stack = ((TileEntityUniversalSensor)this.te).getUpgradesInventory().getStackInSlot(i);
            if (stack.func_77973_b() != Itemss.GPS_TOOL) continue;
            if (stack.func_77942_o()) {
                NBTTagCompound gpsTag = stack.func_77978_p();
                int toolX = gpsTag.func_74762_e("x");
                int toolY = gpsTag.func_74762_e("y");
                int toolZ = gpsTag.func_74762_e("z");
                if (toolX == 0 && toolY == 0 && toolZ == 0) {
                    textList.add(TextFormatting.GRAY + "The inserted GPS Tool doesn't have a coordinate selected!");
                    textList.add(TextFormatting.BLACK + "Insert a GPS Tool with stored coordinate.");
                    break;
                }
                int sensorRange = ((TileEntityUniversalSensor)this.te).getRange();
                if (Math.abs(toolX - ((TileEntityUniversalSensor)this.te).func_174877_v().func_177958_n()) <= sensorRange && Math.abs(toolY - ((TileEntityUniversalSensor)this.te).func_174877_v().func_177956_o()) <= sensorRange && Math.abs(toolZ - ((TileEntityUniversalSensor)this.te).func_174877_v().func_177952_p()) <= sensorRange) break;
                textList.add(TextFormatting.GRAY + "The stored coordinate in the GPS Tool is out of the Sensor's range!");
                textList.add(TextFormatting.BLACK + "Move the sensor closer, select a closer coordinate or insert Range Upgrades.");
                break;
            }
            textList.add(TextFormatting.GRAY + "The inserted GPS Tool doesn't have a coordinate selected!");
            textList.add(TextFormatting.BLACK + "Insert a GPS Tool with stored coordinate.");
            break;
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 2) {
            --this.page;
            if (this.page <= 0) {
                this.page = this.maxPage;
            }
            this.updateButtons();
        } else if (button.field_146127_k == 3) {
            ++this.page;
            if (this.page > this.maxPage) {
                this.page = 1;
            }
            this.updateButtons();
        } else if (button.field_146127_k == -1) {
            ((TileEntityUniversalSensor)this.te).showRangeLines();
        } else {
            super.func_146284_a(button);
        }
    }
}

