/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.authlib.GameProfile;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiButtonSpecial;
import me.desht.pneumaticcraft.client.gui.GuiSecurityStationBase;
import me.desht.pneumaticcraft.client.gui.NetworkConnectionBackground;
import me.desht.pneumaticcraft.client.gui.NetworkConnectionHandler;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.IGuiWidget;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.inventory.ContainerSecurityStationInventory;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSecurityStationAddUser;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSecurityStationInventory
extends GuiSecurityStationBase {
    private GuiAnimatedStat statusStat;
    private GuiAnimatedStat accessStat;
    private GuiButtonSpecial addButton;
    private GuiButton rebootButton;
    private WidgetTextField sharedUserTextField;
    private List<GuiButtonSpecial> removeUserButtons;
    private NetworkConnectionHandler nodeHandler;

    public GuiSecurityStationInventory(InventoryPlayer player, TileEntitySecurityStation te) {
        super((Container)new ContainerSecurityStationInventory(player, te), te, "pneumaticcraft:textures/gui/gui_security_station.png");
        this.field_147000_g = 239;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        this.statusStat = this.addAnimatedStat("Security Status", new ItemStack(Blockss.SECURITY_STATION), -22016, false);
        this.accessStat = this.addAnimatedStat("Shared Users", new ItemStack(Items.field_151144_bL, 1, 3), -16755456, false);
        Rectangle accessButtonRectangle = this.accessStat.getButtonScaledRectangle(145, 10, 20, 20);
        this.addButton = this.getButtonFromRectangle(1, accessButtonRectangle, "+");
        this.rebootButton = new GuiButton(2, xStart + 110, yStart + 20, 60, 20, "Reboot");
        this.sharedUserTextField = this.getTextFieldFromRectangle(this.accessStat.getButtonScaledRectangle(20, 15, 120, 10));
        this.accessStat.addWidget(this.sharedUserTextField);
        this.accessStat.addWidget(this.addButton);
        this.field_146292_n.add(new GuiButton(3, this.field_147003_i + 108, this.field_147009_r + 103, 64, 20, I18n.func_135052_a((String)"gui.securityStation.test", (Object[])new Object[0])));
        this.field_146292_n.add(this.rebootButton);
        this.field_146292_n.add(new GuiButton(-1, this.field_147003_i + 108, this.field_147009_r + 125, 64, 20, I18n.func_135052_a((String)"gui.universalSensor.button.showRange", (Object[])new Object[0])));
        this.updateUserRemoveButtons();
        this.nodeHandler = new NetworkConnectionBackground(this, (TileEntitySecurityStation)this.te, xStart + 25, yStart + 30, 18, -14540033);
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.field_146289_q.func_78276_b("Network Layout", 15, 12, 0x404040);
        this.field_146289_q.func_78276_b("Upgr.", 133, 52, 0x404040);
    }

    @Override
    protected Point getInvTextOffset() {
        return new Point(0, 2);
    }

    @Override
    protected Point getInvNameOffset() {
        return new Point(0, -2);
    }

    @Override
    protected void func_146976_a(float opacity, int x, int y) {
        super.func_146976_a(opacity, x, y);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.nodeHandler.render();
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.statusStat.setText(this.getStatusText());
        this.accessStat.setTextWithoutCuttingString(this.getAccessText());
        String rebootButtonString = ((TileEntitySecurityStation)this.te).getRebootTime() > 0 ? (((TileEntitySecurityStation)this.te).getRebootTime() % 100 < 50 ? "Rebooting.." : PneumaticCraftUtils.convertTicksToMinutesAndSeconds(((TileEntitySecurityStation)this.te).getRebootTime(), false)) : "Reboot";
        this.rebootButton.field_146126_j = rebootButtonString;
        this.addButton.field_146125_m = this.accessStat.isDoneExpanding();
        for (GuiButton guiButton : this.removeUserButtons) {
            guiButton.field_146124_l = this.accessStat.isDoneExpanding();
        }
        if (this.removeUserButtons.size() != ((TileEntitySecurityStation)this.te).sharedUsers.size()) {
            this.updateUserRemoveButtons();
        }
    }

    @Override
    protected void addProblems(List<String> text) {
        super.addProblems(text);
        if (((TileEntitySecurityStation)this.te).getRebootTime() > 0) {
            text.add(TextFormatting.GRAY + "The Security Station doesn't provide security!");
            text.add(TextFormatting.BLACK + "The station is rebooting (" + PneumaticCraftUtils.convertTicksToMinutesAndSeconds(((TileEntitySecurityStation)this.te).getRebootTime(), false) + ").");
        } else if (((TileEntitySecurityStation)this.te).isHacked()) {
            text.add(TextFormatting.GRAY + "This Station has been hacked!");
            text.add(TextFormatting.BLACK + "Reboot the station.");
        }
        if (!((TileEntitySecurityStation)this.te).hasValidNetwork()) {
            text.add(TextFormatting.GRAY + "Invalid network configuration!");
            switch (((TileEntitySecurityStation)this.te).checkForNetworkValidity()) {
                case NO_SUBROUTINE: {
                    text.add(TextFormatting.BLACK + "Add a Diagnostic Subroutine.");
                    break;
                }
                case NO_IO_PORT: {
                    text.add(TextFormatting.BLACK + "Add a Network IO Port.");
                    break;
                }
                case NO_REGISTRY: {
                    text.add(TextFormatting.BLACK + "Add a Network Registry.");
                    break;
                }
                case TOO_MANY_SUBROUTINES: {
                    text.add(TextFormatting.BLACK + "There can only be one Diagnostic Subroutine.");
                    break;
                }
                case TOO_MANY_IO_PORTS: {
                    text.add(TextFormatting.BLACK + "There can only be one Network IO Port.");
                    break;
                }
                case TOO_MANY_REGISTRIES: {
                    text.add(TextFormatting.BLACK + "There can only be one Network Registry.");
                    break;
                }
                case NO_CONNECTION_SUB_AND_IO_PORT: {
                    text.add(TextFormatting.BLACK + "The Diagnostic Subroutine and the Network IO Port need to be connected in the network.");
                    break;
                }
                case NO_CONNECTION_IO_PORT_AND_REGISTRY: {
                    text.add(TextFormatting.BLACK + "The Network Registry and the Network IO Port need to be connected in the network.");
                }
            }
        }
    }

    private List<String> getStatusText() {
        ArrayList<String> text = new ArrayList<String>();
        text.add(TextFormatting.GRAY + "Protection");
        if (((TileEntitySecurityStation)this.te).getRebootTime() > 0) {
            text.add(TextFormatting.DARK_RED + "No protection because of rebooting!");
        } else if (((TileEntitySecurityStation)this.te).isHacked()) {
            text.add(TextFormatting.DARK_RED + "Hacked by:");
            for (GameProfile hacker : ((TileEntitySecurityStation)this.te).hackedUsers) {
                text.add(TextFormatting.DARK_RED + "-" + hacker.getName());
            }
        } else {
            text.add(TextFormatting.BLACK + "System secure");
        }
        text.add(TextFormatting.GRAY + "Security Level");
        text.add(TextFormatting.BLACK + "Level " + ((TileEntitySecurityStation)this.te).getSecurityLevel());
        text.add(TextFormatting.GRAY + "Intruder Detection Chance");
        text.add(TextFormatting.BLACK.toString() + ((TileEntitySecurityStation)this.te).getDetectionChance() + "%%");
        text.add(TextFormatting.GRAY + "Security Range");
        text.add(TextFormatting.BLACK.toString() + ((TileEntitySecurityStation)this.te).getSecurityRange() + "m (square)");
        return text;
    }

    private List<String> getAccessText() {
        ArrayList<String> textList = new ArrayList<String>();
        textList.add("                                      ");
        textList.add("");
        for (GameProfile user : ((TileEntitySecurityStation)this.te).sharedUsers) {
            textList.add(TextFormatting.BLACK + "-" + user.getName());
        }
        return textList;
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        if (widget.getID() == 1 && !this.sharedUserTextField.func_146179_b().equals("")) {
            NetworkHandler.sendToServer(new PacketSecurityStationAddUser(this.te, this.sharedUserTextField.func_146179_b()));
        }
        super.actionPerformed(widget);
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 2) {
            ((TileEntitySecurityStation)this.te).rebootStation();
        } else if (button.field_146127_k == -1) {
            ((TileEntitySecurityStation)this.te).showRangeLines();
        }
        super.func_146284_a(button);
    }

    @Override
    public void onKeyTyped(IGuiWidget widget) {
        ((TileEntitySecurityStation)this.te).setText(0, this.sharedUserTextField.func_146179_b());
        NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, 0));
    }

    private void updateUserRemoveButtons() {
        if (this.removeUserButtons != null) {
            for (GuiButtonSpecial button : this.removeUserButtons) {
                this.accessStat.removeWidget(button);
            }
        }
        this.removeUserButtons = new ArrayList<GuiButtonSpecial>();
        for (int i = 0; i < ((TileEntitySecurityStation)this.te).sharedUsers.size(); ++i) {
            Rectangle rect = this.accessStat.getButtonScaledRectangle(20, 32 + i * 10, this.field_146289_q.func_78256_a("-" + ((TileEntitySecurityStation)this.te).sharedUsers.get(i).getName()), 8);
            GuiButtonSpecial button = this.getInvisibleButtonFromRectangle(4 + i, rect);
            button.setInvisibleHoverColor(0x44FF0000);
            button.setVisible(false);
            this.accessStat.addWidget(button);
            this.removeUserButtons.add(button);
            if (!((TileEntitySecurityStation)this.te).sharedUsers.get(i).getName().equals(FMLClientHandler.instance().getClient().field_71439_g.func_146103_bH().getName())) continue;
            button.field_146125_m = false;
        }
    }
}

