/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.base.CaseFormat;
import igwmod.api.WikiRegistry;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.client.gui.GuiButtonSpecial;
import me.desht.pneumaticcraft.client.gui.GuiPastebin;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.GuiUnitProgrammer;
import me.desht.pneumaticcraft.client.gui.widget.GuiCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.GuiRadioButton;
import me.desht.pneumaticcraft.client.gui.widget.IGuiWidget;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.inventory.ContainerProgrammer;
import me.desht.pneumaticcraft.common.item.ItemGPSAreaTool;
import me.desht.pneumaticcraft.common.item.ItemGPSTool;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.network.PacketProgrammerUpdate;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCoordinate;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCoordinateOperator;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.progwidgets.WidgetRegistrator;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiProgrammer
extends GuiPneumaticContainerBase<TileEntityProgrammer> {
    private final EntityPlayer player;
    private GuiPastebin pastebinGui;
    private GuiButtonSpecial importButton;
    private GuiButtonSpecial exportButton;
    private GuiButtonSpecial allWidgetsButton;
    private List<GuiRadioButton> difficultyButtons;
    private GuiCheckBox showInfo;
    private GuiCheckBox showFlow;
    private WidgetTextField nameField;
    private WidgetTextField filterField;
    private GuiButtonSpecial undoButton;
    private GuiButtonSpecial redoButton;
    private GuiButtonSpecial convertToRelativeButton;
    private final List<IProgWidget> visibleSpawnWidgets = new ArrayList<IProgWidget>();
    private BitSet filteredSpawnWidgets;
    private GuiUnitProgrammer programmerUnit;
    private boolean wasClicking;
    private boolean wasFocused;
    private IProgWidget draggingWidget;
    private int lastMouseX;
    private int lastMouseY;
    private int dragMouseStartX;
    private int dragMouseStartY;
    private int dragWidgetStartX;
    private int dragWidgetStartY;
    private static final int FAULT_MARGIN = 4;
    private int widgetPage;
    private int maxPage;
    private boolean showingAllWidgets;
    private int showingWidgetProgress;
    private int oldShowingWidgetProgress;
    private static final int PROGRAMMING_START_Y = 17;
    private static final int PROGRAMMING_START_X = 5;
    private static final int PROGRAMMING_WIDTH = 294;
    private static final int PROGRAMMING_HEIGHT = 154;
    private static final int WIDGET_TRAY_RIGHT = 322;
    private static final int WIDGET_X_SPACING = 22;

    public GuiProgrammer(InventoryPlayer player, TileEntityProgrammer te) {
        super(new ContainerProgrammer(player, te), te, "pneumaticcraft:textures/gui/gui_programmer.png");
        this.field_147000_g = 256;
        this.field_146999_f = 350;
        this.player = FMLClientHandler.instance().getClient().field_71439_g;
    }

    private void updateVisibleProgWidgets() {
        int y = 0;
        int page = 0;
        int x = 322 - this.maxPage * 22;
        boolean showAllWidgets = this.showingWidgetProgress == 22 * this.maxPage && this.showingAllWidgets;
        this.filterField.func_146189_e(showAllWidgets);
        this.maxPage = 0;
        this.visibleSpawnWidgets.clear();
        int difficulty = 0;
        for (int i = 0; i < this.difficultyButtons.size(); ++i) {
            if (!this.difficultyButtons.get((int)i).checked) continue;
            difficulty = i;
            break;
        }
        for (IProgWidget widget : WidgetRegistrator.registeredWidgets) {
            if (difficulty < widget.getDifficulty().ordinal()) continue;
            widget.setY(y + 40);
            widget.setX(showAllWidgets ? x : 322);
            int widgetHeight = widget.getHeight() / 2 + (widget.hasStepOutput() ? 5 : 0) + 1;
            y += widgetHeight;
            if (showAllWidgets || page == this.widgetPage) {
                this.visibleSpawnWidgets.add(widget);
            }
            if (y <= this.field_147000_g - 160) continue;
            y = 0;
            x += 22;
            ++page;
            ++this.maxPage;
        }
        this.filterField.field_146209_f = this.field_147003_i + 322 - this.maxPage * 22 - 2;
        this.filterSpawnWidgets();
        if (this.widgetPage > this.maxPage) {
            this.widgetPage = this.maxPage;
            this.updateVisibleProgWidgets();
        }
    }

    private void filterSpawnWidgets() {
        String filterText = this.filterField.func_146179_b().trim();
        if (!this.visibleSpawnWidgets.isEmpty() && !filterText.isEmpty()) {
            this.filteredSpawnWidgets = new BitSet(this.visibleSpawnWidgets.size());
            for (int i = 0; i < this.visibleSpawnWidgets.size(); ++i) {
                IProgWidget widget = this.visibleSpawnWidgets.get(i);
                String widgetName = I18n.func_135052_a((String)("programmingPuzzle." + widget.getWidgetString() + ".name"), (Object[])new Object[0]);
                this.filteredSpawnWidgets.set(i, widgetName.toLowerCase().contains(filterText.toLowerCase()));
            }
        } else {
            this.filteredSpawnWidgets = null;
        }
    }

    @Override
    protected boolean shouldAddInfoTab() {
        return false;
    }

    @Override
    public void func_73866_w_() {
        if (this.pastebinGui != null && this.pastebinGui.outputTag != null) {
            ((TileEntityProgrammer)this.te).readProgWidgetsFromNBT(this.pastebinGui.outputTag);
            this.pastebinGui = null;
            NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
        }
        super.func_73866_w_();
        if (this.programmerUnit != null) {
            ((TileEntityProgrammer)this.te).translatedX = this.programmerUnit.getTranslatedX();
            ((TileEntityProgrammer)this.te).translatedY = this.programmerUnit.getTranslatedY();
            ((TileEntityProgrammer)this.te).zoomState = this.programmerUnit.getLastZoom();
        }
        this.programmerUnit = new GuiUnitProgrammer(((TileEntityProgrammer)this.te).progWidgets, this.field_146289_q, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_146294_l, this.field_146295_m, 5, 17, 294, 154, ((TileEntityProgrammer)this.te).translatedX, ((TileEntityProgrammer)this.te).translatedY, ((TileEntityProgrammer)this.te).zoomState);
        this.addWidget(this.programmerUnit.getScrollBar());
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        this.importButton = new GuiButtonSpecial(1, xStart + 301, yStart + 3, 20, 15, "<--");
        this.importButton.setTooltipText("Import program");
        this.field_146292_n.add(this.importButton);
        this.exportButton = new GuiButtonSpecial(2, xStart + 301, yStart + 20, 20, 15, "-->");
        this.field_146292_n.add(this.exportButton);
        this.field_146292_n.add(new GuiButton(3, xStart + 294, yStart + 174, 10, 10, "-"));
        this.field_146292_n.add(new GuiButton(4, xStart + 335, yStart + 174, 10, 10, "+"));
        this.allWidgetsButton = new GuiButtonSpecial(8, xStart + 321, yStart + 159, 10, 10, "<");
        this.allWidgetsButton.setTooltipText(I18n.func_135052_a((String)"gui.programmer.button.openPanel.tooltip", (Object[])new Object[0]));
        this.addWidget(this.allWidgetsButton);
        this.difficultyButtons = new ArrayList<GuiRadioButton>();
        for (int i = 0; i < IProgWidget.WidgetDifficulty.values().length; ++i) {
            GuiRadioButton radioButton = new GuiRadioButton(i, xStart + 263, yStart + 200 + i * 12, -16777216, IProgWidget.WidgetDifficulty.values()[i].getLocalizedName());
            radioButton.checked = ConfigHandler.getProgrammerDifficulty() == i;
            this.addWidget(radioButton);
            this.difficultyButtons.add(radioButton);
            radioButton.otherChoices = this.difficultyButtons;
            if (i == 1) {
                radioButton.setTooltip(I18n.func_135052_a((String)"gui.programmer.difficulty.medium.tooltip", (Object[])new Object[0]));
            }
            if (i != 2) continue;
            radioButton.setTooltip(I18n.func_135052_a((String)"gui.programmer.difficulty.advanced.tooltip", (Object[])new Object[0]));
        }
        this.field_146292_n.add(new GuiButton(5, xStart + 5, yStart + 175, 87, 20, I18n.func_135052_a((String)"gui.programmer.button.showStart", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(6, xStart + 5, yStart + 197, 87, 20, I18n.func_135052_a((String)"gui.programmer.button.showLatest", (Object[])new Object[0])));
        this.showInfo = new GuiCheckBox(-1, xStart + 5, yStart + 220, -16777216, "gui.programmer.checkbox.showInfo").setChecked(((TileEntityProgrammer)this.te).showInfo);
        this.addWidget(this.showInfo);
        this.showFlow = new GuiCheckBox(-1, xStart + 5, yStart + 232, -16777216, "gui.programmer.checkbox.showFlow").setChecked(((TileEntityProgrammer)this.te).showFlow);
        this.addWidget(this.showFlow);
        GuiButtonSpecial pastebinButton = new GuiButtonSpecial(7, this.field_147003_i - 24, this.field_147009_r + 44, 20, 20, "");
        pastebinButton.setTooltipText(I18n.func_135052_a((String)"gui.remote.button.pastebinButton", (Object[])new Object[0]));
        pastebinButton.setRenderedIcon(Textures.GUI_PASTEBIN_ICON_LOCATION);
        this.field_146292_n.add(pastebinButton);
        this.undoButton = new GuiButtonSpecial(9, this.field_147003_i - 24, this.field_147009_r + 2, 20, 20, "");
        this.redoButton = new GuiButtonSpecial(10, this.field_147003_i - 24, this.field_147009_r + 23, 20, 20, "");
        GuiButtonSpecial clearAllButton = new GuiButtonSpecial(11, this.field_147003_i - 24, this.field_147009_r + 65, 20, 20, "");
        this.convertToRelativeButton = new GuiButtonSpecial(12, this.field_147003_i - 24, this.field_147009_r + 86, 20, 20, "Rel");
        this.undoButton.setRenderedIcon(Textures.GUI_UNDO_ICON_LOCATION);
        this.redoButton.setRenderedIcon(Textures.GUI_REDO_ICON_LOCATION);
        clearAllButton.setRenderedIcon(Textures.GUI_DELETE_ICON_LOCATION);
        this.undoButton.setTooltipText(I18n.func_135052_a((String)"gui.programmer.button.undoButton.tooltip", (Object[])new Object[0]));
        this.redoButton.setTooltipText(I18n.func_135052_a((String)"gui.programmer.button.redoButton.tooltip", (Object[])new Object[0]));
        clearAllButton.setTooltipText(I18n.func_135052_a((String)"gui.programmer.button.clearAllButton.tooltip", (Object[])new Object[0]));
        this.field_146292_n.add(this.undoButton);
        this.field_146292_n.add(this.redoButton);
        this.field_146292_n.add(clearAllButton);
        this.field_146292_n.add(this.convertToRelativeButton);
        String containerName = I18n.func_135052_a((String)(((TileEntityProgrammer)this.te).getName() + ".name"), (Object[])new Object[0]);
        this.addLabel(containerName, this.field_147003_i + 7, this.field_147009_r + 5, -12566464);
        this.nameField = new WidgetTextField(this.field_146289_q, this.field_147003_i + 200, this.field_147009_r + 5, 98, this.field_146289_q.field_78288_b);
        this.addWidget(this.nameField);
        this.filterField = new FilterTextField(this.field_146289_q, this.field_147003_i + 78, this.field_147009_r + 26, 100, this.field_146289_q.field_78288_b);
        this.filterField.setListener(this);
        this.addWidget(this.filterField);
        String name = I18n.func_135052_a((String)"gui.programmer.name", (Object[])new Object[0]);
        this.addLabel(name, this.field_147003_i + 197 - this.field_146289_q.func_78256_a(name), this.field_147009_r + 5, -12566464);
        this.updateVisibleProgWidgets();
    }

    @Override
    protected Point getInvNameOffset() {
        return null;
    }

    @Override
    protected Point getInvTextOffset() {
        return null;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        boolean igwLoaded = Loader.isModLoaded((String)"igwmod");
        this.field_146289_q.func_78276_b(this.widgetPage + 1 + "/" + (this.maxPage + 1), 305, 175, -16777216);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.programmer.difficulty", (Object[])new Object[0]), 263, 191, -16777216);
        if (this.showingWidgetProgress == 0) {
            this.programmerUnit.renderForeground(x, y, this.draggingWidget);
        }
        for (int i = 0; i < this.visibleSpawnWidgets.size(); ++i) {
            IProgWidget widget = this.visibleSpawnWidgets.get(i);
            if (widget == this.draggingWidget || x - this.field_147003_i < widget.getX() || y - this.field_147009_r < widget.getY() || x - this.field_147003_i > widget.getX() + widget.getWidth() / 2 || y - this.field_147009_r > widget.getY() + widget.getHeight() / 2 || this.showingAllWidgets && this.filteredSpawnWidgets != null && !this.filteredSpawnWidgets.get(i)) continue;
            ArrayList<String> tooltip = new ArrayList<String>();
            widget.getTooltip(tooltip);
            if (igwLoaded) {
                tooltip.add(I18n.func_135052_a((String)"gui.programmer.pressIForInfo", (Object[])new Object[0]));
            }
            if (tooltip.size() <= 0) continue;
            this.drawHoveringString(tooltip, x - this.field_147003_i, y - this.field_147009_r, this.field_146289_q);
        }
    }

    @Override
    protected void func_73869_a(char key, int keyCode) throws IOException {
        IProgWidget widget;
        super.func_73869_a(key, keyCode);
        if (this.nameField.func_146206_l() || this.filterField.func_146206_l() && keyCode != 15) {
            return;
        }
        if (23 == keyCode && Loader.isModLoaded((String)"igwmod")) {
            this.onIGWAction();
        }
        if (19 == keyCode && this.exportButton.getBounds().contains(this.lastMouseX, this.lastMouseY)) {
            NetworkHandler.sendToServer(new PacketGuiButton(0));
        }
        if (57 == keyCode || 15 == keyCode) {
            this.toggleShowWidgets();
        }
        if (211 == keyCode && (widget = this.programmerUnit.getHoveredWidget(this.lastMouseX, this.lastMouseY)) != null) {
            ((TileEntityProgrammer)this.te).progWidgets.remove(widget);
            NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
        }
        if (44 == keyCode) {
            NetworkHandler.sendToServer(new PacketGuiButton(this.undoButton.field_146127_k));
        }
        if (21 == keyCode) {
            NetworkHandler.sendToServer(new PacketGuiButton(this.redoButton.field_146127_k));
        }
    }

    @Optional.Method(modid="igwmod")
    private void onIGWAction() {
        int x = this.lastMouseX;
        int y = this.lastMouseY;
        IProgWidget hoveredWidget = this.programmerUnit.getHoveredWidget(x, y);
        if (hoveredWidget != null) {
            WikiRegistry.getWikiHooks().showWikiGui("pneumaticcraft:progwidget/" + CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, hoveredWidget.getWidgetString()));
        }
        for (IProgWidget widget : this.visibleSpawnWidgets) {
            if (widget == this.draggingWidget || x - this.field_147003_i < widget.getX() || y - this.field_147009_r < widget.getY() || x - this.field_147003_i > widget.getX() + widget.getWidth() / 2 || y - this.field_147009_r > widget.getY() + widget.getHeight() / 2) continue;
            WikiRegistry.getWikiHooks().showWikiGui("pneumaticcraft:progwidget/" + CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, widget.getWidgetString()));
        }
    }

    @Override
    protected boolean shouldDrawBackground() {
        return false;
    }

    @Override
    protected void func_146976_a(float partialTicks, int x, int y) {
        IProgWidget widget;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_146276_q_();
        this.bindGuiTexture();
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        GuiProgrammer.func_146110_a((int)xStart, (int)yStart, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)this.field_146999_f, (float)this.field_147000_g);
        this.programmerUnit.getScrollBar().setEnabled(this.showingWidgetProgress == 0);
        super.func_146976_a(partialTicks, x, y);
        if (this.showingWidgetProgress > 0) {
            this.programmerUnit.getScrollBar().setCurrentState(this.programmerUnit.getLastZoom());
        }
        this.programmerUnit.render(x, y, this.showFlow.checked, this.showInfo.checked && this.showingWidgetProgress == 0, this.draggingWidget == null);
        int origX = x;
        int origY = y;
        x -= this.programmerUnit.getTranslatedX();
        y -= this.programmerUnit.getTranslatedY();
        float scale = this.programmerUnit.getScale();
        x = (int)((float)x / scale);
        y = (int)((float)y / scale);
        if (this.showingWidgetProgress > 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.bindGuiTexture();
            int width = this.oldShowingWidgetProgress + (int)((float)(this.showingWidgetProgress - this.oldShowingWidgetProgress) * partialTicks);
            for (int i = 0; i < width; ++i) {
                GuiProgrammer.func_146110_a((int)(xStart + 320 - i), (int)(yStart + 36), (float)323.0f, (float)36.0f, (int)1, (int)136, (float)this.field_146999_f, (float)this.field_147000_g);
            }
            GuiProgrammer.func_146110_a((int)(xStart + 319 - width), (int)(yStart + 36), (float)319.0f, (float)36.0f, (int)2, (int)136, (float)this.field_146999_f, (float)this.field_147000_g);
            if (this.showingAllWidgets && this.draggingWidget != null) {
                this.toggleShowWidgets();
            }
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (int i = 0; i < this.visibleSpawnWidgets.size(); ++i) {
            IProgWidget widget2 = this.visibleSpawnWidgets.get(i);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(widget2.getX() + this.field_147003_i), (float)(widget2.getY() + this.field_147009_r), (float)0.0f);
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
            if (this.showingAllWidgets && this.filteredSpawnWidgets != null && !this.filteredSpawnWidgets.get(i)) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            widget2.render();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.programmerUnit.getTranslatedX(), (float)this.programmerUnit.getTranslatedY(), (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        if (this.draggingWidget != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.draggingWidget.getX() + this.field_147003_i), (float)(this.draggingWidget.getY() + this.field_147009_r), (float)0.0f);
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
            this.draggingWidget.render();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        boolean isLeftClicking = Mouse.isButtonDown((int)0);
        boolean isMiddleClicking = GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74322_I);
        if (this.draggingWidget != null) {
            this.setConnectingWidgetsToXY(this.draggingWidget, x - this.dragMouseStartX + this.dragWidgetStartX - this.field_147003_i, y - this.dragMouseStartY + this.dragWidgetStartY - this.field_147009_r);
        }
        if (isLeftClicking && !this.wasClicking) {
            String var;
            IProgWidget widget3;
            ItemStack heldItem;
            ProgWidgetArea areaToolWidget;
            for (IProgWidget widget4 : this.visibleSpawnWidgets) {
                if (origX < widget4.getX() + this.field_147003_i || origY < widget4.getY() + this.field_147009_r || origX > widget4.getX() + this.field_147003_i + widget4.getWidth() / 2 || origY > widget4.getY() + this.field_147009_r + widget4.getHeight() / 2) continue;
                this.draggingWidget = widget4.copy();
                ((TileEntityProgrammer)this.te).progWidgets.add(this.draggingWidget);
                this.dragMouseStartX = x - (int)((float)this.field_147003_i / scale);
                this.dragMouseStartY = y - (int)((float)this.field_147009_r / scale);
                this.dragWidgetStartX = (int)((float)(widget4.getX() - this.programmerUnit.getTranslatedX()) / scale);
                this.dragWidgetStartY = (int)((float)(widget4.getY() - this.programmerUnit.getTranslatedY()) / scale);
                break;
            }
            ProgWidgetArea progWidgetArea = areaToolWidget = (heldItem = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o()).func_77973_b() instanceof ItemGPSAreaTool ? ItemGPSAreaTool.getArea(heldItem) : null;
            if (this.draggingWidget == null && this.showingWidgetProgress == 0 && (widget3 = this.programmerUnit.getHoveredWidget(origX, origY)) != null) {
                this.draggingWidget = widget3;
                this.dragMouseStartX = x - this.field_147003_i;
                this.dragMouseStartY = y - this.field_147009_r;
                this.dragWidgetStartX = widget3.getX();
                this.dragWidgetStartY = widget3.getY();
                if (areaToolWidget != null && widget3 instanceof ProgWidgetArea) {
                    NBTTagCompound tag = new NBTTagCompound();
                    areaToolWidget.writeToNBT(tag);
                    widget3.readFromNBT(tag);
                } else if (heldItem.func_77973_b() == Itemss.GPS_TOOL) {
                    if (widget3 instanceof ProgWidgetCoordinate) {
                        ((ProgWidgetCoordinate)widget3).loadFromGPSTool(heldItem);
                    } else if (widget3 instanceof ProgWidgetArea) {
                        BlockPos pos = ItemGPSTool.getGPSLocation(heldItem);
                        var = ItemGPSTool.getVariable(heldItem);
                        ((ProgWidgetArea)widget3).setP1(pos);
                        ((ProgWidgetArea)widget3).setP2(new BlockPos(0, 0, 0));
                        ((ProgWidgetArea)widget3).setCoord1Variable(var);
                        ((ProgWidgetArea)widget3).setCoord2Variable("");
                    }
                }
            }
            if (this.draggingWidget == null) {
                if (areaToolWidget != null) {
                    this.draggingWidget = areaToolWidget;
                } else if (heldItem.func_77973_b() == Itemss.GPS_TOOL) {
                    if (PneumaticCraftRepressurized.proxy.isSneakingInGui()) {
                        BlockPos pos = ItemGPSTool.getGPSLocation(heldItem);
                        ProgWidgetArea areaWidget = ProgWidgetArea.fromPositions(pos, new BlockPos(0, 0, 0));
                        var = ItemGPSTool.getVariable(heldItem);
                        if (!var.isEmpty()) {
                            areaWidget.setCoord1Variable(var);
                        }
                        this.draggingWidget = areaWidget;
                    } else {
                        ProgWidgetCoordinate coordWidget = new ProgWidgetCoordinate();
                        this.draggingWidget = coordWidget;
                        coordWidget.loadFromGPSTool(heldItem);
                    }
                }
                if (this.draggingWidget != null) {
                    this.draggingWidget.setX(Integer.MAX_VALUE);
                    this.draggingWidget.setY(Integer.MAX_VALUE);
                    ((TileEntityProgrammer)this.te).progWidgets.add(this.draggingWidget);
                    this.dragMouseStartX = this.draggingWidget.getWidth() / 3;
                    this.dragMouseStartY = this.draggingWidget.getHeight() / 4;
                    this.dragWidgetStartX = 0;
                    this.dragWidgetStartY = 0;
                }
            }
        } else if (isMiddleClicking && !this.wasClicking && this.showingWidgetProgress == 0 && (widget = this.programmerUnit.getHoveredWidget(origX, origY)) != null) {
            this.draggingWidget = widget.copy();
            ((TileEntityProgrammer)this.te).progWidgets.add(this.draggingWidget);
            this.dragMouseStartX = 0;
            this.dragMouseStartY = 0;
            this.dragWidgetStartX = widget.getX() - (x - this.field_147003_i);
            this.dragWidgetStartY = widget.getY() - (y - this.field_147009_r);
            if (PneumaticCraftRepressurized.proxy.isSneakingInGui()) {
                this.copyAndConnectConnectingWidgets(widget, this.draggingWidget);
            }
        }
        if (!isLeftClicking && !isMiddleClicking && this.draggingWidget != null) {
            if (this.programmerUnit.isOutsideProgrammingArea(this.draggingWidget)) {
                this.deleteConnectingWidgets(this.draggingWidget);
            } else {
                this.handlePuzzleMargins();
                if (!this.isValidPlaced(this.draggingWidget)) {
                    this.setConnectingWidgetsToXY(this.draggingWidget, this.dragWidgetStartX, this.dragWidgetStartY);
                    if (this.programmerUnit.isOutsideProgrammingArea(this.draggingWidget)) {
                        this.deleteConnectingWidgets(this.draggingWidget);
                    }
                }
            }
            NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
            TileEntityProgrammer.updatePuzzleConnections(((TileEntityProgrammer)this.te).progWidgets);
            this.draggingWidget = null;
        }
        this.wasClicking = isLeftClicking || isMiddleClicking;
        this.lastMouseX = origX;
        this.lastMouseY = origY;
    }

    private boolean isValidPlaced(IProgWidget widget1) {
        IProgWidget iProgWidget;
        Rectangle draggingRect = new Rectangle(widget1.getX(), widget1.getY(), widget1.getWidth() / 2, widget1.getHeight() / 2);
        for (IProgWidget iProgWidget2 : ((TileEntityProgrammer)this.te).progWidgets) {
            if (iProgWidget2 == widget1 || !draggingRect.intersects(iProgWidget2.getX(), iProgWidget2.getY(), iProgWidget2.getWidth() / 2, iProgWidget2.getHeight() / 2)) continue;
            return false;
        }
        IProgWidget[] parameters = widget1.getConnectedParameters();
        if (parameters != null) {
            for (IProgWidget widget : parameters) {
                if (widget == null || this.isValidPlaced(widget)) continue;
                return false;
            }
        }
        return (iProgWidget = widget1.getOutputWidget()) == null || this.isValidPlaced(iProgWidget);
    }

    private void handlePuzzleMargins() {
        Class<? extends IProgWidget>[] parameters;
        Class<? extends IProgWidget> returnValue = this.draggingWidget.returnType();
        if (returnValue != null) {
            for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                Class<? extends IProgWidget>[] parameters2;
                if (widget == this.draggingWidget || Math.abs(widget.getX() + widget.getWidth() / 2 - this.draggingWidget.getX()) > 4 || (parameters2 = widget.getParameters()) == null) continue;
                for (int i = 0; i < parameters2.length; ++i) {
                    if (!widget.canSetParameter(i) || parameters2[i] != returnValue || Math.abs(widget.getY() + i * 11 - this.draggingWidget.getY()) > 4) continue;
                    this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX() + widget.getWidth() / 2, widget.getY() + i * 11);
                    return;
                }
            }
        }
        if ((parameters = this.draggingWidget.getParameters()) != null) {
            for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                IProgWidget outerPiece = this.draggingWidget;
                if (outerPiece.returnType() != null) {
                    while (outerPiece.getConnectedParameters()[0] != null) {
                        outerPiece = outerPiece.getConnectedParameters()[0];
                    }
                }
                if (widget == this.draggingWidget || Math.abs(outerPiece.getX() + outerPiece.getWidth() / 2 - widget.getX()) > 4) continue;
                if (widget.returnType() != null) {
                    for (int i = 0; i < parameters.length; ++i) {
                        if (!this.draggingWidget.canSetParameter(i) || parameters[i] != widget.returnType() || Math.abs(this.draggingWidget.getY() + i * 11 - widget.getY()) > 4) continue;
                        this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX() - this.draggingWidget.getWidth() / 2 - (outerPiece.getX() - this.draggingWidget.getX()), widget.getY() - i * 11);
                    }
                    continue;
                }
                Class<? extends IProgWidget>[] checkingPieceParms = widget.getParameters();
                if (checkingPieceParms == null) continue;
                for (int i = 0; i < checkingPieceParms.length; ++i) {
                    if (!widget.canSetParameter(i + parameters.length) || checkingPieceParms[i] != parameters[0] || Math.abs(widget.getY() + i * 11 - this.draggingWidget.getY()) > 4) continue;
                    this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX() - this.draggingWidget.getWidth() / 2 - (outerPiece.getX() - this.draggingWidget.getX()), widget.getY() + i * 11);
                }
            }
        }
        if (this.draggingWidget.hasStepInput()) {
            for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                if (!widget.hasStepOutput() || Math.abs(widget.getX() - this.draggingWidget.getX()) > 4 || Math.abs(widget.getY() + widget.getHeight() / 2 - this.draggingWidget.getY()) > 4) continue;
                this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX(), widget.getY() + widget.getHeight() / 2);
            }
        }
        if (this.draggingWidget.hasStepOutput()) {
            for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                if (!widget.hasStepInput() || Math.abs(widget.getX() - this.draggingWidget.getX()) > 4 || Math.abs(widget.getY() - this.draggingWidget.getY() - this.draggingWidget.getHeight() / 2) > 4) continue;
                this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX(), widget.getY() - this.draggingWidget.getHeight() / 2);
            }
        }
    }

    private void setConnectingWidgetsToXY(IProgWidget widget, int x, int y) {
        IProgWidget outputWidget;
        widget.setX(x);
        widget.setY(y);
        IProgWidget[] connectingWidgets = widget.getConnectedParameters();
        if (connectingWidgets != null) {
            for (int i = 0; i < connectingWidgets.length; ++i) {
                if (connectingWidgets[i] == null) continue;
                if (i < connectingWidgets.length / 2) {
                    this.setConnectingWidgetsToXY(connectingWidgets[i], x + widget.getWidth() / 2, y + i * 11);
                    continue;
                }
                int totalWidth = 0;
                IProgWidget branch = connectingWidgets[i];
                while (branch != null) {
                    totalWidth += branch.getWidth() / 2;
                    branch = branch.getConnectedParameters()[0];
                }
                this.setConnectingWidgetsToXY(connectingWidgets[i], x - totalWidth, y + (i - connectingWidgets.length / 2) * 11);
            }
        }
        if ((outputWidget = widget.getOutputWidget()) != null) {
            this.setConnectingWidgetsToXY(outputWidget, x, y + widget.getHeight() / 2);
        }
    }

    private void copyAndConnectConnectingWidgets(IProgWidget original, IProgWidget copy) {
        IProgWidget outputWidget;
        IProgWidget c;
        IProgWidget[] connectingWidgets = original.getConnectedParameters();
        if (connectingWidgets != null) {
            for (int i = 0; i < connectingWidgets.length; ++i) {
                if (connectingWidgets[i] == null) continue;
                c = connectingWidgets[i].copy();
                ((TileEntityProgrammer)this.te).progWidgets.add(c);
                copy.setParameter(i, c);
                this.copyAndConnectConnectingWidgets(connectingWidgets[i], c);
            }
        }
        if ((outputWidget = original.getOutputWidget()) != null) {
            c = outputWidget.copy();
            ((TileEntityProgrammer)this.te).progWidgets.add(c);
            copy.setOutputWidget(c);
            this.copyAndConnectConnectingWidgets(outputWidget, c);
        }
    }

    private void deleteConnectingWidgets(IProgWidget widget) {
        IProgWidget outputWidget;
        ((TileEntityProgrammer)this.te).progWidgets.remove(widget);
        IProgWidget[] connectingWidgets = widget.getConnectedParameters();
        if (connectingWidgets != null) {
            for (IProgWidget widg : connectingWidgets) {
                if (widg == null) continue;
                this.deleteConnectingWidgets(widg);
            }
        }
        if ((outputWidget = widget.getOutputWidget()) != null) {
            this.deleteConnectingWidgets(outputWidget);
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        block0 : switch (button.field_146127_k) {
            case 0: {
                break;
            }
            case 3: {
                if (--this.widgetPage < 0) {
                    this.widgetPage = this.maxPage;
                }
                this.updateVisibleProgWidgets();
                return;
            }
            case 4: {
                if (++this.widgetPage > this.maxPage) {
                    this.widgetPage = 0;
                }
                this.updateVisibleProgWidgets();
                return;
            }
            case 5: {
                for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                    if (!(widget instanceof ProgWidgetStart)) continue;
                    this.programmerUnit.gotoPiece(widget);
                    break;
                }
                return;
            }
            case 6: {
                if (((TileEntityProgrammer)this.te).progWidgets.size() > 0) {
                    this.programmerUnit.gotoPiece(((TileEntityProgrammer)this.te).progWidgets.get(((TileEntityProgrammer)this.te).progWidgets.size() - 1));
                }
                return;
            }
            case 7: {
                NBTTagCompound mainTag = new NBTTagCompound();
                ((TileEntityProgrammer)this.te).writeProgWidgetsToNBT(mainTag);
                this.pastebinGui = new GuiPastebin((GuiScreen)this, mainTag);
                FMLClientHandler.instance().showGuiScreen((Object)this.pastebinGui);
                break;
            }
            case 11: {
                ((TileEntityProgrammer)this.te).progWidgets.clear();
                NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
                break;
            }
            case 12: {
                for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                    if (!(widget instanceof ProgWidgetStart)) continue;
                    this.generateRelativeOperators((ProgWidgetCoordinateOperator)widget.getOutputWidget(), null, false);
                    break block0;
                }
                break;
            }
        }
        NetworkHandler.sendToServer(new PacketGuiButton(button.field_146127_k));
    }

    private void toggleShowWidgets() {
        this.showingAllWidgets = !this.showingAllWidgets;
        this.allWidgetsButton.field_146126_j = this.showingAllWidgets ? ">" : "<";
        this.updateVisibleProgWidgets();
        this.filterField.func_146195_b(this.showingAllWidgets);
    }

    @Override
    public void actionPerformed(IGuiWidget button) {
        if (button == this.allWidgetsButton) {
            this.toggleShowWidgets();
        } else {
            for (int i = 0; i < this.difficultyButtons.size(); ++i) {
                if (!this.difficultyButtons.get((int)i).checked) continue;
                ConfigHandler.setProgrammerDifficulty(i);
                break;
            }
            if (this.showingAllWidgets) {
                this.toggleShowWidgets();
            }
            this.updateVisibleProgWidgets();
        }
    }

    @Override
    public void func_73876_c() {
        boolean isDeviceInserted;
        super.func_73876_c();
        this.undoButton.field_146124_l = ((TileEntityProgrammer)this.te).canUndo;
        this.redoButton.field_146124_l = ((TileEntityProgrammer)this.te).canRedo;
        this.updateConvertRelativeState();
        ItemStack programmedItem = ((TileEntityProgrammer)this.te).getIteminProgrammingSlot();
        this.oldShowingWidgetProgress = this.showingWidgetProgress;
        if (this.showingAllWidgets) {
            int maxProgress = this.maxPage * 22;
            if (this.showingWidgetProgress < maxProgress) {
                this.showingWidgetProgress += 60;
                if (this.showingWidgetProgress >= maxProgress) {
                    this.showingWidgetProgress = maxProgress;
                    this.updateVisibleProgWidgets();
                }
            }
        } else {
            this.showingWidgetProgress -= 60;
            if (this.showingWidgetProgress < 0) {
                this.showingWidgetProgress = 0;
            }
        }
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> warnings = new ArrayList<String>();
        for (IProgWidget w : ((TileEntityProgrammer)this.te).progWidgets) {
            w.addErrors(errors, ((TileEntityProgrammer)this.te).progWidgets);
            w.addWarnings(warnings, ((TileEntityProgrammer)this.te).progWidgets);
        }
        this.importButton.field_146124_l = isDeviceInserted = !programmedItem.func_190926_b();
        this.exportButton.field_146124_l = isDeviceInserted && errors.size() == 0;
        ArrayList<String> exportButtonTooltip = new ArrayList<String>();
        exportButtonTooltip.add("Export program");
        exportButtonTooltip.add(I18n.func_135052_a((String)"gui.programmer.button.export.programmingWhen", (Object[])new Object[]{I18n.func_135052_a((String)("gui.programmer.button.export." + (((TileEntityProgrammer)this.te).redstoneMode == 0 ? "pressingButton" : "onItemInsert")), (Object[])new Object[0])}));
        exportButtonTooltip.add(I18n.func_135052_a((String)"gui.programmer.button.export.pressRToChange", (Object[])new Object[0]));
        if (!programmedItem.func_190926_b()) {
            List<ItemStack> requiredPieces = ((TileEntityProgrammer)this.te).getRequiredPuzzleStacks();
            List<ItemStack> returnedPieces = ((TileEntityProgrammer)this.te).getReturnedPuzzleStacks();
            if (!requiredPieces.isEmpty() || !returnedPieces.isEmpty()) {
                exportButtonTooltip.add("");
            }
            if (!requiredPieces.isEmpty()) {
                exportButtonTooltip.add(I18n.func_135052_a((String)"gui.tooltip.programmable.requiredPieces", (Object[])new Object[0]));
                if (this.player.field_71075_bZ.field_75098_d) {
                    exportButtonTooltip.add("(Creative mode, so the following is free)");
                }
                for (ItemStack stack : requiredPieces) {
                    String prefix;
                    if (((TileEntityProgrammer)this.te).hasEnoughPuzzleStacks(this.player, stack)) {
                        prefix = TextFormatting.GREEN.toString();
                    } else {
                        prefix = TextFormatting.RED.toString();
                        this.exportButton.field_146124_l = this.player.field_71075_bZ.field_75098_d && errors.size() == 0;
                    }
                    exportButtonTooltip.add(prefix + "-" + stack.func_190916_E() + "x " + stack.func_82833_r());
                }
            }
            if (!returnedPieces.isEmpty()) {
                exportButtonTooltip.add("Returned Programming Puzzles:");
                if (this.player.field_71075_bZ.field_75098_d) {
                    exportButtonTooltip.add("(Creative mode, nothing's given)");
                }
                for (ItemStack stack : returnedPieces) {
                    exportButtonTooltip.add("-" + stack.func_190916_E() + "x " + stack.func_82833_r());
                }
            }
        } else {
            exportButtonTooltip.add("No programmable item inserted.");
        }
        if (errors.size() > 0) {
            exportButtonTooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.programmer.errorCount", (Object[])new Object[]{errors.size()}));
        }
        if (warnings.size() > 0) {
            exportButtonTooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.programmer.warningCount", (Object[])new Object[]{warnings.size()}));
        }
        this.exportButton.setTooltipText(exportButtonTooltip);
        if (!programmedItem.func_190926_b()) {
            this.nameField.func_146184_c(true);
            if (!this.nameField.func_146206_l()) {
                if (this.wasFocused) {
                    programmedItem.func_151001_c(this.nameField.func_146179_b());
                    NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, 0));
                }
                this.nameField.func_146180_a(programmedItem.func_82833_r());
                this.wasFocused = false;
            } else {
                this.wasFocused = true;
            }
        } else {
            this.nameField.func_146184_c(false);
            this.nameField.func_146180_a("");
            this.wasFocused = false;
        }
    }

    private void updateConvertRelativeState() {
        this.convertToRelativeButton.field_146124_l = false;
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add("gui.programmer.button.convertToRelative.desc");
        boolean startFound = false;
        for (IProgWidget startWidget : ((TileEntityProgrammer)this.te).progWidgets) {
            if (!(startWidget instanceof ProgWidgetStart)) continue;
            startFound = true;
            IProgWidget widget = startWidget.getOutputWidget();
            if (widget instanceof ProgWidgetCoordinateOperator) {
                ProgWidgetCoordinateOperator operatorWidget = (ProgWidgetCoordinateOperator)widget;
                if (!operatorWidget.getVariable().equals("")) {
                    try {
                        if (this.generateRelativeOperators(operatorWidget, tooltip, true)) {
                            this.convertToRelativeButton.field_146124_l = true;
                            continue;
                        }
                        tooltip.add("gui.programmer.button.convertToRelative.notEnoughRoom");
                    }
                    catch (NullPointerException e) {
                        tooltip.add("gui.programmer.button.convertToRelative.cantHaveVariables");
                    }
                    continue;
                }
                tooltip.add("gui.programmer.button.convertToRelative.noVariableName");
                continue;
            }
            tooltip.add("gui.programmer.button.convertToRelative.noBaseCoordinate");
        }
        if (!startFound) {
            tooltip.add("gui.programmer.button.convertToRelative.noStartPiece");
        }
        ArrayList<String> localizedTooltip = new ArrayList<String>();
        for (String s : tooltip) {
            localizedTooltip.addAll(PneumaticCraftUtils.convertStringIntoList(I18n.func_135052_a((String)s, (Object[])new Object[0]), 40));
        }
        this.convertToRelativeButton.setTooltipText(localizedTooltip);
    }

    private boolean generateRelativeOperators(ProgWidgetCoordinateOperator baseWidget, List<String> tooltip, boolean simulate) {
        BlockPos baseCoord = ProgWidgetCoordinateOperator.calculateCoordinate(baseWidget, 0, baseWidget.getOperator());
        HashMap<BlockPos, String> offsetToVariableNames = new HashMap<BlockPos, String>();
        for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
            ProgWidgetCoordinate coordinate;
            if (widget instanceof ProgWidgetArea) {
                String var;
                BlockPos offset;
                ProgWidgetArea area = (ProgWidgetArea)widget;
                if (area.getCoord1Variable().equals("") && (area.x1 != 0 || area.y1 != 0 || area.z1 != 0)) {
                    offset = new BlockPos(area.x1 - baseCoord.func_177958_n(), area.y1 - baseCoord.func_177956_o(), area.z1 - baseCoord.func_177952_p());
                    var = this.getOffsetVariable(offsetToVariableNames, baseWidget.getVariable(), offset);
                    if (!simulate) {
                        area.setCoord1Variable(var);
                    }
                }
                if (!area.getCoord2Variable().equals("") || area.x2 == 0 && area.y2 == 0 && area.z2 == 0) continue;
                offset = new BlockPos(area.x2 - baseCoord.func_177958_n(), area.y2 - baseCoord.func_177956_o(), area.z2 - baseCoord.func_177952_p());
                var = this.getOffsetVariable(offsetToVariableNames, baseWidget.getVariable(), offset);
                if (simulate) continue;
                area.setCoord2Variable(var);
                continue;
            }
            if (!(widget instanceof ProgWidgetCoordinate) || baseWidget.getConnectedParameters()[0] == widget || (coordinate = (ProgWidgetCoordinate)widget).isUsingVariable()) continue;
            BlockPos c = coordinate.getCoordinate();
            String chunkString = "(" + c.func_177958_n() + ", " + c.func_177956_o() + ", " + c.func_177952_p() + ")";
            if (PneumaticCraftUtils.distBetween((Vec3i)c, 0.0, 0.0, 0.0) < 64.0) {
                if (tooltip == null) continue;
                tooltip.add(I18n.func_135052_a((String)"gui.programmer.button.convertToRelative.coordIsNotChangedWarning", (Object[])new Object[]{chunkString}));
                continue;
            }
            if (tooltip != null) {
                tooltip.add(I18n.func_135052_a((String)"gui.programmer.button.convertToRelative.coordIsChangedWarning", (Object[])new Object[]{chunkString}));
            }
            if (simulate) continue;
            BlockPos offset = new BlockPos(c.func_177958_n() - baseCoord.func_177958_n(), c.func_177956_o() - baseCoord.func_177956_o(), c.func_177952_p() - baseCoord.func_177952_p());
            String var = this.getOffsetVariable(offsetToVariableNames, baseWidget.getVariable(), offset);
            coordinate.setVariable(var);
            coordinate.setUsingVariable(true);
        }
        if (offsetToVariableNames.size() > 0) {
            ProgWidgetCoordinateOperator firstOperator = null;
            ProgWidgetCoordinateOperator prevOperator = baseWidget;
            int x = baseWidget.getX();
            for (Map.Entry entry : offsetToVariableNames.entrySet()) {
                ProgWidgetCoordinateOperator operator = new ProgWidgetCoordinateOperator();
                operator.setVariable((String)entry.getValue());
                int y = prevOperator.getY() + prevOperator.getHeight() / 2;
                operator.setX(x);
                operator.setY(y);
                if (!this.isValidPlaced(operator)) {
                    return false;
                }
                ProgWidgetCoordinate coordinatePiece1 = new ProgWidgetCoordinate();
                coordinatePiece1.setX(x + prevOperator.getWidth() / 2);
                coordinatePiece1.setY(y);
                coordinatePiece1.setVariable(baseWidget.getVariable());
                coordinatePiece1.setUsingVariable(true);
                if (!this.isValidPlaced(coordinatePiece1)) {
                    return false;
                }
                ProgWidgetCoordinate coordinatePiece2 = new ProgWidgetCoordinate();
                coordinatePiece2.setX(x + prevOperator.getWidth() / 2 + coordinatePiece1.getWidth() / 2);
                coordinatePiece2.setY(y);
                coordinatePiece2.setCoordinate((BlockPos)entry.getKey());
                if (!this.isValidPlaced(coordinatePiece2)) {
                    return false;
                }
                if (!simulate) {
                    ((TileEntityProgrammer)this.te).progWidgets.add(operator);
                    ((TileEntityProgrammer)this.te).progWidgets.add(coordinatePiece1);
                    ((TileEntityProgrammer)this.te).progWidgets.add(coordinatePiece2);
                }
                if (firstOperator == null) {
                    firstOperator = operator;
                }
                prevOperator = operator;
            }
            if (!simulate) {
                NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
                TileEntityProgrammer.updatePuzzleConnections(((TileEntityProgrammer)this.te).progWidgets);
            }
            return true;
        }
        return true;
    }

    private String getOffsetVariable(Map<BlockPos, String> offsetToVariableNames, String baseVariable, BlockPos offset) {
        if (offset.equals((Object)new BlockPos(0, 0, 0))) {
            return baseVariable;
        }
        return offsetToVariableNames.computeIfAbsent(offset, k -> "var" + (offsetToVariableNames.size() + 1));
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        GuiScreen screen;
        IProgWidget widget;
        ItemStack programmedItem = ((TileEntityProgrammer)this.te).getIteminProgrammingSlot();
        if (this.nameField.func_146206_l() && !programmedItem.func_190926_b()) {
            programmedItem.func_151001_c(this.nameField.func_146179_b());
            NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, 0));
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 1 && this.showingWidgetProgress == 0 && (widget = this.programmerUnit.getHoveredWidget(mouseX, mouseY)) != null && (screen = widget.getOptionWindow(this)) != null) {
            this.field_146297_k.func_147108_a(screen);
        }
    }

    public void func_146281_b() {
        ((TileEntityProgrammer)this.te).translatedX = this.programmerUnit.getTranslatedX();
        ((TileEntityProgrammer)this.te).translatedY = this.programmerUnit.getTranslatedY();
        ((TileEntityProgrammer)this.te).zoomState = this.programmerUnit.getLastZoom();
        ((TileEntityProgrammer)this.te).showFlow = this.showFlow.checked;
        ((TileEntityProgrammer)this.te).showInfo = this.showInfo.checked;
        super.func_146281_b();
    }

    @Override
    public void onKeyTyped(IGuiWidget widget) {
        if (widget.getID() == this.filterField.getID()) {
            this.filterSpawnWidgets();
        }
    }

    private class FilterTextField
    extends WidgetTextField {
        FilterTextField(FontRenderer fontRenderer, int x, int y, int width, int height) {
            super(fontRenderer, x, y, width, height);
        }

        public void func_146194_f() {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
            super.func_146194_f();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
        }
    }
}

