/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetEnergy;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.common.inventory.ContainerEnergy;
import me.desht.pneumaticcraft.common.tileentity.TileEntityFluxCompressor;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class GuiFluxCompressor
extends GuiPneumaticContainerBase<TileEntityFluxCompressor> {
    private GuiAnimatedStat inputStat;

    public GuiFluxCompressor(Container container, TileEntityFluxCompressor te) {
        super(container, te, "pneumaticcraft:textures/gui/gui_pressure_chamber.png");
    }

    public GuiFluxCompressor(InventoryPlayer inventoryPlayer, TileEntityFluxCompressor te) {
        super(new ContainerEnergy(inventoryPlayer, te), te, "pneumaticcraft:textures/gui/gui_pressure_chamber.png");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.inputStat = this.addAnimatedStat("Input", "pneumaticcraft:textures/gui/gui_buildcraft_energy.png", -11184811, false);
        IEnergyStorage storage = (IEnergyStorage)((TileEntityFluxCompressor)this.te).getCapability(CapabilityEnergy.ENERGY, null);
        this.addWidget(new WidgetEnergy(this.field_147003_i + 20, this.field_147009_r + 20, storage));
        this.addWidget(new WidgetTemperature(0, this.field_147003_i + 87, this.field_147009_r + 20, 273, 675, ((TileEntityFluxCompressor)this.te).getHeatExchangerLogic(null), 325, 625));
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.field_146289_q.func_78276_b("Upgr.", 53, 19, 0x404040);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.inputStat.setText(this.getOutputStat());
    }

    private List<String> getOutputStat() {
        ArrayList<String> textList = new ArrayList<String>();
        textList.add(TextFormatting.GRAY + "Maximum RF usage:");
        textList.add(TextFormatting.BLACK.toString() + ((TileEntityFluxCompressor)this.te).getInfoEnergyPerTick() + " RF/tick");
        textList.add(TextFormatting.GRAY + "Maximum input rate:");
        textList.add(TextFormatting.BLACK.toString() + ((TileEntityFluxCompressor)this.te).getInfoEnergyPerTick() * 2 + " RF/tick");
        textList.add(TextFormatting.GRAY + "Current stored RF:");
        textList.add(TextFormatting.BLACK.toString() + ((TileEntityFluxCompressor)this.te).getInfoEnergyStored() + " RF");
        return textList;
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        pressureStatText.add("\u00a77Max Production:");
        pressureStatText.add("\u00a70" + ((TileEntityFluxCompressor)this.te).getAirRate() + " mL/tick.");
    }

    @Override
    protected void addProblems(List<String> textList) {
        super.addProblems(textList);
        if (((TileEntityFluxCompressor)this.te).getInfoEnergyPerTick() > ((TileEntityFluxCompressor)this.te).getInfoEnergyStored()) {
            textList.add("gui.tab.problems.fluxCompressor.noRF");
        }
        if (((TileEntityFluxCompressor)this.te).getEfficiency() < 100) {
            textList.add(I18n.func_135052_a((String)"gui.tab.problems.advancedAirCompressor.efficiency", (Object[])new Object[]{((TileEntityFluxCompressor)this.te).getEfficiency() + "%%"}));
        }
    }
}

