/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.AreaShowHandler;
import me.desht.pneumaticcraft.client.CamoTECache;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.DroneDebugUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.HUDHandler;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.wrapper.PlayerArmorInvWrapper;

public class AreaShowManager {
    private static AreaShowManager INSTANCE = new AreaShowManager();
    private final Map<BlockPos, AreaShowHandler> showHandlers = new HashMap<BlockPos, AreaShowHandler>();
    private World world;
    private DroneDebugUpgradeHandler droneDebugger;
    private List<BlockPos> cachedPositionProviderData;
    private List<AreaShowHandler> cachedPositionProviderShowers;

    public static AreaShowManager getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        PlayerArmorInvWrapper armor;
        ItemStack helmet;
        Set<BlockPos> posSet;
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = mc.field_71439_g;
        double playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.getPartialTicks();
        double playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.getPartialTicks();
        double playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.getPartialTicks();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-playerX), (double)(-playerY), (double)(-playerZ));
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        for (AreaShowHandler handler : this.showHandlers.values()) {
            handler.render();
        }
        ItemStack curItem = player.func_184614_ca();
        if (curItem.func_77973_b() instanceof IPositionProvider) {
            IPositionProvider positionProvider = (IPositionProvider)curItem.func_77973_b();
            List<BlockPos> posList = positionProvider.getStoredPositions(curItem);
            if (posList != null) {
                if (!posList.equals(this.cachedPositionProviderData)) {
                    TIntObjectHashMap colorsToPositions = new TIntObjectHashMap();
                    for (int i = 0; i < posList.size(); ++i) {
                        int renderColor = positionProvider.getRenderColor(i);
                        if (posList.get(i) == null || renderColor == 0) continue;
                        HashSet<BlockPos> positionsForColor = (HashSet<BlockPos>)colorsToPositions.get(renderColor);
                        if (positionsForColor == null) {
                            positionsForColor = new HashSet<BlockPos>();
                            colorsToPositions.put(renderColor, positionsForColor);
                        }
                        positionsForColor.add(posList.get(i));
                    }
                    this.cachedPositionProviderData = posList;
                    this.cachedPositionProviderShowers = new ArrayList<AreaShowHandler>(colorsToPositions.size());
                    colorsToPositions.forEachEntry((color, positions) -> {
                        this.cachedPositionProviderShowers.add(new AreaShowHandler((Set<BlockPos>)positions, color, positionProvider.disableDepthTest()));
                        return true;
                    });
                }
                this.cachedPositionProviderShowers.forEach(AreaShowHandler::render);
            }
        } else if (curItem.func_77973_b() == Itemss.CAMO_APPLICATOR && !(posSet = CamoTECache.getCamouflageableBlockPos(this.world, (EntityPlayer)player)).isEmpty()) {
            new AreaShowHandler(posSet, 545325055, 0.75, true).render();
        }
        if (curItem.func_77973_b() != Itemss.CAMO_APPLICATOR) {
            CamoTECache.clearCache();
        }
        if ((helmet = (armor = new PlayerArmorInvWrapper(player.field_71071_by)).getStackInSlot(3)).func_77973_b() == Itemss.PNEUMATIC_HELMET) {
            if (this.droneDebugger == null) {
                this.droneDebugger = HUDHandler.instance().getSpecificRenderer(DroneDebugUpgradeHandler.class);
            }
            Set<BlockPos> set = this.droneDebugger.getShowingPositions();
            new AreaShowHandler(set, -1862336512, true).render();
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public AreaShowHandler showArea(BlockPos[] area, int color, TileEntity areaShower) {
        return this.showArea(new HashSet<BlockPos>(Arrays.asList(area)), color, areaShower);
    }

    public AreaShowHandler showArea(Set<BlockPos> area, int color, TileEntity areaShower) {
        if (areaShower == null) {
            return null;
        }
        this.removeHandlers(areaShower);
        AreaShowHandler handler = new AreaShowHandler(area, color, false);
        this.showHandlers.put(new BlockPos(areaShower.func_174877_v().func_177958_n(), areaShower.func_174877_v().func_177956_o(), areaShower.func_174877_v().func_177952_p()), handler);
        return handler;
    }

    public boolean isShowing(TileEntity te) {
        return this.showHandlers.containsKey(new BlockPos(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p()));
    }

    public void removeHandlers(TileEntity te) {
        this.showHandlers.remove(new BlockPos(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p()));
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ClientTickEvent event) {
        EntityPlayer player = PneumaticCraftRepressurized.proxy.getClientPlayer();
        if (player != null) {
            if (player.field_70170_p != this.world) {
                this.world = player.field_70170_p;
                this.showHandlers.clear();
            } else if (event.phase == TickEvent.Phase.END) {
                this.showHandlers.keySet().removeIf(pos -> PneumaticCraftUtils.distBetween((Vec3i)pos, player.field_70165_t, player.field_70163_u, player.field_70161_v) < 32.0 && this.world.func_175623_d(pos));
            }
        }
    }
}

