/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.barrels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import pl.asie.charset.api.lib.IAxisRotatable;
import pl.asie.charset.api.lib.ICacheable;
import pl.asie.charset.api.storage.IBarrel;
import pl.asie.charset.lib.block.ITileWrenchRotatable;
import pl.asie.charset.lib.block.TileBase;
import pl.asie.charset.lib.block.Trait;
import pl.asie.charset.lib.block.TraitLockable;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.capability.CapabilityCache;
import pl.asie.charset.lib.material.ItemMaterial;
import pl.asie.charset.lib.material.ItemMaterialRegistry;
import pl.asie.charset.lib.misc.DoubleClickHandler;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.notify.Notice;
import pl.asie.charset.lib.notify.component.NotificationComponent;
import pl.asie.charset.lib.notify.component.NotificationComponentItemStack;
import pl.asie.charset.lib.notify.component.NotificationComponentString;
import pl.asie.charset.lib.scheduler.Scheduler;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.Orientation;
import pl.asie.charset.lib.utils.ProxiedBlockAccess;
import pl.asie.charset.lib.utils.RayTraceUtils;
import pl.asie.charset.lib.utils.SoundUtils;
import pl.asie.charset.lib.utils.SpaceUtils;
import pl.asie.charset.lib.utils.redstone.RedstoneUtils;
import pl.asie.charset.module.storage.barrels.BarrelUpgrade;
import pl.asie.charset.module.storage.barrels.CharsetStorageBarrels;
import pl.asie.charset.module.storage.barrels.PacketBarrelCountUpdate;

public class TileEntityDayBarrel
extends TileBase
implements IBarrel,
ICacheable,
ITickable,
IAxisRotatable,
ITileWrenchRotatable {
    protected ItemMaterial woodLog;
    protected ItemMaterial woodSlab;
    protected Orientation orientation = Orientation.FACE_UP_POINT_NORTH;
    protected Set<BarrelUpgrade> upgrades = EnumSet.noneOf(BarrelUpgrade.class);
    Object notice_target = this;
    protected final TraitLockable lockable;
    protected final InsertionHandler insertionView = new InsertionHandler();
    protected final ExtractionHandler extractionView = new ExtractionHandler();
    protected final ReadableItemHandler readOnlyView = new ReadableItemHandler();
    protected boolean isEntity;
    private ItemStack item_internal = ItemStack.field_190927_a;
    private CapabilityCache.Single<IItemHandler> helperTop;
    private CapabilityCache.Single<IItemHandler> helperBottom;
    private ProxiedBlockAccess woodLogAccess;
    private static final BarrelUpgrade[][] OLD_TYPE_ORDER = new BarrelUpgrade[][]{new BarrelUpgrade[0], {BarrelUpgrade.SILKY}, {BarrelUpgrade.HOPPING}, new BarrelUpgrade[0], {BarrelUpgrade.STICKY}, {BarrelUpgrade.INFINITE, BarrelUpgrade.HOPPING}};
    private boolean updateRedstoneLevels;
    private int redstoneLevel;
    private int lastMentionedCount = -1;
    private boolean scheduledTick = true;
    private boolean spammed = false;
    private final DoubleClickHandler doubleClickHandler = new DoubleClickHandler();

    public ItemStack getItemUnsafe() {
        return this.item_internal;
    }

    public ItemStack getItemSafe() {
        if (!this.item_internal.func_190926_b() && this.item_internal.func_190916_E() > this.item_internal.func_77976_d()) {
            ItemStack itemCopy = this.item_internal.func_77946_l();
            itemCopy.func_190920_e(this.item_internal.func_77976_d());
            return itemCopy;
        }
        return this.item_internal;
    }

    protected void setItemUnsafe(ItemStack item) {
        this.item_internal = item;
    }

    public boolean isCacheValid() {
        return !this.isEntity && !this.func_145837_r();
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public Collection<BarrelUpgrade> getUpgrades() {
        return this.upgrades;
    }

    public ItemMaterial getTopMaterial() {
        return this.woodSlab;
    }

    public ItemMaterial getSideMaterial() {
        return this.woodLog;
    }

    public TileEntityDayBarrel() {
        this.woodLog = TileEntityDayBarrel.getLog(null);
        this.woodSlab = TileEntityDayBarrel.getSlab(null);
        this.lockable = new TraitLockable((TileEntity)this);
        this.registerTrait("lock", (Trait)this.lockable);
    }

    public static void populateUpgrades(Set<BarrelUpgrade> upgrades, NBTTagCompound compound) {
        if (compound.func_150297_b("upgrades", 9)) {
            NBTTagList upgradeNBT = compound.func_150295_c("upgrades", 8);
            for (int i = 0; i < upgradeNBT.func_74745_c(); ++i) {
                try {
                    BarrelUpgrade type = BarrelUpgrade.valueOf(upgradeNBT.func_150307_f(i));
                    upgrades.add(type);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        } else if (compound.func_150297_b("type", 8)) {
            String s = compound.func_74779_i("type").toUpperCase();
            BarrelUpgrade type = null;
            try {
                type = BarrelUpgrade.valueOf(s);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (s.equals("CREATIVE")) {
                upgrades.add(BarrelUpgrade.HOPPING);
                upgrades.add(BarrelUpgrade.INFINITE);
            } else if (type != null) {
                upgrades.add(type);
            }
        } else if (compound.func_74764_b("type")) {
            upgrades.addAll(Arrays.asList(OLD_TYPE_ORDER[compound.func_74771_c("type")]));
        }
    }

    public void readNBTData(NBTTagCompound compound, boolean isClient) {
        Orientation oldOrientation = this.orientation;
        if (compound.func_150297_b("item", 10)) {
            int nbtItemCount = compound.func_74762_e("count");
            NBTTagCompound itemCpd = compound.func_74775_l("item");
            if (nbtItemCount > 0) {
                itemCpd.func_74774_a("Count", (byte)1);
            }
            ItemStack item = new ItemStack(itemCpd);
            item.func_190920_e(nbtItemCount);
            this.setItemUnsafe(item);
        } else {
            this.setItemUnsafe(ItemStack.field_190927_a);
        }
        this.orientation = Orientation.getOrientation((int)compound.func_74771_c("dir"));
        this.helperTop = null;
        this.helperBottom = null;
        this.upgrades.clear();
        TileEntityDayBarrel.populateUpgrades(this.upgrades, compound);
        this.woodLog = TileEntityDayBarrel.getLog(compound);
        this.woodSlab = TileEntityDayBarrel.getSlab(compound);
        this.lastMentionedCount = this.getItemCount();
        if (isClient && this.orientation != oldOrientation) {
            this.markBlockForRenderUpdate();
        }
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        this.woodLogAccess = null;
        this.helperTop = null;
        this.helperBottom = null;
    }

    public void invalidate(TileBase.InvalidationType type) {
        super.invalidate(type);
        this.woodLogAccess = null;
        this.helperTop = null;
        this.helperBottom = null;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.updateRedstoneLevels = true;
        this.woodLogAccess = new ProxiedBlockAccess((IBlockAccess)this.func_145831_w()){

            @Nullable
            public TileEntity func_175625_s(BlockPos pos) {
                return TileEntityDayBarrel.this.func_174877_v().equals((Object)pos) ? null : this.access.func_175625_s(pos);
            }

            public IBlockState func_180495_p(BlockPos pos) {
                return TileEntityDayBarrel.this.func_174877_v().equals((Object)pos) ? ItemUtils.getBlockState((ItemStack)TileEntityDayBarrel.this.woodLog.getStack()) : this.access.func_180495_p(pos);
            }

            public boolean func_175623_d(BlockPos pos) {
                if (TileEntityDayBarrel.this.func_174877_v().equals((Object)pos)) {
                    IBlockState state = this.func_180495_p(pos);
                    return state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
                }
                return this.access.func_175623_d(pos);
            }

            public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
                return TileEntityDayBarrel.this.func_174877_v().equals((Object)pos) ? this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side) : this.access.isSideSolid(pos, side, _default);
            }
        };
        if (!this.isEntity) {
            Scheduler.INSTANCE.in(this.func_145831_w(), 1, () -> ((TileEntityDayBarrel)this).updateComparators());
        }
    }

    public void updateRedstoneLevel() {
        this.redstoneLevel = 0;
        for (EnumFacing d : EnumFacing.field_82609_l) {
            if (this.isTop(d) || this.isTop(d.func_176734_d())) continue;
            this.redstoneLevel = Math.max(this.redstoneLevel, RedstoneUtils.getRedstonePower((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(d), (EnumFacing)d));
        }
    }

    public NBTTagCompound writeNBTData(NBTTagCompound compound, boolean isClient) {
        if (!this.getItemUnsafe().func_190926_b()) {
            ItemUtils.writeToNBT((ItemStack)this.getItemSafe(), (NBTTagCompound)compound, (String)"item");
            compound.func_74768_a("count", this.getItemUnsafe().func_190916_E());
        } else {
            compound.func_74768_a("count", 0);
        }
        this.woodLog.writeToNBT(compound, "log");
        this.woodSlab.writeToNBT(compound, "slab");
        compound.func_74774_a("dir", (byte)this.orientation.ordinal());
        NBTTagList upgradeNBT = new NBTTagList();
        for (BarrelUpgrade u : this.upgrades) {
            upgradeNBT.func_74742_a((NBTBase)new NBTTagString(u.name()));
        }
        compound.func_74782_a("upgrades", (NBTBase)upgradeNBT);
        return compound;
    }

    public int getLogicSpeed() {
        return 8;
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.updateRedstoneLevels) {
            this.updateRedstoneLevel();
            this.updateRedstoneLevels = false;
        }
        if (this.redstoneLevel > 0 || !this.scheduledTick || this.func_145831_w().func_82737_E() % (long)this.getLogicSpeed() != 0L) {
            return;
        }
        this.tick();
    }

    private void onItemChange(boolean typeChanged) {
        this.sync();
        if (!this.isEntity) {
            this.updateComparators();
        }
        this.markChunkDirty();
    }

    void tick() {
        IItemHandler handler;
        if (!this.upgrades.contains((Object)BarrelUpgrade.HOPPING) || this.orientation == null) {
            return;
        }
        if (this.notice_target == this && this.field_145850_b.func_175676_y(this.field_174879_c) > 0) {
            return;
        }
        boolean itemChanged = false;
        if (this.helperTop == null) {
            this.helperTop = new CapabilityCache.Single(this.field_145850_b, this.func_174877_v().func_177972_a(this.orientation.top), false, true, true, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.orientation.top.func_176734_d());
            this.helperBottom = new CapabilityCache.Single(this.field_145850_b, this.func_174877_v().func_177972_a(this.orientation.top.func_176734_d()), false, true, true, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.orientation.top);
        }
        if (this.getItemCount() < this.getMaxItemCount() && (handler = (IItemHandler)this.helperTop.get()) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack got = handler.extractItem(i, 1, true);
                if (!this.insertionView.insertItem(0, got, true).func_190926_b()) continue;
                got = handler.extractItem(i, 1, false);
                this.insertionView.insertItem(0, got, false);
                itemChanged = true;
            }
        }
        if (this.getExtractableItemCount() > 0 && (handler = (IItemHandler)this.helperBottom.get()) != null) {
            ItemStack toPush = this.getItemUnsafe().func_77946_l();
            toPush.func_190920_e(1);
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack got = handler.insertItem(i, toPush, false);
                if (!got.func_190926_b()) continue;
                if (!this.upgrades.contains((Object)BarrelUpgrade.INFINITE)) {
                    this.getItemUnsafe().func_190918_g(1);
                }
                itemChanged = true;
                break;
            }
        }
        if (itemChanged) {
            this.markChunkDirty();
        }
    }

    private void needLogic() {
        this.scheduledTick = true;
    }

    public void neighborChanged(BlockPos pos, BlockPos fromPos) {
        if (!this.upgrades.contains((Object)BarrelUpgrade.HOPPING)) {
            this.updateRedstoneLevel();
            if (pos.func_177958_n() == fromPos.func_177958_n() && pos.func_177952_p() == fromPos.func_177952_p()) {
                this.needLogic();
            }
        } else if (this.helperTop != null) {
            this.helperTop.neighborChanged(fromPos);
            this.helperBottom.neighborChanged(fromPos);
        }
    }

    public int getItemCount() {
        ItemStack item = this.getItemUnsafe();
        if (item.func_190926_b()) {
            return 0;
        }
        if (this.upgrades.contains((Object)BarrelUpgrade.INFINITE)) {
            return (this.getMaxStacks() + 1) / 2 * item.func_77976_d();
        }
        return item.func_190916_E();
    }

    public ItemStack extractItem(int maxCount, boolean simulate) {
        return this.extractItem(maxCount, simulate, true);
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        return this.insertItem(stack, simulate, true);
    }

    private ItemStack extractItem(int maxCount, boolean simulate, boolean ignoreMaxStackSize) {
        int amt;
        ItemStack item = this.getItemUnsafe();
        if (!item.func_190926_b() && (amt = Math.min(maxCount, this.getExtractableItemCount())) > 0) {
            ItemStack stack = item.func_77946_l();
            stack.func_190920_e(amt);
            if (!simulate && !this.upgrades.contains((Object)BarrelUpgrade.INFINITE)) {
                item.func_190918_g(amt);
                this.onItemChange(item.func_190926_b());
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack insertItem(ItemStack is, boolean simulate, boolean ignoreMaxStackSize) {
        if (is.func_190926_b() || !this.canInsert(is)) {
            return is;
        }
        ItemStack item = this.getItemUnsafe();
        if (this.upgrades.contains((Object)BarrelUpgrade.INFINITE) && !item.func_190926_b()) {
            return is;
        }
        int inserted = Math.min(this.getMaxItemCount() - item.func_190916_E(), is.func_190916_E());
        if (!simulate) {
            if (item.func_190926_b()) {
                item = is.func_77946_l();
                item.func_190920_e(inserted);
                this.setItem(item);
            } else {
                item.func_190917_f(inserted);
                this.onItemChange(false);
            }
        }
        if (inserted == is.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        ItemStack leftover = is.func_77946_l();
        leftover.func_190918_g(inserted);
        return leftover;
    }

    public int getExtractableItemCount() {
        ItemStack item = this.getItemUnsafe();
        if (item.func_190926_b()) {
            return 0;
        }
        if (this.upgrades.contains((Object)BarrelUpgrade.INFINITE)) {
            return item.func_77976_d();
        }
        if (this.upgrades.contains((Object)BarrelUpgrade.STICKY)) {
            return Math.min(item.func_190916_E() - 1, item.func_77976_d());
        }
        return Math.min(item.func_190916_E(), item.func_77976_d());
    }

    public int getMaxStacks() {
        ItemStack item = this.getItemUnsafe();
        int multiplier = 1;
        if (!item.func_190926_b() && CharsetStorageBarrels.stackSizeMultiplierMap.containsKey((Object)item.func_77973_b())) {
            multiplier = CharsetStorageBarrels.stackSizeMultiplierMap.get((Object)item.func_77973_b());
        }
        return 64 * multiplier;
    }

    public int getStackDivisor() {
        ItemStack item = this.getItemUnsafe();
        int multiplier = 1;
        if (!item.func_190926_b() && CharsetStorageBarrels.stackDivisorMultiplierMap.containsKey((Object)item.func_77973_b())) {
            multiplier = CharsetStorageBarrels.stackDivisorMultiplierMap.get((Object)item.func_77973_b());
        }
        return item.func_77976_d() * multiplier;
    }

    public int getMaxDropAmount() {
        ItemStack item = this.getItemUnsafe();
        return CharsetStorageBarrels.maxDroppedStacks * item.func_77976_d();
    }

    public int getMaxItemCount() {
        ItemStack item = this.getItemUnsafe();
        if (!item.func_190926_b()) {
            return item.func_77976_d() * this.getMaxStacks();
        }
        return 64 * this.getMaxStacks();
    }

    public boolean containsUpgrade(String upgradeName) {
        return this.upgrades.contains((Object)BarrelUpgrade.valueOf(upgradeName));
    }

    public boolean itemMatch(ItemStack is) {
        ItemStack item = this.getItemUnsafe();
        if (is.func_190926_b() || item.func_190926_b()) {
            return false;
        }
        return ItemUtils.canMerge((ItemStack)item, (ItemStack)is);
    }

    boolean canInsert(ItemStack is) {
        ItemStack item = this.getItemUnsafe();
        if (is.func_190926_b() || TileEntityDayBarrel.isNested(is)) {
            return false;
        }
        if (item.func_190926_b()) {
            return true;
        }
        return ItemUtils.canMerge((ItemStack)item, (ItemStack)is);
    }

    boolean isTop(EnumFacing d) {
        return this.orientation != null && d == this.orientation.top;
    }

    boolean isTopOrBack(EnumFacing d) {
        return this.orientation != null && (d == this.orientation.top || d == this.orientation.facing.func_176734_d());
    }

    boolean isBottom(EnumFacing d) {
        return this.orientation != null && d == this.orientation.top.func_176734_d();
    }

    boolean isFront(EnumFacing d) {
        return this.orientation != null && d == this.orientation.facing;
    }

    boolean isBack(EnumFacing d) {
        return this.orientation != null && d == this.orientation.facing.func_176734_d();
    }

    public void onPlacedBy(EntityLivingBase placer, @Nullable EnumFacing face, ItemStack stack, float hitX, float hitY, float hitZ) {
        this.orientation = SpaceUtils.getOrientation((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (EntityLivingBase)placer, (EnumFacing)face, (float)hitX, (float)hitY, (float)hitZ);
        this.loadFromStack(stack);
        this.needLogic();
    }

    public void loadFromStack(ItemStack is) {
        ItemStack loadItem;
        NBTTagCompound tag;
        int loadCount;
        this.woodLog = TileEntityDayBarrel.getLog(is.func_77978_p());
        this.woodSlab = TileEntityDayBarrel.getSlab(is.func_77978_p());
        this.upgrades.clear();
        if (is.func_77942_o()) {
            TileEntityDayBarrel.populateUpgrades(this.upgrades, is.func_77978_p());
        }
        if (this.upgrades.contains((Object)BarrelUpgrade.SILKY) && is.func_77942_o() && (loadCount = (tag = is.func_77978_p()).func_74762_e("SilkCount")) > 0 && !(loadItem = TileEntityDayBarrel.getSilkedItem(is)).func_190926_b()) {
            this.setItemUnsafe(loadItem);
        }
    }

    public static ItemStack getSilkedItem(ItemStack is) {
        if (is.func_190926_b() || !is.func_77942_o()) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound tag = is.func_77978_p();
        if (tag.func_150297_b("SilkItem", 10) && tag.func_150297_b("SilkCount", 99)) {
            NBTTagCompound tagSilkItem = tag.func_74775_l("SilkItem");
            int tagSilkCount = tag.func_74762_e("SilkCount");
            if (tagSilkCount > 0) {
                tagSilkItem.func_74774_a("Count", (byte)1);
            }
            ItemStack silkStack = new ItemStack(tagSilkItem);
            silkStack.func_190920_e(tagSilkCount);
            return silkStack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isNested(ItemStack is) {
        return !TileEntityDayBarrel.getSilkedItem(is).func_190926_b();
    }

    void updateCountClients() {
        CharsetStorageBarrels.packet.sendToWatching((Packet)new PacketBarrelCountUpdate(this), (TileEntity)this);
    }

    protected void onCountUpdate(PacketBarrelCountUpdate packet) {
        ItemStack item = this.getItemUnsafe();
        item.func_190920_e(packet.count);
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.sync();
        if (this.upgrades.contains((Object)BarrelUpgrade.HOPPING)) {
            this.needLogic();
        }
    }

    void sync() {
        int c = this.getItemCount();
        if (c != this.lastMentionedCount) {
            if (this.lastMentionedCount * c <= 0) {
                this.markBlockForUpdate();
            } else {
                this.updateCountClients();
            }
            this.lastMentionedCount = c;
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.shouldInsertToSide(facing) || this.shouldExtractFromSide(facing) || facing == null) {
                return true;
            }
        } else {
            if (capability == Capabilities.BARREL) {
                return !this.isFront(facing);
            }
            if (capability == Capabilities.AXIS_ROTATABLE) {
                return facing != null;
            }
        }
        return super.hasCapability(capability, facing);
    }

    public boolean shouldExtractFromSide(EnumFacing side) {
        return this.isBottom(side);
    }

    public boolean shouldInsertToSide(EnumFacing side) {
        return this.isTopOrBack(side);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.shouldExtractFromSide(facing)) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.extractionView);
            }
            if (this.shouldInsertToSide(facing)) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.insertionView);
            }
            if (facing == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.readOnlyView);
            }
        } else {
            if (capability == Capabilities.BARREL) {
                return (T)Capabilities.BARREL.cast((Object)this);
            }
            if (capability == Capabilities.AXIS_ROTATABLE) {
                return (T)Capabilities.AXIS_ROTATABLE.cast((Object)this);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public void clear() {
        this.setItem(ItemStack.field_190927_a);
    }

    public void setItem(ItemStack item) {
        this.setItemUnsafe(item);
        this.onItemChange(true);
    }

    public EnumActionResult insertFromItemHandler(EntityPlayer player, boolean addAll) {
        IItemHandler handler;
        ItemStack item = this.getItemUnsafe();
        boolean hadNoItem = item.func_190926_b();
        int stackCount = addAll ? Integer.MAX_VALUE : 1;
        int inserted = 0;
        ItemStack heldStack = player.func_184614_ca();
        if (!heldStack.func_190926_b() && heldStack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (handler = (IItemHandler)heldStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.extractItem(i, handler.getSlotLimit(i), true);
                if (!this.canInsert(stack)) continue;
                int free = this.getMaxItemCount() - this.getItemCount();
                if (free <= 0) {
                    this.info(player);
                    return EnumActionResult.FAIL;
                }
                int take = Math.min(free, stack.func_190916_E());
                if (!(stack = handler.extractItem(i, take, false)).func_190926_b()) {
                    inserted += stack.func_190916_E();
                    ItemStack remainder = this.insertionView.insertItem(0, stack, false);
                    if (!remainder.func_190926_b()) {
                        remainder.func_190918_g(handler.insertItem(i, remainder, false).func_190916_E());
                        inserted -= remainder.func_190916_E();
                    }
                    --stackCount;
                }
                if (stackCount <= 0) break;
            }
            if (inserted > 0 && hadNoItem) {
                this.markBlockForUpdate();
            }
            return inserted > 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    public boolean activate(EntityPlayer player, EnumFacing side, EnumHand hand) {
        if (this.lockable.get().hasLock()) {
            return false;
        }
        ItemStack item = this.getItemUnsafe();
        ItemStack held = player.func_184586_b(hand);
        if (!this.field_145850_b.field_72995_K && TileEntityDayBarrel.isNested(held) && (item.func_190926_b() || this.itemMatch(held))) {
            new Notice(this.notice_target, (NotificationComponent)NotificationComponentString.translated((String)"notice.charset.barrel.no", (NotificationComponent[])new NotificationComponent[0])).sendTo(player);
            return true;
        }
        if (this.doubleClickHandler.isDoubleClick(player) && !item.func_190926_b()) {
            if (this.addAllItems(player, hand)) {
                this.playSound(player, true);
                return true;
            }
            this.info(player);
            return true;
        }
        this.doubleClickHandler.markLastClick(player);
        if (held.func_190926_b()) {
            this.info(player);
            return true;
        }
        switch (this.insertFromItemHandler(player, false)) {
            case PASS: {
                break;
            }
            case SUCCESS: {
                this.playSound(player, true);
                return true;
            }
            case FAIL: {
                this.info(player);
                return true;
            }
        }
        if (!this.canInsert(held)) {
            this.info(player);
            return true;
        }
        boolean hadNoItem = item.func_190926_b();
        int free = this.getMaxItemCount() - this.getItemCount();
        if (free <= 0) {
            this.info(player);
            return true;
        }
        int take = Math.min(free, held.func_190916_E());
        if (take > 0) {
            ItemStack toInsert = held.func_77946_l();
            toInsert.func_190920_e(take);
            ItemStack leftover = this.insertionView.insertItem(0, toInsert, false);
            if ((take -= leftover.func_190916_E()) > 0) {
                this.playSound(player, true);
                held.func_190918_g(take);
                if (hadNoItem) {
                    this.markBlockForUpdate();
                }
            } else {
                this.info(player);
            }
        }
        return true;
    }

    boolean addAllItems(EntityPlayer player, EnumHand hand) {
        int free_space;
        switch (this.insertFromItemHandler(player, true)) {
            case PASS: {
                break;
            }
            case SUCCESS: {
                return true;
            }
            case FAIL: {
                this.info(player);
                return false;
            }
        }
        ItemStack held = player.func_184586_b(hand);
        InventoryPlayer inv = player.field_71071_by;
        int total_delta = 0;
        for (int i = 0; i < inv.func_70302_i_() && (free_space = this.getMaxItemCount() - (this.getItemCount() + total_delta)) > 0; ++i) {
            ItemStack is = inv.func_70301_a(i);
            if (is.func_190926_b() || !this.itemMatch(is)) continue;
            int toAdd = Math.min(is.func_190916_E(), free_space);
            if (is == held && toAdd > 1) {
                --toAdd;
            }
            total_delta += toAdd;
            is.func_190918_g(toAdd);
        }
        if (total_delta > 0) {
            this.getItemUnsafe().func_190917_f(total_delta);
            this.onItemChange(false);
            player.field_71071_by.func_70296_d();
            return true;
        }
        return false;
    }

    public void click(EntityPlayer player) {
        if (this.lockable.get().hasLock()) {
            return;
        }
        EnumHand hand = EnumHand.MAIN_HAND;
        ItemStack item = this.getItemUnsafe();
        if (item.func_190926_b()) {
            this.info(player);
            return;
        }
        ItemStack origHeldItem = player.func_184586_b(hand);
        if (ForgeHooks.canToolHarvestBlock((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)origHeldItem)) {
            return;
        }
        int removeCount = Math.min(item.func_77976_d(), this.getItemCount());
        if (removeCount <= 0) {
            return;
        }
        if (player.func_70093_af()) {
            removeCount = 1;
        } else if (removeCount == this.getItemCount() && removeCount > 1) {
            --removeCount;
        }
        if (removeCount > 0) {
            BlockPos dropPos = this.func_174877_v();
            RayTraceResult result = RayTraceUtils.getCollision((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (EntityLivingBase)player, (AxisAlignedBB)Block.field_185505_j, (boolean)true);
            dropPos = result != null && result.field_178784_b != null ? dropPos.func_177972_a(result.field_178784_b) : dropPos.func_177972_a(this.orientation.facing);
            if (this.upgrades.contains((Object)BarrelUpgrade.INFINITE)) {
                if (player.func_70093_af() && player.field_71075_bZ.field_75098_d) {
                    this.clear();
                } else {
                    this.giveOrSpawnItem(player, dropPos, removeCount);
                }
            } else {
                this.giveOrSpawnItem(player, dropPos, removeCount);
                item.func_190918_g(removeCount);
                this.onItemChange(false);
            }
        }
    }

    protected void playSound(EntityPlayer player, boolean isPlace) {
        if (!this.field_145850_b.field_72995_K) {
            SoundUtils.playSoundRemote((EntityPlayer)player, (Vec3d)new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5), (double)64.0, (SoundEvent)this.getSoundType().func_185845_c(), (SoundCategory)SoundCategory.BLOCKS, (float)((this.getSoundType().func_185843_a() + 1.0f) / (isPlace ? 3.0f : 2.0f)), (float)(this.getSoundType().func_185847_b() * (isPlace ? 0.6f : 0.8f)));
        }
    }

    protected void giveOrSpawnItem(EntityPlayer player, BlockPos dropPos, int removeCount) {
        IItemHandler handler;
        ItemStack stack = this.makeStack(removeCount);
        ItemStack heldStack = player.func_184614_ca();
        if (!heldStack.func_190926_b() && heldStack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (handler = (IItemHandler)heldStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            stack = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
        }
        if (!stack.func_190926_b()) {
            ItemUtils.giveOrSpawnItemEntity((EntityPlayer)player, (World)this.field_145850_b, (Vec3d)new Vec3d((Vec3i)dropPos).func_72441_c(0.5, 0.5, 0.5), (ItemStack)stack, (float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f, (boolean)true);
        }
    }

    void info(EntityPlayer entityplayer) {
        new Notice(this.notice_target, msg -> {
            if (this.getItemUnsafe().func_190926_b()) {
                msg.setMessage((NotificationComponent)NotificationComponentString.translated((String)"notice.charset.barrel.empty", (NotificationComponent[])new NotificationComponent[0]));
            } else {
                int count;
                String countMsg = this.upgrades.contains((Object)BarrelUpgrade.INFINITE) ? "notice.charset.barrel.infinite" : ((count = this.getItemCount()) >= this.getMaxItemCount() ? "notice.charset.barrel.full" : "" + count);
                msg.setMessage((NotificationComponent)NotificationComponentString.translated((String)"%1$s %2$s", (NotificationComponent[])new NotificationComponent[]{NotificationComponentString.translated((String)countMsg, (NotificationComponent[])new NotificationComponent[0]), new NotificationComponentItemStack(this.getItemUnsafe(), true, true)}));
            }
        }).sendTo(entityplayer);
    }

    private ItemStack makeStack(int count) {
        ItemStack item = this.getItemUnsafe();
        if (item.func_190926_b() || count <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = item.func_77946_l();
        ret.func_190920_e(count);
        assert (ret.func_190916_E() > 0 && ret.func_190916_E() <= item.func_77976_d());
        return ret;
    }

    public int getComparatorValue(int maxV) {
        int count = this.getItemCount();
        if (count <= 0) {
            return 0;
        }
        int max = this.getMaxItemCount();
        if (count >= max) {
            return maxV;
        }
        float v = (float)count / (float)max;
        return (int)Math.max(1.0, Math.floor(v * (float)maxV));
    }

    public List<ItemStack> getContentDrops(boolean silkTouch) {
        if (this.upgrades.contains((Object)BarrelUpgrade.INFINITE) || this.upgrades.contains((Object)BarrelUpgrade.SILKY) && silkTouch) {
            return Collections.emptyList();
        }
        ItemStack item = this.getItemUnsafe();
        if (item.func_190926_b()) {
            return Collections.emptyList();
        }
        int count = Math.min(this.getItemCount(), this.getMaxDropAmount());
        if (count <= 0) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int prev_count = 0;
        while (prev_count != count && count > 0) {
            int toDrop = Math.min(item.func_77976_d(), count);
            ItemStack dropStack = item.func_77946_l();
            dropStack.func_190920_e(toDrop);
            stacks.add(dropStack);
            prev_count = count;
            count -= toDrop;
        }
        return stacks;
    }

    public void getDrops(NonNullList<ItemStack> stacks, IBlockState state, int fortune, boolean silkTouch) {
        stacks.add((Object)this.getDroppedBlock(silkTouch));
        stacks.addAll(this.getContentDrops(silkTouch));
    }

    public boolean canLose() {
        return !this.getItemUnsafe().func_190926_b() && !this.upgrades.contains((Object)BarrelUpgrade.INFINITE) && this.getItemCount() > this.getMaxDropAmount();
    }

    public static ItemStack makeDefaultBarrel(Set<BarrelUpgrade> upgrades) {
        return TileEntityDayBarrel.makeBarrel(upgrades, ItemMaterialRegistry.INSTANCE.getDefaultMaterialByType("log"), ItemMaterialRegistry.INSTANCE.getDefaultMaterialByType("slab"));
    }

    public static ItemStack makeBarrel(Set<BarrelUpgrade> upgrades, ItemMaterial log, ItemMaterial slab) {
        ItemStack stack = new ItemStack((Item)CharsetStorageBarrels.barrelItem);
        NBTTagCompound compound = ItemUtils.getTagCompound((ItemStack)stack, (boolean)true);
        compound.func_74778_a("log", log.getId());
        compound.func_74778_a("slab", slab.getId());
        if (upgrades.size() > 0) {
            NBTTagList list = new NBTTagList();
            for (BarrelUpgrade u : upgrades) {
                list.func_74742_a((NBTBase)new NBTTagString(u.name()));
            }
            compound.func_74782_a("upgrades", (NBTBase)list);
        }
        return stack;
    }

    public static ItemMaterial getLog(NBTTagCompound tag) {
        return ItemMaterialRegistry.INSTANCE.getMaterial(tag, "log", "log");
    }

    public static ItemMaterial getSlab(NBTTagCompound tag) {
        return ItemMaterialRegistry.INSTANCE.getMaterial(tag, "slab", "slab");
    }

    static ItemStack addUpgrade(ItemStack barrel, BarrelUpgrade upgrade) {
        NBTTagList list;
        NBTTagCompound tag = ItemUtils.getTagCompound((ItemStack)barrel, (boolean)true);
        if (!tag.func_74764_b("upgrades")) {
            list = new NBTTagList();
        } else {
            list = tag.func_150295_c("upgrades", 8);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                if (!list.func_150307_f(i).equals(upgrade.name())) continue;
                return barrel;
            }
        }
        list.func_74742_a((NBTBase)new NBTTagString(upgrade.name()));
        if (list.func_74745_c() > 0) {
            tag.func_74782_a("upgrades", (NBTBase)list);
        }
        return barrel;
    }

    private boolean changeOrientation(Orientation newOrientation, boolean simulate) {
        if (this.orientation != newOrientation) {
            if (!simulate) {
                this.orientation = newOrientation;
                this.helperTop = null;
                this.helperBottom = null;
                this.markBlockForUpdate();
                this.func_145831_w().func_175722_b(this.field_174879_c, this.func_145838_q(), true);
            }
            return true;
        }
        return false;
    }

    public void func_189668_a(Mirror mirror) {
        this.changeOrientation(this.orientation.mirror(mirror), false);
    }

    public boolean rotateAround(EnumFacing axis, boolean simulate) {
        return this.changeOrientation(this.orientation.rotateAround(axis), simulate);
    }

    public boolean rotateWrench(EnumFacing axis) {
        Orientation newOrientation = axis == this.orientation.facing ? this.orientation.getNextRotationOnFace() : Orientation.getOrientation((int)(Orientation.fromDirection((EnumFacing)axis).ordinal() & 0xFFFFFFFC));
        this.changeOrientation(newOrientation, false);
        return true;
    }

    public ItemStack getPickedBlock(@Nullable EntityPlayer player, @Nullable RayTraceResult result, IBlockState state) {
        if (player == null || !player.func_70093_af()) {
            return this.getDroppedBlock(state);
        }
        return this.getItemSafe();
    }

    public ItemStack getDroppedBlock(IBlockState state) {
        return this.getDroppedBlock(false);
    }

    public ItemStack getDroppedBlock(boolean silkTouch) {
        ItemStack is = TileEntityDayBarrel.makeBarrel(this.upgrades, this.woodLog, this.woodSlab);
        if (this.upgrades.contains((Object)BarrelUpgrade.SILKY) && !this.getItemUnsafe().func_190926_b() && silkTouch) {
            NBTTagCompound tag = is.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                is.func_77982_d(tag);
            }
            tag.func_74768_a("SilkCount", this.getItemCount());
            NBTTagCompound si = new NBTTagCompound();
            this.getItemSafe().func_77955_b(si);
            tag.func_74782_a("SilkItem", (NBTBase)si);
        }
        return is;
    }

    public boolean canHarvest(EntityPlayer player) {
        if (this.getItemUnsafe().func_190926_b()) {
            return true;
        }
        if (player == null || !player.func_184812_l_()) {
            return true;
        }
        if (player.field_70170_p.field_72995_K) {
            player.func_184609_a(EnumHand.MAIN_HAND);
        } else {
            this.click(player);
        }
        return false;
    }

    public boolean isWooden() {
        try {
            return this.woodLog.getTypes().contains("wood");
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getFlamability(EnumFacing face) {
        try {
            return ItemUtils.getBlockState((ItemStack)this.woodLog.getStack()).func_177230_c().getFlammability((IBlockAccess)this.woodLogAccess, this.func_174877_v(), face);
        }
        catch (Exception e) {
            return this.isWooden() ? 20 : 0;
        }
    }

    public boolean isFlammable(EnumFacing face) {
        try {
            return ItemUtils.getBlockState((ItemStack)this.woodLog.getStack()).func_177230_c().isFlammable((IBlockAccess)this.woodLogAccess, this.func_174877_v(), face);
        }
        catch (Exception e) {
            return this.isWooden();
        }
    }

    public int getFireSpreadSpeed(EnumFacing face) {
        try {
            return ItemUtils.getBlockState((ItemStack)this.woodLog.getStack()).func_177230_c().getFireSpreadSpeed((IBlockAccess)this.woodLogAccess, this.func_174877_v(), face);
        }
        catch (Exception e) {
            return this.isWooden() ? 5 : 0;
        }
    }

    public SoundType getSoundType() {
        try {
            if (this.isTop(EnumFacing.UP) || this.isBottom(EnumFacing.UP)) {
                return ItemUtils.getBlockState((ItemStack)this.woodSlab.getStack()).func_177230_c().func_185467_w();
            }
            return ItemUtils.getBlockState((ItemStack)this.woodLog.getStack()).func_177230_c().func_185467_w();
        }
        catch (Exception e) {
            return SoundType.field_185848_a;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasFastRenderer() {
        ItemStack i = this.getItemUnsafe();
        return i.func_190926_b();
    }

    public class ExtractionHandler
    extends BaseItemHandler {
        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return TileEntityDayBarrel.this.extractItem(amount, simulate, false);
        }
    }

    public class ReadableItemHandler
    extends BaseItemHandler {
        @Override
        public ItemStack getStackInSlot(int slot) {
            ItemStack item = TileEntityDayBarrel.this.getItemUnsafe();
            if (item.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            int count = item.func_190916_E() - slot * item.func_77976_d();
            if (count <= 0) {
                return ItemStack.field_190927_a;
            }
            if (count > item.func_77976_d()) {
                count = item.func_77976_d();
            }
            ItemStack stack = item.func_77946_l();
            stack.func_190920_e(count);
            return stack;
        }

        @Override
        public int getSlots() {
            return TileEntityDayBarrel.this.getMaxStacks();
        }
    }

    public class InsertionHandler
    extends BaseItemHandler {
        @Override
        public ItemStack getStackInSlot(int slot) {
            ItemStack stack = TileEntityDayBarrel.this.getItemUnsafe();
            int cutoff = TileEntityDayBarrel.this.getMaxItemCount() - stack.func_77976_d();
            if (stack.func_190926_b() || stack.func_190916_E() < cutoff) {
                return ItemStack.field_190927_a;
            }
            stack = stack.func_77946_l();
            stack.func_190920_e(stack.func_190916_E() - cutoff);
            if (stack.func_190916_E() > stack.func_77976_d()) {
                stack.func_190920_e(stack.func_77976_d());
            }
            return stack;
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack is, boolean simulate) {
            return TileEntityDayBarrel.this.insertItem(is, simulate, false);
        }
    }

    public abstract class BaseItemHandler
    implements ICacheable,
    IItemHandler {
        public ItemStack getStackInSlot(int slot) {
            return TileEntityDayBarrel.this.getItemSafe();
        }

        public int getSlots() {
            return 1;
        }

        public int getSlotLimit(int slot) {
            ItemStack item = TileEntityDayBarrel.this.getItemUnsafe();
            return !item.func_190926_b() ? item.func_77976_d() : 64;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public boolean isCacheValid() {
            return TileEntityDayBarrel.this.isCacheValid();
        }
    }
}

