/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.barrels;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import pl.asie.charset.lib.block.BlockBase;
import pl.asie.charset.lib.item.ISubItemProvider;
import pl.asie.charset.lib.item.SubItemProviderCache;
import pl.asie.charset.lib.item.SubItemProviderRecipes;
import pl.asie.charset.lib.item.SubItemSetHelper;
import pl.asie.charset.lib.utils.UnlistedPropertyGeneric;
import pl.asie.charset.module.storage.barrels.BarrelCacheInfo;
import pl.asie.charset.module.storage.barrels.BarrelUpgrade;
import pl.asie.charset.module.storage.barrels.CharsetStorageBarrels;
import pl.asie.charset.module.storage.barrels.TileEntityDayBarrel;

public class BlockBarrel
extends BlockBase
implements ITileEntityProvider {
    private static final List<Set<BarrelUpgrade>> CREATIVE_TAB_UPGRADE_SETS = ImmutableList.of(EnumSet.noneOf(BarrelUpgrade.class), EnumSet.of(BarrelUpgrade.STICKY), EnumSet.of(BarrelUpgrade.HOPPING), EnumSet.of(BarrelUpgrade.HOPPING, BarrelUpgrade.STICKY), EnumSet.of(BarrelUpgrade.SILKY));
    public static final IUnlistedProperty<BarrelCacheInfo> BARREL_INFO = new UnlistedPropertyGeneric("info", BarrelCacheInfo.class);

    public BlockBarrel() {
        super(Material.field_151575_d);
        this.setComparatorInputOverride(true);
        this.func_149711_c(2.5f);
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149663_c("charset.barrel");
    }

    @Nullable
    private ImmutableList<ItemStack> generateTypeSet(ItemStack barrel) {
        TileEntityDayBarrel rep = new TileEntityDayBarrel();
        rep.loadFromStack(barrel);
        if (rep.upgrades.size() > 0) {
            return null;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Set<BarrelUpgrade> upgrades : CREATIVE_TAB_UPGRADE_SETS) {
            boolean allowed = true;
            for (BarrelUpgrade upgrade : upgrades) {
                if (CharsetStorageBarrels.isEnabled(upgrade)) continue;
                allowed = false;
                break;
            }
            if (!allowed) continue;
            rep.upgrades = upgrades;
            builder.add((Object)rep.getDroppedBlock(CharsetStorageBarrels.barrelBlock.func_176223_P()));
        }
        return builder.build();
    }

    protected ISubItemProvider createSubItemProvider() {
        return new SubItemProviderCache((ISubItemProvider)new SubItemProviderRecipes(() -> CharsetStorageBarrels.barrelItem){

            protected int compareSets(List<ItemStack> first, List<ItemStack> second) {
                return SubItemSetHelper.wrapLists(first, second, (Comparator)SubItemSetHelper.extractMaterial((String)"log", SubItemSetHelper::sortByItem));
            }

            protected List<ItemStack> createForcedItems() {
                return CharsetStorageBarrels.CREATIVE_BARRELS;
            }

            @Nullable
            protected List<ItemStack> createSetFor(ItemStack stack) {
                return BlockBarrel.this.generateTypeSet(stack);
            }
        });
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDayBarrel) {
            ((TileEntityDayBarrel)tile).neighborChanged(pos, fromPos);
        }
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDayBarrel && ((TileEntityDayBarrel)tile).upgrades.contains((Object)BarrelUpgrade.INFINITE)) {
            return -1.0f;
        }
        return this.field_149782_v;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDayBarrel) {
            return ((TileEntityDayBarrel)tile).getFlamability(face);
        }
        return 0;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDayBarrel) {
            return ((TileEntityDayBarrel)tile).isFlammable(face);
        }
        return false;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDayBarrel) {
            return ((TileEntityDayBarrel)tile).getFireSpreadSpeed(face);
        }
        return 0;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityDayBarrel();
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{BARREL_INFO});
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDayBarrel && !((TileEntityDayBarrel)tile).canHarvest(player)) {
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world == null || world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDayBarrel) {
            return ((TileEntityDayBarrel)tile).activate(player, side, hand);
        }
        return false;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer playerIn) {
        if (world == null || world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDayBarrel) {
            ((TileEntityDayBarrel)tile).click(playerIn);
        }
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityDayBarrel barrel = (TileEntityDayBarrel)world.func_175625_s(pos);
        IExtendedBlockState extendedBS = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        if (barrel != null) {
            return extendedBS.withProperty(BARREL_INFO, (Object)BarrelCacheInfo.from(barrel));
        }
        return extendedBS;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.SOLID;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDayBarrel) {
            return ((TileEntityDayBarrel)tile).getSoundType();
        }
        return SoundType.field_185848_a;
    }
}

