/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.barrels;

import java.util.Set;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import pl.asie.charset.lib.material.ItemMaterialRegistry;
import pl.asie.charset.lib.render.model.IRenderComparable;
import pl.asie.charset.lib.utils.Orientation;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.module.storage.barrels.BarrelUpgrade;
import pl.asie.charset.module.storage.barrels.TileEntityDayBarrel;

class BarrelCacheInfo
implements IRenderComparable<BarrelCacheInfo> {
    final TextureAtlasSprite log;
    final TextureAtlasSprite plank;
    final Set<BarrelUpgrade> upgrades;
    final Orientation orientation;
    final boolean isMetal;
    final transient ItemStack logStack;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BarrelCacheInfo cacheInfo = (BarrelCacheInfo)o;
        if (this.isMetal != cacheInfo.isMetal) {
            return false;
        }
        if (!this.log.equals(cacheInfo.log)) {
            return false;
        }
        if (!this.plank.equals(cacheInfo.plank)) {
            return false;
        }
        if (!this.upgrades.equals(cacheInfo.upgrades)) {
            return false;
        }
        return this.orientation == cacheInfo.orientation;
    }

    public int hashCode() {
        int result = this.log.hashCode();
        result = 31 * result + this.plank.hashCode();
        result = 31 * result + this.orientation.hashCode();
        result = 31 * result + (this.isMetal ? 1 : 0);
        return result;
    }

    private BarrelCacheInfo(TextureAtlasSprite log, ItemStack logStack, TextureAtlasSprite plank, Set<BarrelUpgrade> upgrade, Orientation orientation, boolean isMetal) {
        this.log = log;
        this.logStack = logStack;
        this.plank = plank;
        this.upgrades = upgrade;
        this.orientation = orientation;
        this.isMetal = isMetal;
    }

    public static BarrelCacheInfo from(TileEntityDayBarrel barrel) {
        TextureAtlasSprite log = RenderUtils.getItemSprite((ItemStack)barrel.woodLog.getStack());
        TextureAtlasSprite slab = RenderUtils.getItemSprite((ItemStack)barrel.woodSlab.getStack());
        return new BarrelCacheInfo(log, barrel.woodLog.getStack(), slab, barrel.upgrades, barrel.orientation, BarrelCacheInfo.isMetal(barrel.woodLog.getStack()));
    }

    public static BarrelCacheInfo from(ItemStack is) {
        TileEntityDayBarrel barrel = new TileEntityDayBarrel();
        barrel.loadFromStack(is);
        barrel.orientation = Orientation.FACE_NORTH_POINT_UP;
        return BarrelCacheInfo.from(barrel);
    }

    static boolean isMetal(ItemStack it) {
        if (it == null) {
            return true;
        }
        return !ItemMaterialRegistry.INSTANCE.matches(it, new String[]{"wood"});
    }

    public boolean renderEquals(BarrelCacheInfo other) {
        return this.equals(other);
    }

    public int renderHashCode() {
        return this.hashCode();
    }
}

